/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.sync;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.device.INetconfPoller;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.syncdata.AbstractFeatureSyncHandler;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.FullSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.IncreaseSyncTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnTarget;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.netconf.service.TargetType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class L3vpnSyncHandler
extends AbstractFeatureSyncHandler {
    private static final Class<?>[] VRF_CHILDREN = new Class[]{L3vpnInstance.class, L3vpnIf.class, VpnInstAF.class, VpnTarget.class};
    private final LinkedHashSet<Class<? extends VmfMO>> moTypes = new LinkedHashSet();

    public L3vpnSyncHandler() {
        this.moTypes.add(L3vpnInstance.class);
    }

    private static String getVrfName(VmfMO vrfChildMO) {
        return (String)ReflectHelper.getInstance().getPropertyValue((Object)vrfChildMO, "vrfName");
    }

    public FeatureName getFeatureName() {
        return FeatureName.L3VPN;
    }

    public LinkedHashSet<Class<? extends VmfMO>> getTopMoClasses() {
        return this.moTypes;
    }

    protected void fullSyncPreProcess(FullSyncTranslationContext translationContext) throws VMFException {
        super.fullSyncPreProcess(translationContext);
        this.filterPublicVrf(translationContext.getContext());
    }

    protected void incrSyncDynamicStatus(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        IMOChangeRecord changedRecord = incrSyncContext.getContext().getChangeRecord(VpnInstAF.class);
        if (changedRecord == null || CollectionUtils.isEmpty((Collection)changedRecord.getCreates())) {
            return;
        }
        QuerySchemaTranslatorContext querySchemaContext = new QuerySchemaTranslatorContext(incrSyncContext.getDevID());
        for (VpnInstAF vrfAF : changedRecord.getCreates()) {
            L3vpnInstance vrf = new L3vpnInstance();
            Utility.INSTANCE.setMoDevID((VmfMO)vrfAF, (VmfMO)vrf);
            vrf.setVrfName(vrfAF.getVrfName());
            querySchemaContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrfAF, Arrays.asList("vrfStatus"));
        }
        INetconfPoller poller = DeviceAccessorFactory.getNetconfPoller((int)incrSyncContext.getDevID(), (TargetType)TargetType.RDB);
        poller.query(querySchemaContext);
    }

    protected void incrSyncPreProcess(IncreaseSyncTranslationContext incrSyncContext) throws VMFException {
        super.incrSyncPreProcess(incrSyncContext);
        this.processNewVrfIf(incrSyncContext.getContext());
        this.filterPublicVrf(incrSyncContext.getContext());
    }

    private void filterPublicVrf(Context context) {
        for (Class<?> childType : VRF_CHILDREN) {
            this.filterPublicVrfChildMO(context, childType);
        }
    }

    private void filterPublicVrfChildMO(Context context, Class<?> vrfChildType) {
        if (context == null) {
            return;
        }
        IMOChangeRecord changeRecord = context.getChangeRecord(vrfChildType);
        if (changeRecord == null || changeRecord.getCreates() == null) {
            return;
        }
        ArrayList<VmfMO> toCancel = new ArrayList<VmfMO>();
        for (VmfMO vrfChild : changeRecord.getCreates()) {
            if (!"_public_".equals(L3vpnSyncHandler.getVrfName(vrfChild))) continue;
            toCancel.add(vrfChild);
        }
        for (VmfMO vrfChild : toCancel) {
            changeRecord.cancelCreate((Object)vrfChild);
        }
    }

    private void processNewVrfIf(Context context) throws VMFException {
        if (context == null) {
            return;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Set toCreated = context.getChangeRecord(L3vpnIf.class).getCreates();
        if (CollectionUtils.isEmpty((Collection)toCreated)) {
            return;
        }
        Collection toDeleted = dao.queryByFields(L3vpnIf.class, new String[]{"devID", "vrID", "ifName"}, (Collection)toCreated, true);
        if (CollectionUtils.isEmpty((Collection)toDeleted)) {
            return;
        }
        context.addChangeRecord(L3vpnIf.class).addDelete(toDeleted);
    }
}

