/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnTunnelInfo;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnTunnel;
import com.huawei.vmf.adapter.fservice.l3vpn.service.IVrfService;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.RsvpTeTunnel;
import com.huawei.vmf.adapter.fservice.mpls.model.StaticTunnel;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class VrfService
implements IVrfService {
    public Map<StaticTunnel, Collection<VmfMO>> getVpnByTunnelKey(Collection<StaticTunnel> staticTunnel) {
        if (CollectionUtils.isEmpty(staticTunnel)) {
            return null;
        }
        HashMap<StaticTunnel, Collection<VmfMO>> mapMo = new HashMap<StaticTunnel, Collection<VmfMO>>();
        ArrayList<VpnTunnel> vrfTunnels = new ArrayList<VpnTunnel>();
        HashMap<String, StaticTunnel> mapTunnel = new HashMap<String, StaticTunnel>();
        for (StaticTunnel obj : staticTunnel) {
            VpnTunnel tunnel = new VpnTunnel();
            tunnel.setDevID(obj.getDevID());
            tunnel.setVrID(obj.getVrID());
            tunnel.setTunnelName(obj.getTunnelName());
            vrfTunnels.add(tunnel);
            mapTunnel.put(obj.getDevID() + obj.getTunnelName(), obj);
        }
        Collection vrfdb = new ArrayList();
        try {
            IDao dao = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, new Context());
            vrfdb = dao.queryByFields(VpnTunnel.class, new String[]{"devID", "vrID", "tunnelName"}, vrfTunnels, false);
        }
        catch (VMFException e) {
            return null;
        }
        if (CollectionUtils.isEmpty(vrfTunnels)) {
            return null;
        }
        for (VpnTunnel obj : vrfdb) {
            L3vpnInstance vrf = new L3vpnInstance();
            vrf.setDevID(obj.getDevID());
            vrf.setVrID(obj.getVrID());
            vrf.setVrfName(obj.getVrfName());
            String key = obj.getDevID() + obj.getTunnelName();
            if (mapMo.containsKey(mapTunnel.get(key))) {
                if (CollectionUtils.containsInstance((Collection)((Collection)mapMo.get(mapTunnel.get(key))), (Object)vrf)) continue;
                ((Collection)mapMo.get(mapTunnel.get(key))).add(vrf);
                continue;
            }
            ArrayList<L3vpnInstance> mos = new ArrayList<L3vpnInstance>();
            mos.add(vrf);
            mapMo.put((StaticTunnel)mapTunnel.get(key), (Collection<VmfMO>)mos);
        }
        return mapMo;
    }

    public Collection<L3vpnInstance> queryVrfBingTunnel(Collection<String> vrfFdns) throws VMFException {
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        LinkedList<L3vpnInstance> vrfs = new LinkedList<L3vpnInstance>();
        for (String fdn : vrfFdns) {
            vrfs.add(fdnParser.getIndexMo(fdn));
        }
        this.getVrfBindingTunnelFromDev(vrfs);
        this.addTunnel2VrfKeyRef(vrfs);
        return vrfs;
    }

    private void addTunnel2VrfKeyRef(Collection<L3vpnInstance> vrfs) {
        for (L3vpnInstance vrf : vrfs) {
            if (CollectionUtils.isEmpty((Collection)vrf.getVpnInstAFs())) continue;
            for (VpnInstAF af : vrf.getVpnInstAFs()) {
                if (CollectionUtils.isEmpty((Collection)af.getL3vpnTunnelInfos())) continue;
                for (L3vpnTunnelInfo tunnelInfo : af.getL3vpnTunnelInfos()) {
                    if (StringUtil.isEmpty((String)tunnelInfo.getTunnelName())) continue;
                    RsvpTeTunnel tunnelKey = new RsvpTeTunnel();
                    tunnelKey.setDevID(af.getDevID());
                    tunnelKey.setVrID(af.getVrID());
                    tunnelKey.setTunnelName(tunnelInfo.getTunnelName());
                    vrf.addKeyRefMo((VmfMO)tunnelKey);
                }
            }
        }
    }

    private void getVrfBindingTunnelFromDev(Collection<L3vpnInstance> vrfs) throws VMFException {
        if (CollectionUtils.isEmpty(vrfs)) {
            return;
        }
        DefaultMOService pollService = new DefaultMOService();
        for (L3vpnInstance vrf : vrfs) {
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(vrf.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(vrf.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            VpnInstAF vrfAF = new VpnInstAF();
            Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)vrfAF, (VmfMO)vrf);
            vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
            vrf.addVpnInstAFs(Arrays.asList(vrfAF));
            L3vpnTunnelInfo tunnelInfo = new L3vpnTunnelInfo();
            tunnelInfo.setDevID(vrfAF.getDevID());
            tunnelInfo.setVrID(vrfAF.getVrID());
            tunnelInfo.setVrfName(vrfAF.getVrfName());
            tunnelInfo.setAfType(vrfAF.getAfType());
            vrfAF.addL3vpnTunnelInfos(Arrays.asList(tunnelInfo));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrf, Arrays.asList("vpnInstAFs"));
            queryContext.addQueryAttributes(FeatureName.L3VPN, (VmfMO)vrfAF, Arrays.asList("l3vpnTunnelInfos"));
        }
        pollService.poll();
    }
}

