/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.service;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultMOConflictChecker;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.Activator;
import com.huawei.vmf.adapter.l3vpn.dao.L3vpnDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class VrfConflictCheckerInterface
extends DefaultMOConflictChecker<L3vpnInstance> {
    private final Logger logger = LoggerFactory.getLogger(VrfConflictCheckerInterface.class);

    public VrfConflictCheckerInterface() {
        super(L3vpnInstance.class);
    }

    public static Collection<L3vpnIf> queryBindVrfSaps(Collection<L3vpnIf> ifNames) throws VMFException {
        if (CollectionUtils.isEmpty(ifNames)) {
            return Collections.emptyList();
        }
        Collection<L3vpnIf> bindIfs = L3vpnDao.newInstance().queryBindVrfIf(ifNames);
        if (CollectionUtils.isEmpty(bindIfs)) {
            return Collections.emptyList();
        }
        Iterator<L3vpnIf> it = bindIfs.iterator();
        while (it.hasNext()) {
            if (!"_public_".equals(it.next().getVrfName())) continue;
            it.remove();
        }
        return bindIfs;
    }

    private static void setMOOperResult(OperResult operResult, int errorCode, Collection<L3vpnInstance> vrfs) {
        for (L3vpnInstance mo : vrfs) {
            operResult.addMoOperResult((VmfMO)mo, errorCode);
        }
    }

    public OperResult checkModify(Collection<L3vpnInstance> mos, Context context) {
        OperResult operResult = super.checkModify(mos, context);
        IMOChangeRecord mocChangeRecord = context.getChangeRecord(L3vpnInstance.class);
        IMOChangeRecord vrfIfcChangeRecord = context.getChangeRecord(L3vpnIf.class);
        if (null == mocChangeRecord || !mocChangeRecord.hasModify() || null == vrfIfcChangeRecord) {
            return operResult;
        }
        HashMap<String, L3vpnInstance> ifName2vrf = new HashMap<String, L3vpnInstance>();
        ArrayList<L3vpnIf> ifNames = new ArrayList<L3vpnIf>();
        for (L3vpnInstance vrf : mos) {
            if (operResult.hasFailed((VmfMO)vrf) || !mocChangeRecord.isModified((Object)vrf, "l3vpnIfs") || CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) continue;
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                if (!vrfIfcChangeRecord.isCreated((Object)vrfIf)) continue;
                L3vpnIf ifName = new L3vpnIf();
                ifName.setDevID(vrf.getDevID());
                ifName.setVrID(vrf.getVrID());
                ifName.setIfName(vrfIf.getIfName());
                ifName2vrf.put(ifName.getDevID() + "_" + ifName.getVrID() + "_" + ifName.getIfName(), vrf);
                ifNames.add(ifName);
            }
        }
        try {
            for (L3vpnIf bindIf : VrfConflictCheckerInterface.queryBindVrfSaps(ifNames)) {
                L3vpnInstance vrf = (L3vpnInstance)ifName2vrf.get(bindIf.getDevID() + "_" + bindIf.getVrID() + "_" + bindIf.getIfName());
                if (null == vrf) continue;
                this.logger.error(bindIf.getIfName() + " has bind with " + bindIf.getVrfName());
                operResult.addMoOperResult((VmfMO)vrf, 555799289);
            }
            this.checkIPAddress(context);
        }
        catch (VMFException e) {
            VrfConflictCheckerInterface.setMOOperResult(operResult, e.getErrorCode(), ifName2vrf.values());
            this.logger.error("queryBindVrfSaps failed", (Throwable)e);
        }
        return operResult;
    }

    private void checkIPAddress(Context context) throws VMFException {
        IMOChangeRecord vrfIfcChangeRecord = context.getChangeRecord(L3vpnIf.class);
        if (null == vrfIfcChangeRecord) {
            return;
        }
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        Set creates = vrfIfcChangeRecord.getCreates();
        for (L3vpnIf l3vpnIf : creates) {
            Interface ifn = new Interface();
            ifn.setDevID(l3vpnIf.getDevID());
            ifn.setVrID(l3vpnIf.getVrID());
            ifn.setIfName(l3vpnIf.getIfName());
            interfaces.add(ifn);
        }
        if (CollectionUtils.isEmpty(interfaces)) {
            return;
        }
        IInterfaceService service = Activator.getService(IInterfaceService.class);
        service.checkIpAddressForL3vpn(interfaces, (Object)context);
    }

    public OperResult checkPredeploy(Collection<L3vpnInstance> mos, Context context) {
        OperResult operResult = super.checkCreate(mos, context);
        HashMap<String, L3vpnInstance> ifName2vrf = new HashMap<String, L3vpnInstance>();
        ArrayList<L3vpnIf> ifNames = new ArrayList<L3vpnIf>();
        for (L3vpnInstance vrf : mos) {
            if (operResult.hasFailed((VmfMO)vrf) || CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) continue;
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                L3vpnIf ifName = new L3vpnIf();
                ifName.setDevID(vrf.getDevID());
                ifName.setVrID(vrf.getVrID());
                ifName.setIfName(vrfIf.getIfName());
                ifName2vrf.put(ifName.getDevID() + "_" + ifName.getVrID() + "_" + ifName.getIfName(), vrf);
                ifNames.add(ifName);
            }
        }
        try {
            for (L3vpnIf bindIf : VrfConflictCheckerInterface.queryBindVrfSaps(ifNames)) {
                L3vpnInstance vrf = (L3vpnInstance)ifName2vrf.get(bindIf.getDevID() + "_" + bindIf.getVrID() + "_" + bindIf.getIfName());
                if (null == vrf) continue;
                this.logger.error(bindIf.getIfName() + " has bind with " + bindIf.getVrfName());
                operResult.addMoOperResult((VmfMO)vrf, 555799289);
            }
        }
        catch (VMFException e) {
            VrfConflictCheckerInterface.setMOOperResult(operResult, e.getErrorCode(), ifName2vrf.values());
            this.logger.error("queryBindVrfSaps failed", (Throwable)e);
        }
        return operResult;
    }
}

