/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.service;

import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.IDBLinkageHandler;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.pwe3.model.ServiceInterface;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnSapTranslator;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class InterfaceDBLinkageHandler
implements IDBLinkageHandler {
    public void handler(NestingContext transaction) {
        if (!transaction.getFeatures().containsKey(FeatureName.L3VPN)) {
            return;
        }
        Context totalContext = transaction.getTotalContext();
        IMOChangeRecord interfaceChangeRcd = totalContext.getChangeRecord(Interface.class);
        if (interfaceChangeRcd == null || CollectionUtils.isEmpty((Collection)interfaceChangeRcd.getDeletes())) {
            return;
        }
        IMOChangeRecord svcInterfaceRcd = transaction.addChangeRecord(ServiceInterface.class);
        transaction.addFeatureMoType(FeatureName.L2VPN, ServiceInterface.class);
        for (Interface deletedIf : interfaceChangeRcd.getDeletes()) {
            ServiceInterface svcInterface = QAsnSapTranslator.getSvcInterface(deletedIf);
            svcInterfaceRcd.addDelete((Object)svcInterface);
        }
    }
}

