/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.notify;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnL3vpnAddRpt;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnL3vpnCfgChangeRpt;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnL3vpnCtpStatusRpt;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnL3vpnDeleteRpt;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnL3vpnVrfStatusRpt;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.dao.SQLHelper;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.notify.reportfm.DefaultRptAsn1constructor;
import com.huawei.vmf.adapter.framework.notify.reportfm.EventReportFrameOnMoChanged;
import com.huawei.vmf.adapter.framework.notify.reportfm.EventReportRegisterInfo;
import com.huawei.vmf.adapter.framework.notify.reportfm.MOFilter;
import com.huawei.vmf.adapter.framework.notify.reportfm.RptAsn1Constructor;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.OnlyEncodeAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.huawei.vmf.adapter.l3vpn.dao.L3vpnDao;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnL3vpnVrfStatusRptTranslator;
import com.huawei.vmf.adapter.l3vpn.translation.asn.QAsnRoutingInstanceTranslator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class L3vpnEventHandler
extends EventReportFrameOnMoChanged {
    private final IAsnTranslator<QAsnUniResID, L3vpnInstance> l3vpnDeleteTranslator = new OnlyEncodeAsnTranslator<QAsnUniResID, L3vpnInstance>(){

        public void encode(L3vpnInstance mo, QAsnUniResID asn, IAsnTranslationContext context) throws VMFException {
            L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
            QAsnUniResID temp = fdnParser.getUniResID((VmfMO)mo);
            asn.neID = temp.neID;
            asn.strFDN = temp.strFDN;
            asn.strMOC = temp.strMOC;
        }

        public Class<QAsnUniResID> getAsnClass() {
            return QAsnUniResID.class;
        }

        public Class<L3vpnInstance> getMoClass() {
            return L3vpnInstance.class;
        }
    };

    public L3vpnEventHandler() {
        this.registerEventHandler(L3vpnInstance.class, 10L, QAsnL3vpnVrfStatusRpt.class, (IAsnTranslator)new QAsnL3vpnVrfStatusRptTranslator.QAsnL3vpnVrfStatusRptVrfTranslator(), "l3vpnList", 65646, Arrays.asList("deployStatus"));
        this.registerEventHandler(VpnInstAF.class, 2L, QAsnL3vpnVrfStatusRpt.class, (IAsnTranslator)new QAsnL3vpnVrfStatusRptTranslator.QAsnL3vpnVrfStatusRptVrfAFTranslator(), "l3vpnList", 65646, Arrays.asList("vrfStatus"));
        EventReportRegisterInfo spaChangeListenerInfo = new EventReportRegisterInfo(){

            public IAsnTranslator getTranslator() {
                return new AbstractAsnTranslator<QAsnSAP, Interface>(){

                    public void decode(QAsnSAP asn, Interface mo, IAsnTranslationContext context) throws VMFException {
                        Utility.INSTANCE.getSapTranslator().decode((FStruct)asn, (Object)mo, context);
                    }

                    public void encode(Interface mo, QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
                        Utility.INSTANCE.getSapTranslator().encode((Object)mo, (FStruct)asn, context);
                        asn.poBindingRelationDeployStatus = 1;
                    }

                    public Class<QAsnSAP> getAsnClass() {
                        return QAsnSAP.class;
                    }

                    public Class<Interface> getMoClass() {
                        return Interface.class;
                    }
                };
            }
        };
        spaChangeListenerInfo.setEventId(69809);
        spaChangeListenerInfo.setFilter((MOFilter)new MOFilter<Interface>(){

            public Collection<Interface> filte(Collection<Interface> mos, IAsnTranslationContext asnTranslationContext) {
                try {
                    Collection<L3vpnIf> vrfIfs = L3vpnDao.newInstance().queryVrfSap(mos);
                    HashSet<String> flags = new HashSet<String>();
                    for (L3vpnIf vrfIf : vrfIfs) {
                        flags.add(this.getKey(vrfIf.getDevID(), vrfIf.getVrID(), vrfIf.getIfName()));
                    }
                    Iterator<Interface> it = mos.iterator();
                    while (it.hasNext()) {
                        Interface mo = it.next();
                        if (flags.contains(this.getKey(mo.getDevID(), mo.getVrID(), mo.getIfName()))) continue;
                        it.remove();
                    }
                    return mos;
                }
                catch (VMFException e) {
                    L3vpnEventHandler.this.getLogger().error("query vrfAF error", (Throwable)e);
                    return mos;
                }
            }

            private final String getKey(Integer devID, Integer vrID, String ifName) {
                return devID + File.separatorChar + vrID + File.separatorChar + ifName;
            }
        });
        spaChangeListenerInfo.setReportAsnClazz(QAsnL3vpnCtpStatusRpt.class);
        spaChangeListenerInfo.setFlag(10L);
        spaChangeListenerInfo.setOnChangedProperties(Arrays.asList("ifAdminStatus", "ifOperStatus"));
        spaChangeListenerInfo.setAsnConstructor((RptAsn1Constructor)new DefaultRptAsn1constructor("sapList"));
        this.registerEventHandler(Interface.class, spaChangeListenerInfo);
        EventReportRegisterInfo sapCfgChangeListenerInfo = new EventReportRegisterInfo(){

            public IAsnTranslator getTranslator() {
                return new AbstractAsnTranslator<QAsnRoutingInstance, Interface>(){

                    public void decode(QAsnRoutingInstance asn, Interface mo, IAsnTranslationContext context) throws VMFException {
                    }

                    public void encode(Interface mo, QAsnRoutingInstance asn, IAsnTranslationContext context) throws VMFException {
                        List insts = mo.getKeyRefMos(L3vpnInstance.class);
                        Iterator it = insts.iterator();
                        L3vpnInstance inst = (L3vpnInstance)it.next();
                        context.getTransactionContext().getChangeRecord(L3vpnInstance.class).addModify((Object)inst, new PropertyChangeItem(Interface.class.getName()));
                        QAsnRoutingInstanceTranslator trans = new QAsnRoutingInstanceTranslator();
                        trans.encode(inst, asn, context);
                    }

                    public Class<QAsnRoutingInstance> getAsnClass() {
                        return QAsnRoutingInstance.class;
                    }

                    public Class<Interface> getMoClass() {
                        return Interface.class;
                    }
                };
            }
        };
        sapCfgChangeListenerInfo.setEventId(65643);
        sapCfgChangeListenerInfo.setFilter((MOFilter)new VrfInstanceCfgChangeMOFilter(){

            @Override
            public Collection<Interface> filte(Collection<Interface> mos, IAsnTranslationContext asnTranslationContext) {
                IMOChangeRecord infChangeRecord = asnTranslationContext.getTransactionContext().getChangeRecord(Interface.class);
                for (Interface mo : mos) {
                    ArrayList changeItem = new ArrayList(infChangeRecord.getModifyPropertyItems((Object)mo));
                    if (!CollectionUtils.isEmpty(changeItem)) {
                        PropertyChangeItem operChange = new PropertyChangeItem("ifOperStatus");
                        changeItem.remove(operChange);
                    }
                    if (!CollectionUtils.isEmpty(changeItem)) continue;
                    mos.remove(mo);
                }
                Collection<Interface> mosFilte = super.filte(mos, asnTranslationContext);
                return mosFilte;
            }
        });
        sapCfgChangeListenerInfo.setReportAsnClazz(QAsnL3vpnCfgChangeRpt.class);
        sapCfgChangeListenerInfo.setFlag(10L);
        sapCfgChangeListenerInfo.setAsnConstructor((RptAsn1Constructor)new DefaultRptAsn1constructor("l3vpnList"));
        this.registerEventHandler(Interface.class, sapCfgChangeListenerInfo);
        this.registerEventHandler(L3vpnInstance.class, 9L, QAsnL3vpnAddRpt.class, (IAsnTranslator)new QAsnRoutingInstanceTranslator(), "l3vpnList", 65642, null);
        EventReportRegisterInfo vrfCfgChangeEventReport = new EventReportRegisterInfo();
        vrfCfgChangeEventReport.setFlag(10L);
        vrfCfgChangeEventReport.setReportAsnClazz(QAsnL3vpnCfgChangeRpt.class);
        vrfCfgChangeEventReport.setTranslator((IAsnTranslator)new QAsnRoutingInstanceTranslator());
        vrfCfgChangeEventReport.setEventId(65643);
        vrfCfgChangeEventReport.setAsnConstructor((RptAsn1Constructor)new DefaultRptAsn1constructor("/l3vpnList/"));
        vrfCfgChangeEventReport.setFilter((MOFilter)new MOFilter<L3vpnInstance>(){

            public Collection<L3vpnInstance> filte(Collection<L3vpnInstance> mos, IAsnTranslationContext asnTranslationContext) {
                for (L3vpnInstance mo : mos) {
                    ArrayList<Interface> infs = new ArrayList<Interface>();
                    if (CollectionUtils.isEmpty((Collection)mo.getL3vpnIfs())) continue;
                    for (L3vpnIf vrfIf : mo.getL3vpnIfs()) {
                        Interface inf = new Interface();
                        inf.setDevID(vrfIf.getDevID());
                        inf.setVrID(vrfIf.getVrID());
                        inf.setIfName(vrfIf.getIfName());
                        infs.add(inf);
                    }
                    String[] filterInf = new String[]{"devID", "vrID", "ifName"};
                    Object[][] values = SQLHelper.getPropertyValues(Interface.class, (String[])filterInf, infs);
                    try {
                        Collection infDB = L3vpnDao.newInstance().queryByKey(Interface.class, infs, true);
                        if (CollectionUtils.isEmpty((Collection)infDB)) continue;
                        for (Interface inf : infDB) {
                            mo.addKeyRefMo((VmfMO)inf);
                        }
                    }
                    catch (VMFException e) {
                        RunLogger.getLogger(this.getClass()).error("query queryByKey error", (Throwable)e);
                    }
                }
                return mos;
            }
        });
        this.registerEventHandler(L3vpnInstance.class, vrfCfgChangeEventReport);
        this.registerEventHandler(L3vpnInstance.class, 12L, QAsnL3vpnDeleteRpt.class, this.l3vpnDeleteTranslator, "l3vpnKeyList", 65644, null);
    }

    private static class VrfInstanceCfgChangeMOFilter
    implements MOFilter<Interface> {
        private VrfInstanceCfgChangeMOFilter() {
        }

        public Collection<Interface> filte(Collection<Interface> mos, IAsnTranslationContext asnTranslationContext) {
            ArrayList<Interface> ifs = new ArrayList<Interface>();
            try {
                Collection<L3vpnIf> vrfIfs = L3vpnDao.newInstance().queryVrfSap(mos);
                HashMap<String, L3vpnIf> flags = new HashMap<String, L3vpnIf>();
                for (L3vpnIf vrfIf : vrfIfs) {
                    flags.put(this.getKey(vrfIf.getDevID(), vrfIf.getVrID(), vrfIf.getIfName()), vrfIf);
                }
                HashMap<String, L3vpnInstance> instMap = new HashMap<String, L3vpnInstance>();
                Iterator<Interface> it = mos.iterator();
                while (it.hasNext()) {
                    Interface mo = it.next();
                    if (!flags.containsKey(this.getKey(mo.getDevID(), mo.getVrID(), mo.getIfName()))) {
                        it.remove();
                        continue;
                    }
                    L3vpnIf vrfIf = (L3vpnIf)flags.get(this.getKey(mo.getDevID(), mo.getVrID(), mo.getIfName()));
                    if (null == vrfIf) continue;
                    String instKey = this.getKey(vrfIf.getDevID(), vrfIf.getVrID(), vrfIf.getVrfName());
                    if (instMap.containsKey(instKey)) {
                        ((L3vpnInstance)instMap.get(instKey)).addL3vpnIfs(Arrays.asList(vrfIf));
                    } else {
                        L3vpnInstance inst = new L3vpnInstance();
                        inst.setDevID(vrfIf.getDevID());
                        inst.setVrID(vrfIf.getVrID());
                        inst.setVrfName(vrfIf.getVrfName());
                        inst.addL3vpnIfs(Arrays.asList(vrfIf));
                        instMap.put(instKey, inst);
                    }
                    ((L3vpnInstance)instMap.get(instKey)).addKeyRefMo((VmfMO)mo);
                }
                for (L3vpnInstance inst : instMap.values()) {
                    Interface inf = new Interface();
                    inf.setDevID(inst.getDevID());
                    inf.setVrID(inst.getVrID());
                    inf.setIfName(inst.getVrfName());
                    inf.addKeyRefMo((VmfMO)inst);
                    ifs.add(inf);
                }
                return ifs;
            }
            catch (VMFException e) {
                RunLogger.getLogger(this.getClass()).error("query vrfAF error", (Throwable)e);
                return ifs;
            }
        }

        private final String getKey(Integer devID, Integer vrID, String ifName) {
            return devID + File.separatorChar + vrID + File.separatorChar + ifName;
        }
    }
}

