/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.notify;

import com.huawei.vmf.adapter.framework.notify.IMOChangeNotifyPreHandler;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrf;
import com.huawei.vmf.adapter.fservice.route.model.IsSite;
import com.huawei.vmf.adapter.fservice.route.model.OspfSite;
import com.huawei.vmf.adapter.fservice.route.model.SrRoute;
import com.huawei.vmf.adapter.fservice.route.model.UniAf;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class AddVrfKeyRefPreHandler
implements IMOChangeNotifyPreHandler {
    static final Map<Class<? extends VmfMO>, String> moClass2VrfNameProperty = new HashMap<Class<? extends VmfMO>, String>();

    public void prepareChangeRecord(Context context) {
        for (Class<? extends VmfMO> kyeRefClass : moClass2VrfNameProperty.keySet()) {
            IMOChangeRecord changeRecord = context.getChangeRecord(kyeRefClass);
            if (changeRecord == null) continue;
            for (VmfMO keyRefMO : changeRecord.getAllChanges()) {
                this.addToVrfKeyRef(keyRefMO, context);
            }
        }
        this.addVrfModifyFlagByBindIf(context);
        this.preHandleVrfIfBind(context);
    }

    private void addIf2VrfKeyRef(L3vpnInstance vrf, Collection<Interface> vrfIfs) {
        for (Interface vrfIf : vrfIfs) {
            this.addIf2VrfKeyRef(vrf, vrfIf);
        }
    }

    private void addIf2VrfKeyRef(L3vpnInstance vrf, Interface vrfIf) {
        List keyRefs = vrf.getKeyRefMos(Interface.class);
        for (Interface keyRef : keyRefs) {
            if (!vrfIf.equals((Object)keyRef)) continue;
            return;
        }
        vrf.addKeyRefMo((VmfMO)vrfIf);
    }

    private void addToVrfKeyRef(VmfMO keyRefMO, Context context) {
        String vrfName = (String)ReflectHelper.getInstance().getPropertyValue((Object)keyRefMO, moClass2VrfNameProperty.get(keyRefMO.getClass()));
        IMOChangeRecord vrfChangeRecord = context.addChangeRecord(L3vpnInstance.class);
        L3vpnInstance vrf = new L3vpnInstance();
        vrf.setDevID(keyRefMO.getDevID());
        vrf.setVrID(keyRefMO.getVrID());
        vrf.setVrfName(vrfName);
        if (vrfChangeRecord.isDeleted((Object)vrf)) {
            return;
        }
        if (vrfChangeRecord.isCreated((Object)vrf)) {
            L3vpnInstance vpn = this.getVrfInContextByHashCode(vrf, vrfChangeRecord.getCreates());
            if (!vpn.getKeyRefMos(keyRefMO.getClass()).contains(keyRefMO)) {
                vpn.addKeyRefMo(keyRefMO);
            }
            return;
        }
        if (vrfChangeRecord.isModified((Object)vrf)) {
            L3vpnInstance vpn = this.getVrfInContextByHashCode(vrf, vrfChangeRecord.getModifies());
            if (!vpn.getKeyRefMos(keyRefMO.getClass()).contains(keyRefMO)) {
                vpn.addKeyRefMo(keyRefMO);
            }
            vrfChangeRecord.addModify((Object)vrf, Arrays.asList(keyRefMO.getClass().getName()));
            return;
        }
        vrf.addKeyRefMo(keyRefMO);
        vrfChangeRecord.addModify((Object)vrf, Arrays.asList(keyRefMO.getClass().getName()));
    }

    private void addVrfModifyFlagByBindIf(Context context) {
        IMOChangeRecord vrfIfChangeRecord = context.getChangeRecord(L3vpnIf.class);
        if (null == vrfIfChangeRecord) {
            return;
        }
        ArrayList changedVrfIfs = new ArrayList();
        changedVrfIfs.addAll(vrfIfChangeRecord.getCreates());
        changedVrfIfs.addAll(vrfIfChangeRecord.getDeletes());
        IMOChangeRecord vrfChangeRecord = context.getChangeRecord(L3vpnInstance.class);
        Set modifiedVrfs = vrfChangeRecord.getModifies();
        for (L3vpnIf vrfIf : changedVrfIfs) {
            L3vpnInstance vrf = new L3vpnInstance();
            vrf.setDevID(vrfIf.getDevID());
            vrf.setVrID(vrfIf.getVrID());
            vrf.setVrfName(vrfIf.getVrfName());
            L3vpnInstance vrfInContext = this.getVrfInContextByHashCode(vrf, modifiedVrfs);
            vrfChangeRecord.addModify((Object)vrfInContext, Arrays.asList("l3vpnIfs"));
            Collection tmp = vrfInContext.getL3vpnIfs();
            if (null != tmp && tmp.contains(vrfIf)) continue;
            vrfInContext.addL3vpnIfs(Arrays.asList(vrfIf));
        }
    }

    private Interface createIfMoByVrfIf(L3vpnIf vrfIf) {
        Interface ifMo = new Interface();
        ifMo.setDevID(vrfIf.getDevID());
        ifMo.setVrID(vrfIf.getVrID());
        ifMo.setIfName(vrfIf.getIfName());
        return ifMo;
    }

    private L3vpnInstance getVrfInContextByHashCode(L3vpnInstance vrf, Collection<L3vpnInstance> vrfs) {
        for (L3vpnInstance v : vrfs) {
            if (!vrf.equals((Object)v)) continue;
            return v;
        }
        return vrf;
    }

    private boolean isVrfIfInContext(Context context, Interface vrfIf) {
        IMOChangeRecord ifChangeRecord = context.getChangeRecord(Interface.class);
        return ifChangeRecord.getAllChanges().contains(vrfIf);
    }

    private void preHandleVrfIfBind(Context context) {
        IMOChangeRecord vrfChangeRecord = context.getChangeRecord(L3vpnInstance.class);
        if (vrfChangeRecord == null) {
            return;
        }
        for (L3vpnInstance vrf : vrfChangeRecord.getCreates()) {
            if ("_public_".equals(vrf.getVrfName()) || CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) continue;
            ArrayList<Interface> toQueryIfm = new ArrayList<Interface>();
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                Interface ifMo = this.createIfMoByVrfIf(vrfIf);
                if (this.isVrfIfInContext(context, ifMo)) {
                    this.addIf2VrfKeyRef(vrf, ifMo);
                    continue;
                }
                toQueryIfm.add(ifMo);
            }
            this.addIf2VrfKeyRef(vrf, Utility.INSTANCE.queryBindSap(toQueryIfm));
        }
        IMOChangeRecord vrfIfChangeRecord = context.getChangeRecord(L3vpnIf.class);
        if (null == vrfIfChangeRecord) {
            return;
        }
        for (L3vpnInstance vrf : vrfChangeRecord.getModifies()) {
            if ("_public_".equals(vrf.getVrfName()) || CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs()) || !vrfChangeRecord.isModified((Object)vrf, "l3vpnIfs")) continue;
            ArrayList<Interface> toQueryIfm = new ArrayList<Interface>();
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                if (!vrfIfChangeRecord.isCreated((Object)vrfIf) && !vrfIfChangeRecord.isDeleted((Object)vrfIf)) continue;
                Interface ifMo = this.createIfMoByVrfIf(vrfIf);
                if (this.isVrfIfInContext(context, ifMo)) {
                    this.addIf2VrfKeyRef(vrf, ifMo);
                    continue;
                }
                if (vrfIfChangeRecord.isDeleted((Object)vrfIf)) {
                    this.addIf2VrfKeyRef(vrf, ifMo);
                    continue;
                }
                toQueryIfm.add(ifMo);
            }
            this.addIf2VrfKeyRef(vrf, Utility.INSTANCE.queryBindSap(toQueryIfm));
        }
    }

    static {
        moClass2VrfNameProperty.put(BgpVrf.class, "vrfName");
        moClass2VrfNameProperty.put(OspfSite.class, "vrfName");
        moClass2VrfNameProperty.put(SrRoute.class, "vrfName");
        moClass2VrfNameProperty.put(IsSite.class, "vpnName");
        moClass2VrfNameProperty.put(UniAf.class, "vrfName");
    }
}

