/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.fault;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.trapadmin.FaultUtil;
import com.huawei.vmf.adapter.framework.trapadmin.IFaultListener;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.VpnInstAF;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.common.Utility;
import com.swimap.imap.common.asn1.common.AsnForwardFaultRptStrc;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VrfFaultListener
implements IFaultListener {
    public static final String FAULT_GROUP = "com.huawei.vmf.adapter.l3vpn.vrf";
    private static final int ROUTETHRESHOLD_EXCEED_FLAUTID = 1101052;
    private static final int ROUTETHRESHOLD_RUSUME_FLAUTID = 1101053;
    private static final int VRF_DOWN_FLAUTID = 1101051;
    private static final int VRF_UP_FLAUTID = 1101050;
    private final Logger logger = LoggerFactory.getLogger(VrfFaultListener.class);

    public void handle(List<AsnForwardFaultRptStrc> alarm) {
        LinkedList<VpnInstAF> vrfAFs = new LinkedList<VpnInstAF>();
        L3vpnInstanceFdnParser parser = new L3vpnInstanceFdnParser();
        for (AsnForwardFaultRptStrc al : alarm) {
            int alarmID = al.sFaultID.intValue();
            if (alarmID == 1101051 || alarmID == 1101050) {
                L3vpnInstance vrf = parser.getIndexMo(StringUtil.globalString((byte[])al.strFdn));
                VpnInstAF vrfAF = new VpnInstAF();
                Utility.INSTANCE.setChildMoKeyByParentMo((VmfMO)vrfAF, (VmfMO)vrf);
                vrfAF.setAfType(VpnInstAF.AF_TYPE_ENUM.IPV4UNI);
                vrf.addVpnInstAFs(Arrays.asList(vrfAF));
                vrfAF.setVrfStatus(alarmID == 1101051 ? VpnInstAF.VRF_STATUS_ENUM.DOWN : VpnInstAF.VRF_STATUS_ENUM.UP);
                if (alarmID == 1101051 && FaultUtil.isRecoverFault((AsnForwardFaultRptStrc)al)) {
                    vrfAF.setVrfStatus(VpnInstAF.VRF_STATUS_ENUM.UP);
                }
                vrfAFs.add(vrfAF);
                continue;
            }
            if (alarmID == 1101052 || alarmID == 1101053) {
                this.logger.info(String.format("ignore alarm-id %d", alarmID));
                continue;
            }
            this.logger.error(String.format("unknown alarm-id %d", alarmID));
        }
        if (vrfAFs.isEmpty()) {
            return;
        }
        Context context = new Context();
        IMOChangeRecord record = context.addChangeRecord(VpnInstAF.class);
        for (VpnInstAF vrfAF : vrfAFs) {
            record.addModify((Object)vrfAF, Arrays.asList("vrfStatus"));
        }
        this.updateVrfStatus(context);
        MOChangePublisher.getInstance().notifyAlarmChanges(context);
    }

    private void updateVrfStatus(Context context) {
        try {
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
            dao.merge(VpnInstAF.class, false);
        }
        catch (VMFException ex) {
            this.logger.error("updateVrfStatus faild", (Throwable)ex);
        }
    }
}

