/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.dao;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.CompareOperator;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.RelationMetaMgr;
import com.huawei.vmf.adapter.framework.dao.SQLHelper;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.route.model.BgpPeer;
import com.huawei.vmf.adapter.fservice.route.model.BgpPeerGroup;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrfAF;
import com.huawei.vmf.adapter.fservice.route.model.PeerAF;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.util.CollectionUtils;

public class L3vpnDao
extends DefaultDao {
    public L3vpnDao(SessionFactory sf, RelationMetaMgr relationMgr) {
        super(sf, relationMgr);
    }

    public static L3vpnDao newInstance() {
        return (L3vpnDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, L3vpnDao.class);
    }

    public Collection<BgpPeer> queryBgpPeerByGroupName(BgpPeerGroup peerGroup) throws VMFException {
        String[] filterNames = new String[]{"devID", "vrID", "vrfName", "groupName"};
        Object[][] values = SQLHelper.getPropertyValues(BgpPeerGroup.class, (String[])filterNames, Arrays.asList(peerGroup));
        SQLHelper sql = SQLHelper.query(BgpPeer.class, (SessionFactory)this.getSf());
        sql.initQueryByField(BgpPeer.class, filterNames, values);
        sql.selectAll(BgpPeer.class);
        return this.executeQuery(BgpPeer.class, sql, true, false);
    }

    public Collection<L3vpnIf> queryBindVrfIf(Collection<L3vpnIf> ifNames) throws VMFException {
        String[] filterNames = new String[]{"devID", "vrID", "ifName"};
        Object[][] values = SQLHelper.getPropertyValues(L3vpnIf.class, (String[])filterNames, ifNames);
        SQLHelper sql = SQLHelper.query(L3vpnIf.class, (SessionFactory)this.getSf());
        sql.initQueryByField(L3vpnIf.class, filterNames, values);
        sql.selectAll(L3vpnIf.class);
        return this.executeQuery(L3vpnIf.class, sql, false, false);
    }

    public List<L3vpnInstance> queryL3vpnInstanceByFdns(List<String> fdns) throws VMFException {
        if (CollectionUtils.isEmpty(fdns)) {
            return Collections.EMPTY_LIST;
        }
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        ArrayList<L3vpnInstance> l3vpnInstanceList = new ArrayList<L3vpnInstance>(fdns.size());
        for (String fdn : fdns) {
            L3vpnInstance mo = (L3vpnInstance)fdnParser.getIndexMo(fdn);
            l3vpnInstanceList.add(mo);
        }
        ArrayList<L3vpnInstance> resultList = new ArrayList<L3vpnInstance>();
        resultList.addAll(this.queryByKey(L3vpnInstance.class, l3vpnInstanceList, true));
        return resultList;
    }

    public Collection<PeerAF> queryPeerAFByPeer(BgpPeer peer) throws VMFException {
        LinkedList<PeerAF> key = new LinkedList<PeerAF>();
        for (Field f : BgpVrfAF.AF_TYPE_ENUM.class.getFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getType().equals(Integer.class)) continue;
            try {
                Integer afType = (Integer)f.get(null);
                if (afType == null) continue;
                PeerAF peerAF = new PeerAF();
                peerAF.setDevID(peer.getDevID());
                peerAF.setVrID(peer.getVrID());
                peerAF.setVrfName(peer.getVrfName());
                peerAF.setAfType(afType);
                peerAF.setRemoteAddress(peer.getPeerAddr());
                key.add(peerAF);
            }
            catch (IllegalArgumentException e) {
                throw new VMFException(1107498880, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new VMFException(1107498880, (Throwable)e);
            }
        }
        return this.queryByKey(PeerAF.class, key, true);
    }

    public Collection<L3vpnIf> queryVrfSap(Collection<Interface> ifMos) throws VMFException {
        if (CollectionUtils.isEmpty(ifMos)) {
            return Collections.emptyList();
        }
        String[] filterNames = new String[]{"devID", "vrID", "ifName"};
        Object[][] values = SQLHelper.getPropertyValues(Interface.class, (String[])filterNames, ifMos);
        SQLHelper sql = SQLHelper.query(L3vpnIf.class, (SessionFactory)this.getSf());
        sql.initQueryByField(L3vpnIf.class, filterNames, values);
        sql.selectAll(L3vpnIf.class);
        sql.where(L3vpnIf.class, "vrfName", CompareOperator.NQ, (Object)"_public_");
        return this.executeQuery(L3vpnIf.class, sql, false, false);
    }

    public Collection<L3vpnIf> queryVrfSapByVRFName(L3vpnInstance vrf) throws VMFException {
        ArrayList<L3vpnIf> l3vpnIfs = new ArrayList<L3vpnIf>();
        L3vpnIf l3vpnIf = new L3vpnIf();
        l3vpnIf.setDevID(vrf.getDevID());
        l3vpnIf.setVrID(vrf.getVrID());
        l3vpnIf.setVrfName(vrf.getVrfName());
        l3vpnIfs.add(l3vpnIf);
        return this.queryByKey(L3vpnIf.class, l3vpnIfs, true);
    }
}

