/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.common;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnDhcpRelay;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnTunnelSelection;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItemList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnRoutingInstance;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.CommonUtil;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.qos.service.IQosService;
import com.huawei.vmf.adapter.framework.capability.CapabilityInfo;
import com.huawei.vmf.adapter.framework.capability.ICapabilityInfoMgr;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.dao.IRelationMeta;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.mediation.FeatureAdapterInfo;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.QueryResult;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.framework.util.ReflectHelper;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.arp.service.IArpService;
import com.huawei.vmf.adapter.fservice.dhcp.model.DhcpRelayVpnCfg;
import com.huawei.vmf.adapter.fservice.dhcp.service.IDhcpService;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.Ipv4Address;
import com.huawei.vmf.adapter.fservice.ifm.service.IInterfaceService;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.l3vpn.model.MvpnFeature;
import com.huawei.vmf.adapter.fservice.mcast.model.BsrAfsSiteCfg;
import com.huawei.vmf.adapter.fservice.mcast.model.PimAfsSiteCfg;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TunnelPolicy;
import com.huawei.vmf.adapter.fservice.mpls.service.IMplsService;
import com.huawei.vmf.adapter.fservice.pwe3.model.ServiceInterface;
import com.huawei.vmf.adapter.fservice.route.model.BgpVrf;
import com.huawei.vmf.adapter.fservice.route.model.IsSite;
import com.huawei.vmf.adapter.fservice.route.model.OspfSite;
import com.huawei.vmf.adapter.fservice.route.model.SrRoute;
import com.huawei.vmf.adapter.fservice.route.model.UniAf;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.adapter.l3vpn.Activator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import com.huawei.vmf.common.mediation.AdapterInfo;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class Utility {
    public static final Utility INSTANCE = new Utility();
    private final Logger logger = RunLogger.getLogger(this.getClass());

    private Utility() {
    }

    public static Interface cloneInterfaceKeysAndIP(Interface ifMo) {
        Interface ret = new Interface();
        ret.setDevID(ifMo.getDevID());
        ret.setVrID(ifMo.getVrID());
        ret.setIfName(ifMo.getIfName());
        ret.setDeployStatus(ifMo.getDeployStatus());
        ret.setIpv4Addresss(new ArrayList());
        ret.addIpv4Addresss(ifMo.getIpv4Addresss());
        return ret;
    }

    public static CapabilityInfo getCapabilityInfo(VmfMO mo) throws VMFException {
        ICapabilityInfoMgr capabilityInfoMgr = Utility.getCapabilityInfoMgr();
        if (capabilityInfoMgr == null) {
            throw new VMFException(1107498880, "getCapabilityInfoMgr() == null");
        }
        FeatureAdapterInfo featureAdapterInfo = new FeatureAdapterInfo(mo.getDevID().intValue(), mo.getFeatureName());
        try {
            CapabilityInfo capabilityInfo = (CapabilityInfo)capabilityInfoMgr.getAdapterService((AdapterInfo)featureAdapterInfo);
            if (capabilityInfo == null) {
                throw new VMFException(1107498880, "getCapabilityInfo failed " + mo.getFeatureName() + " deviceId" + mo.getDevID());
            }
            return capabilityInfo;
        }
        catch (com.huawei.vmf.common.exception.VMFException e) {
            throw new VMFException(e);
        }
    }

    public static ICapabilityInfoMgr getCapabilityInfoMgr() {
        return Activator.getService(ICapabilityInfoMgr.class);
    }

    public static void reviseDeployStatus(IAsnTranslationContext asnTranslationContext, Class<? extends VmfMO> mainMOType) {
        DeployStatusRevisor revisor = new DeployStatusRevisor(asnTranslationContext, mainMOType, null);
        revisor.revise();
    }

    public static void reviseDeployStatus(IAsnTranslationContext asnTranslationContext, Class<? extends VmfMO> mainMOType, Map<Class<? extends VmfMO>, Collection<VmfMO>> canceldDeleteMos) {
        DeployStatusRevisor revisor = new DeployStatusRevisor(asnTranslationContext, mainMOType, canceldDeleteMos);
        revisor.revise();
    }

    private static String getIfKeys(DhcpRelayVpnCfg mo) {
        return mo.getDevID() + File.separatorChar + mo.getVrID() + File.separatorChar + mo.getVrfName();
    }

    private static String getIfKeys(Interface mo) {
        return mo.getDevID() + File.separatorChar + mo.getVrID() + File.separatorChar + mo.getIfName();
    }

    private static String getIfKeys(L3vpnIf mo) {
        return mo.getDevID() + File.separatorChar + mo.getVrID() + File.separatorChar + mo.getIfName();
    }

    private static String getIfKeys(VmfMO otherMo, String ifName) {
        return otherMo.getDevID() + File.separatorChar + otherMo.getVrID() + File.separatorChar + ifName;
    }

    public void addInterfaceToTempContext4Modify(Context context, Interface ifMo) {
        Collection tempIfMos;
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
        try {
            tempIfMos = dao.queryByKey(Interface.class, Arrays.asList(ifMo), true);
        }
        catch (VMFException e) {
            this.logger.error("queryByKey failed", (Throwable)e);
            return;
        }
        if (CollectionUtils.isEmpty((Collection)tempIfMos)) {
            return;
        }
        Interface target = (Interface)tempIfMos.iterator().next();
        if (CollectionUtils.isEmpty((Collection)target.getIpv4Addresss()) && StringUtil.isEmpty((String)target.getUnNumIfName())) {
            return;
        }
        target.setDeployStatus(Integer.valueOf(1));
        IMOChangeRecord ifChangeRecord = context.getChangeRecord(Interface.class);
        if (ifChangeRecord != null && ifChangeRecord.isChanged((Object)ifMo)) {
            if (ifChangeRecord.isModified((Object)ifMo)) {
                this.logger.error("interface {} is modified when bound to vrf", (Object)target);
            }
            return;
        }
        Context targetContext = this.getIfBandToVrfContext(context);
        if (!CollectionUtils.isEmpty((Collection)target.getIpv4Addresss())) {
            this.sortIPV4Address(target.getIpv4Addresss());
            targetContext.addChangeRecord(Interface.class).addModify((Object)target, Arrays.asList("ipv4Addresss"));
            targetContext.addChangeRecord(Ipv4Address.class).addCreate(target.getIpv4Addresss());
        }
    }

    public void addInterfaceToTempContext4Modify(Context context, Interface ifMo, Collection<L3vpnIf> toCreateVrfIfs) {
        for (L3vpnIf vrfIf : toCreateVrfIfs) {
            Interface tempIfMo = new Interface();
            tempIfMo.setDevID(vrfIf.getDevID());
            tempIfMo.setVrID(vrfIf.getVrID());
            tempIfMo.setIfName(vrfIf.getIfName());
            if (!tempIfMo.equals((Object)ifMo)) continue;
            Interface target = Utility.cloneInterfaceKeysAndIP(ifMo);
            Collection ips = target.getIpv4Addresss();
            target.setIpv4Addresss(new ArrayList());
            target.setDeployStatus(Integer.valueOf(1));
            Context targetContext = this.getIfBandToVrfContext(context);
            targetContext.addChangeRecord(Interface.class).addModify((Object)target, Arrays.asList("ipv4Addresss"));
            for (Ipv4Address ip : ips) {
                if (!context.getChangeRecord(Ipv4Address.class).isCreated((Object)ip)) continue;
                targetContext.addChangeRecord(Ipv4Address.class).addCreate((Object)ip);
                target.getIpv4Addresss().add(ip);
            }
        }
    }

    public <T extends VmfMO> void addMo2Context(IAsnTranslationContext context, Class<T> clazz, T mo, VmfMO mainMo, EOperationType moOperType) {
        IMOChangeRecord changeRcd = context.getTransactionContext().addChangeRecord(clazz);
        switch (moOperType) {
            case CREATE: {
                changeRcd.addCreate(mo);
                break;
            }
            case DELETE: {
                changeRcd.addDelete(mo);
                break;
            }
            default: {
                return;
            }
        }
        if (mainMo != null) {
            mainMo.addKeyRefMo(mo);
        }
    }

    public void addStaticArpToTempContext4Modify(Context context) {
        IMOChangeRecord arpStatic = context.addChangeRecord(ArpStaticTable.class);
        IMOChangeRecord arpStaticDb = context.addDBChangeRecord(ArpStaticTable.class);
        Context targetContext = this.getStaticArpToVrfContext(context);
        IMOChangeRecord changeRecordContext = targetContext.addChangeRecord(ArpStaticTable.class);
        for (ArpStaticTable createMo : arpStatic.getCreates()) {
            changeRecordContext.addCreate((Object)createMo);
            arpStaticDb.addCreate((Object)createMo);
        }
        for (ArpStaticTable deleteMo : arpStatic.getDeletes()) {
            changeRecordContext.addDelete((Object)deleteMo);
            arpStaticDb.addDelete((Object)deleteMo);
        }
        arpStatic.getCreates().clear();
        arpStatic.getDeletes().clear();
        if (arpStatic.hasModify()) {
            Set modifyMos = arpStatic.getModifies();
            for (ArpStaticTable modifyMo : modifyMos) {
                changeRecordContext.addModify((Object)modifyMo, new PropertyChangeItem("ifName", (Object)modifyMo.getIfName(), (Object)modifyMo.getIfName()));
                changeRecordContext.addModify((Object)modifyMo, new PropertyChangeItem("peVid", (Object)modifyMo.getPeVid(), (Object)modifyMo.getPeVid()));
                arpStaticDb.addModify((Object)modifyMo, new PropertyChangeItem("ifName", (Object)modifyMo.getIfName(), (Object)modifyMo.getIfName()));
                arpStaticDb.addModify((Object)modifyMo, new PropertyChangeItem("peVid", (Object)modifyMo.getPeVid(), (Object)modifyMo.getPeVid()));
            }
        }
        arpStatic.getModifies().clear();
    }

    public Interface decodeSap(QAsnSAP asn, IAsnTranslationContext context) throws VMFException {
        Interface mo = (Interface)this.getSapTranslator().decode((FStruct)asn, context);
        mo.setSerialNum(StringUtil.globalString((byte[])asn.ctpKey.poSerialNum));
        return mo;
    }

    public <T extends VmfMO> void deployMo(T mo, Class<T> clazz) throws VMFException {
        Context cxt = new Context(false);
        IMOChangeRecord rcd = cxt.addChangeRecord(clazz);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(cxt);
        if (!dao.exists(clazz, Arrays.asList(mo)).isEmpty()) {
            return;
        }
        rcd.addCreate(mo);
        HashMap<FeatureName, List<Class>> features = new HashMap<FeatureName, List<Class>>();
        features.put(mo.getFeatureName(), Arrays.asList(clazz));
        DeviceAccessorFactory.getDefaultNetconfDeployer((int)mo.getDevID(), (Context)cxt).merge(features);
        dao.merge(clazz, true);
    }

    public QAsnDhcpRelay encodeDhcpRelayVpn(DhcpRelayVpnCfg mo, IAsnTranslationContext context) throws VMFException {
        return this.getDhcpService().encodeDhcpRelayVpn(mo, (Object)context);
    }

    public QAsnSAP encodeSap(Interface mo, IAsnTranslationContext context) throws VMFException {
        QAsnSAP asn = (QAsnSAP)this.getSapTranslator().encode((Object)mo, context);
        if (!StringUtil.isEmpty((String)mo.getSerialNum())) {
            asn.ctpKey.poSerialNum = StringUtil.globalByte((String)mo.getSerialNum());
        }
        return asn;
    }

    public QAsnArpItemList encodeStaticArp(Collection<ArpStaticTable> arpStaticTables, IAsnTranslationContext context) throws VMFException {
        return this.getArpService().encodeStaticArp(arpStaticTables, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<L3vpnInstance> getAllMosByVpnKeys(Collection<QAsnUniResID> l3vpnKeyList, IAsnTranslationContext asnTranslatorContext, EOperationType operType) {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Collection<L3vpnInstance> collection = this.getAllMosByVpnKeys(l3vpnKeyList, asnTranslatorContext, operType, dao);
            return collection;
        }
        catch (VMFException e) {
            this.getLogger().error("getAllMosByVpnKeys exception", (Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            dao.rollback();
        }
    }

    public IArpService getArpService() {
        return Activator.getService(IArpService.class);
    }

    public <T extends IAsnTranslator<QAsnDhcpRelay, DhcpRelayVpnCfg>> T getDhcpRelayVpnTranslator() {
        return (T)Activator.getAsnTranslator(QAsnDhcpRelay.class, DhcpRelayVpnCfg.class);
    }

    public IDhcpService getDhcpService() {
        return Activator.getService(IDhcpService.class);
    }

    public Context getIfBandToVrfContext(Context totalContext) {
        Context ret;
        Object tmp = totalContext.getProperty("__IfBandToVrfContext__");
        if (null == tmp) {
            ret = new Context();
            totalContext.addProperty("__IfBandToVrfContext__", (Object)ret);
        } else {
            ret = (Context)tmp;
        }
        return ret;
    }

    public IInterfaceService getIfService() {
        return Activator.getService(IInterfaceService.class);
    }

    public IRelationMeta getIRelationMeta(Class<? extends VmfMO> type) {
        DefaultDao dao = (DefaultDao)DaoFactory.getInstance().getDefaultVmfDao(null);
        return dao.getRelationMeta(type);
    }

    public <T extends IAsnTranslator<QAsnSAP, Interface>> T getSapTranslator() {
        return (T)Activator.getAsnTranslator(QAsnSAP.class, Interface.class);
    }

    public Context getStaticArpToVrfContext(Context totalContext) {
        Context ret;
        Object tmp = totalContext.getProperty("__StaticArpToVrfContext__");
        if (null == tmp) {
            ret = new Context();
            totalContext.addProperty("__StaticArpToVrfContext__", (Object)ret);
        } else {
            ret = (Context)tmp;
        }
        return ret;
    }

    public <T extends IAsnTranslator<QAsnTunnelSelection, TunnelPolicy>> T getTunnelPolicyTranslator() {
        return (T)Activator.getAsnTranslator(QAsnTunnelSelection.class, TunnelPolicy.class);
    }

    public <T extends VmfMO> T instanceMo(Class<T> clazz, VmfMO parentMo) throws VMFException {
        try {
            VmfMO ret = (VmfMO)clazz.newInstance();
            if (parentMo != null) {
                this.setMoDevID(parentMo, ret);
            }
            return (T)ret;
        }
        catch (Exception e) {
            throw new VMFException(1107498880, (Throwable)e);
        }
    }

    public void processDhcpRelayVpn(QAsnDhcpRelay asn, L3vpnInstance vpn, IAsnTranslationContext context) throws VMFException {
        this.getDhcpService().decodeDhcpRealyVpn(asn, vpn, (Object)context);
    }

    public void processStaticArp(QAsnArpItemList asnList, L3vpnInstance vpn, IAsnTranslationContext context) throws VMFException {
        this.getArpService().decodeStaticArp(asnList, vpn, (Object)context);
    }

    public Map<L3vpnInstance, Collection<BgpVrf>> queryBgpRouteByVPN(Collection<L3vpnInstance> vpns, IDao dao) throws VMFException {
        return this.queryRefMobyVPN(vpns, dao, BgpVrf.class, "vrfName");
    }

    public Collection<Interface> queryBindSap(Collection<Interface> conditions) {
        if (CollectionUtils.isEmpty(conditions)) {
            return conditions;
        }
        AsnTranslationContext context = new AsnTranslationContext();
        context.setOperType(EOperationType.GET);
        try {
            return INSTANCE.getIfService().processSAP(conditions, (Object)context);
        }
        catch (VMFException e) {
            this.logger.error("Utility.INSTANCE.getIfService().processSAP exception", (Throwable)e);
            return conditions;
        }
    }

    public Map<L3vpnInstance, Collection<IsSite>> queryIsisRouteByVPN(Collection<L3vpnInstance> vpns, IDao dao) throws VMFException {
        return this.queryRefMobyVPN(vpns, dao, IsSite.class, "vpnName");
    }

    public Map<L3vpnInstance, Collection<OspfSite>> queryOspfRouteByVPN(Collection<L3vpnInstance> vpns, IDao dao) throws VMFException {
        return this.queryRefMobyVPN(vpns, dao, OspfSite.class, "vrfName");
    }

    public <T extends VmfMO> Map<L3vpnInstance, Collection<T>> queryRefMobyVPN(Collection<L3vpnInstance> vpns, IDao dao, Class<T> clazz, String fieldNameRefVefName) throws VMFException {
        HashMap<L3vpnInstance, Collection<T>> ret = new HashMap<L3vpnInstance, Collection<T>>();
        ArrayList<VmfMO> conditions = new ArrayList<VmfMO>(vpns.size());
        for (L3vpnInstance vpn : vpns) {
            ret.put(vpn, new LinkedList());
            try {
                VmfMO mo = (VmfMO)clazz.newInstance();
                mo.setDevID(vpn.getDevID());
                mo.setVrID(vpn.getVrID());
                this.setField(mo, fieldNameRefVefName, vpn.getVrfName());
                conditions.add(mo);
            }
            catch (Exception e) {
                this.logger.error("queryRefMobyVPN", (Throwable)e);
                throw new VMFException(1107498880, (Throwable)e);
            }
        }
        Collection mos = dao.queryByFields(clazz, new String[]{"devID", "vrID", fieldNameRefVefName}, conditions, true);
        for (VmfMO mo : mos) {
            L3vpnInstance temp = new L3vpnInstance();
            temp.setDevID(mo.getDevID());
            temp.setVrID(mo.getVrID());
            try {
                temp.setVrfName(this.getField(mo, fieldNameRefVefName).toString());
                ((Collection)ret.get(temp)).add(mo);
            }
            catch (Exception e) {
                this.logger.error("queryRefMobyVPN", (Throwable)e);
                throw new VMFException(1107498880, (Throwable)e);
            }
        }
        return ret;
    }

    public Map<L3vpnInstance, Collection<MvpnFeature>> queryRefMVPNbyVPN(Collection<L3vpnInstance> vpns, IDao dao) throws VMFException {
        return this.queryRefMobyVPN(vpns, dao, MvpnFeature.class, "vrfName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<L3vpnInstance, Collection<Interface>> querySapByL3vpn(Collection<L3vpnInstance> l3vpns) throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Map<L3vpnInstance, Collection<Interface>> map = this.querySapByL3vpn(l3vpns, dao);
            return map;
        }
        finally {
            dao.rollback();
        }
    }

    public Map<L3vpnInstance, Collection<Interface>> querySapByL3vpn(Collection<L3vpnInstance> l3vpns, IDao dao) throws VMFException {
        return this.querySapByL3vpn(l3vpns, dao, null);
    }

    public Map<L3vpnInstance, Collection<Interface>> querySapByL3vpn(Collection<L3vpnInstance> l3vpns, IDao dao, IAsnTranslationContext context) throws VMFException {
        HashMap<L3vpnInstance, Collection<Interface>> ret = new HashMap<L3vpnInstance, Collection<Interface>>();
        HashMap<String, L3vpnInstance> ifKey2Vrf = new HashMap<String, L3vpnInstance>();
        LinkedList<Interface> ifConditions = new LinkedList<Interface>();
        LinkedList<ServiceInterface> serviceIfConditions = new LinkedList<ServiceInterface>();
        for (L3vpnInstance l3vpn : l3vpns) {
            if (l3vpn.getL3vpnIfs() == null) continue;
            for (L3vpnIf ifMo : l3vpn.getL3vpnIfs()) {
                Interface mo = new Interface();
                mo.setDevID(ifMo.getDevID());
                mo.setVrID(ifMo.getVrID());
                mo.setIfName(ifMo.getIfName());
                ifConditions.add(mo);
                ifKey2Vrf.put(Utility.getIfKeys(mo), l3vpn);
                ServiceInterface svcIf = new ServiceInterface();
                svcIf.setDevID(ifMo.getDevID());
                svcIf.setVrID(ifMo.getVrID());
                svcIf.setInterfaceName(ifMo.getIfName());
                serviceIfConditions.add(svcIf);
            }
        }
        Collection sapFromDB = this.getIfService().processSAP(ifConditions, (Object)context);
        Collection svcIfs = dao.queryByKey(ServiceInterface.class, serviceIfConditions, false);
        HashMap<String, Interface> ifKey2IfMO = new HashMap<String, Interface>();
        for (Interface ifMo : sapFromDB) {
            L3vpnInstance vrf = (L3vpnInstance)ifKey2Vrf.get(Utility.getIfKeys(ifMo));
            LinkedList<Interface> vrfSap = (LinkedList<Interface>)ret.get(vrf);
            if (vrfSap == null) {
                vrfSap = new LinkedList<Interface>();
                ret.put(vrf, vrfSap);
            }
            vrfSap.add(ifMo);
            ifKey2IfMO.put(Utility.getIfKeys(ifMo), ifMo);
        }
        for (ServiceInterface svfIf : svcIfs) {
            Interface ifMo = (Interface)ifKey2IfMO.get(Utility.getIfKeys((VmfMO)svfIf, svfIf.getInterfaceName()));
            if (ifMo != null) {
                ifMo.addKeyRefMo((VmfMO)svfIf);
                continue;
            }
            this.logger.error(String.format("interface %s not exist, but ServiceInterface exist", Utility.getIfKeys((VmfMO)svfIf, svfIf.getInterfaceName())));
        }
        this.removeVrfIfOnInterfaceNotExist(l3vpns, ifKey2IfMO.keySet());
        return ret;
    }

    public Map<L3vpnInstance, Collection<SrRoute>> queryStaticRouteByVPN(Collection<L3vpnInstance> vpns, IDao dao) throws VMFException {
        return this.queryRefMobyVPN(vpns, dao, SrRoute.class, "vrfName");
    }

    public void reviseSrRouteDestVrf(L3vpnInstance vrf, IAsnTranslationContext asnTranslationContext) {
        IMOChangeRecord srChangeRecord = asnTranslationContext.getTransactionContext().getChangeRecord(SrRoute.class);
        Iterator keyRefSrRouteIt = vrf.getKeyRefMos(SrRoute.class).iterator();
        ArrayList<SrRoute> revisedSrRoutes = new ArrayList<SrRoute>();
        while (keyRefSrRouteIt.hasNext()) {
            SrRoute srRoute = (SrRoute)keyRefSrRouteIt.next();
            if (!srChangeRecord.isCreated((Object)srRoute) || !this.l3vpnIfIsCreated(vrf, asnTranslationContext.getTransactionContext(), srRoute.getIfName()) || !srRoute.getDestVrfName().equals("_public_")) continue;
            srChangeRecord.cancelCreate((Object)srRoute);
            keyRefSrRouteIt.remove();
            srRoute.setDestVrfName(vrf.getVrfName());
            revisedSrRoutes.add(srRoute);
        }
        srChangeRecord.addCreate(revisedSrRoutes);
        vrf.addKeyRefMos(revisedSrRoutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildMoKeyByParentMo(VmfMO child, VmfMO parent) {
        DefaultDao dao = (DefaultDao)DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            dao.getRelationMeta(parent.getClass()).setChildKeyByParentKey((Object)parent, (Object)child);
        }
        finally {
            dao.rollback();
        }
    }

    public void setL3vpnInstanceKeyRefMo(QueryResult result, IDao dao) throws VMFException {
        Collection vpns = result.getQueryResult(L3vpnInstance.class);
        if (CollectionUtils.isEmpty((Collection)vpns)) {
            return;
        }
        Map<L3vpnInstance, Collection<Interface>> vrf2Sap = this.querySapByL3vpn(vpns, dao);
        for (Map.Entry<L3vpnInstance, Collection<Interface>> entey : vrf2Sap.entrySet()) {
            entey.getKey().addKeyRefMos(entey.getValue());
        }
        Map vrfRelayVpns = this.getDhcpService().processDhcpRelayVpnFromDb(vpns);
        for (Map.Entry entey : vrfRelayVpns.entrySet()) {
            ((L3vpnInstance)entey.getKey()).addKeyRefMo((VmfMO)entey.getValue());
        }
        Collection staticTables = this.getArpService().processStaticArpFromDb(vpns);
        if (!CollectionUtils.isEmpty((Collection)staticTables)) {
            for (L3vpnInstance l3vpn : vpns) {
                for (ArpStaticTable staticTable : staticTables) {
                    if (l3vpn.getDevID().intValue() != staticTable.getDevID().intValue() || !l3vpn.getVrfName().equals(staticTable.getVrfName())) continue;
                    l3vpn.addKeyRefMo((VmfMO)staticTable);
                }
            }
        }
        this.getAllMosByVpnKeys(vpns, dao);
    }

    public void setMoDevID(VmfMO from, VmfMO to) {
        to.setDevID(from.getDevID());
        to.setVrID(from.getVrID());
    }

    public Collection<QAsnSAP> translateInterfaces(Collection<Interface> ifmList) {
        Collection SAPs = null;
        if (!CollectionUtils.isEmpty(ifmList)) {
            try {
                SAPs = this.getSapTranslator().encode(ifmList, (IAsnTranslationContext)new AsnTranslationContext());
            }
            catch (VMFException e) {
                this.getLogger().error("translateInterfaces failed!", (Throwable)e);
            }
        }
        return SAPs;
    }

    public <T extends VmfMO> void unDeployMo(T mo, Class<T> clazz) throws VMFException {
        if (clazz.equals(TunnelPolicy.class)) {
            IMplsService mplsService = Activator.getService(IMplsService.class);
            mplsService.deleteTunnelPolicies(Arrays.asList(mo));
            return;
        }
        Context cxt = new Context(false);
        IMOChangeRecord rcd = cxt.addChangeRecord(clazz);
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(cxt);
        rcd.addDelete(mo);
        HashMap<FeatureName, List<Class>> features = new HashMap<FeatureName, List<Class>>();
        features.put(mo.getFeatureName(), Arrays.asList(clazz));
        DeviceAccessorFactory.getDefaultNetconfDeployer((int)mo.getDevID(), (Context)cxt).merge(features);
        dao.merge(clazz, true);
    }

    private void addInterfaceToTempContextForDeploy(Context cxt, EOperationType operType, Interface ifMo, L3vpnInstance vrf) {
        if (!EOperationType.DEPLOY.equals((Object)operType) || CollectionUtils.isEmpty((Collection)ifMo.getIpv4Addresss())) {
            return;
        }
        IMOChangeRecord vrfDBChangeRecord = cxt.getDBChangeRecord(L3vpnInstance.class);
        if (null == vrfDBChangeRecord || !vrfDBChangeRecord.isModified((Object)vrf, "deployStatus")) {
            return;
        }
        Interface target = Utility.cloneInterfaceKeysAndIP(ifMo);
        Context targetContext = this.getIfBandToVrfContext(cxt);
        targetContext.addChangeRecord(Interface.class).addModify((Object)target, Arrays.asList("ipv4Addresss"));
        targetContext.addChangeRecord(Ipv4Address.class).addCreate(target.getIpv4Addresss());
    }

    private void addKeyRef2MainMo(VmfMO mainMo, VmfMO mo, EOperationType operType, Context cxt) {
        if (mainMo == null) {
            return;
        }
        mainMo.addKeyRefMo(mo);
        IMOChangeRecord rcd = cxt.addChangeRecord(mainMo.getClass());
        switch (operType) {
            case DEPLOY: {
                if (rcd.isCreated((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case UNDEPLOY: {
                if (rcd.isDeleted((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case DELETE: {
                break;
            }
        }
    }

    private <T extends VmfMO> void addMo2Context(Context cxt, EOperationType operType, Class<T> clazz, Collection<T> mos, VmfMO mainMo) {
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        for (VmfMO mo : mos) {
            this.addMo2Context(cxt, operType, clazz, mo, mainMo);
        }
    }

    private <T extends VmfMO> void addMo2Context(Context cxt, EOperationType operType, Class<T> clazz, T mo, VmfMO mainMo) {
        switch (operType) {
            case CREATE: 
            case PREDEPLOY: {
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case DEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (Integer.valueOf(1).equals(((DeployableMO)mo).getDeployStatus())) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(1));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)1, (Object)0));
                }
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case UNDEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (!((DeployableMO)mo).getDeployStatus().equals(1)) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(0));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
                }
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case DELETE: {
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case GET: {
                break;
            }
            default: {
                this.logger.error("unsupported oper-type:" + operType.name());
                return;
            }
        }
        this.addKeyRef2MainMo(mainMo, mo, operType, cxt);
    }

    private void addRefMulticastMo(Collection<L3vpnInstance> l3vpns, Context cxt, EOperationType operType, IDao dao) {
        this.queryAndAddRefMo(MvpnFeature.class, l3vpns, dao, cxt, operType, "vrfName");
        this.queryAndAddRefMo(BsrAfsSiteCfg.class, l3vpns, dao, cxt, operType, "vrfName");
        this.queryAndAddRefMo(PimAfsSiteCfg.class, l3vpns, dao, cxt, operType, "vrfName");
    }

    private void addRefRouteMo(Collection<L3vpnInstance> l3vpns, Context cxt, EOperationType operType, IDao dao) {
        this.queryAndAddRefMo(SrRoute.class, l3vpns, dao, cxt, operType, "vrfName");
        this.queryAndAddRefMo(OspfSite.class, l3vpns, dao, cxt, operType, "vrfName");
        this.queryAndAddRefMo(BgpVrf.class, l3vpns, dao, cxt, operType, "vrfName");
        this.queryAndAddRefMo(IsSite.class, l3vpns, dao, cxt, operType, "vpnName");
    }

    private void addRefUniQos(Collection<L3vpnInstance> l3vpns, IAsnTranslationContext asnTranslatorContext, EOperationType operType) {
        Object qosSrv = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQosService.class);
        if (null != qosSrv) {
            ((IQosService)qosSrv).getL3vpnQosFromDB(l3vpns);
            switch (operType) {
                case DELETE: {
                    for (L3vpnInstance vpn : l3vpns) {
                        ((IQosService)qosSrv).decodeDelL3vpnQos(vpn, (Object)asnTranslatorContext);
                    }
                    break;
                }
                case DEPLOY: 
                case UNDEPLOY: {
                    for (L3vpnInstance vpn : l3vpns) {
                        try {
                            String strKey = CommonUtil.composeTmpKey((Object[])new Object[]{vpn.getDevID(), vpn.getVrfName()});
                            QAsnRoutingInstance instance = (QAsnRoutingInstance)asnTranslatorContext.getProperty(strKey);
                            ((IQosService)qosSrv).decodeDeployL3vpnUniQos(vpn, instance, (Object)asnTranslatorContext);
                        }
                        catch (VMFException e) {
                            this.getLogger().error("decodeDeployL3vpnUniQos error", (Throwable)e);
                        }
                    }
                    break;
                }
            }
        }
    }

    private void addStaticArpToTempContextForDeploy(Context cxt, EOperationType operType) {
        if (!EOperationType.DEPLOY.equals((Object)operType)) {
            return;
        }
        IMOChangeRecord arpStatic = cxt.addChangeRecord(ArpStaticTable.class);
        Context targetContext = this.getStaticArpToVrfContext(cxt);
        targetContext.addChangeRecord(ArpStaticTable.class).addCreate((Collection)arpStatic.getCreates());
        targetContext.addChangeRecord(ArpStaticTable.class).addDelete((Collection)arpStatic.getDeletes());
        arpStatic.getCreates().clear();
        arpStatic.getDeletes().clear();
        if (arpStatic.hasModify()) {
            Set modifyMos = arpStatic.getModifies();
            for (ArpStaticTable modifyMo : modifyMos) {
                targetContext.addChangeRecord(ArpStaticTable.class).addModify((Object)modifyMo, new PropertyChangeItem("ifName", (Object)modifyMo.getIfName(), (Object)modifyMo.getIfName()));
                targetContext.addChangeRecord(ArpStaticTable.class).addModify((Object)modifyMo, new PropertyChangeItem("peVid", (Object)modifyMo.getPeVid(), (Object)modifyMo.getPeVid()));
            }
        }
        arpStatic.getModifies().clear();
    }

    private void getAllMosByVpnKeys(Collection<L3vpnInstance> l3vpns, IDao dao) {
        Context cxt = new Context();
        this.addRefRouteMo(l3vpns, cxt, EOperationType.GET, dao);
        this.queryAndAddRefMo(UniAf.class, l3vpns, dao, cxt, EOperationType.GET, "vrfName");
        this.addRefMulticastMo(l3vpns, cxt, EOperationType.GET, dao);
        AsnTranslationContext asnTranslatorContext = new AsnTranslationContext();
        this.addRefUniQos(l3vpns, (IAsnTranslationContext)asnTranslatorContext, EOperationType.GET);
    }

    private Collection<L3vpnInstance> getAllMosByVpnKeys(Collection<QAsnUniResID> l3vpnKeyList, IAsnTranslationContext asnTranslatorContext, EOperationType operType, IDao dao) throws VMFException {
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        Context cxt = asnTranslatorContext == null ? new Context() : asnTranslatorContext.getTransactionContext();
        LinkedList<L3vpnInstance> l3vpnKeys = new LinkedList<L3vpnInstance>();
        for (QAsnUniResID fdnAsn : l3vpnKeyList) {
            L3vpnInstance l3vpn = (L3vpnInstance)fdnParser.getIndexMo(fdnAsn);
            l3vpnKeys.add(l3vpn);
        }
        Collection<L3vpnInstance> l3vpns = this.queryVrfFromDBByKey(l3vpnKeys, dao);
        this.addMo2Context(cxt, operType, (Class)L3vpnInstance.class, (VmfMO)l3vpns, null);
        this.processNotExistVrf(l3vpnKeys, l3vpns, cxt, operType);
        this.getDhcpService().processDhcpRelayVpn(l3vpns, (Object)cxt, operType);
        Map<L3vpnInstance, Collection<Interface>> vrf2Sap = this.querySapByL3vpn(l3vpns, dao, asnTranslatorContext);
        this.getDhcpService().processDhcpToL3vpn(vrf2Sap, (Object)asnTranslatorContext);
        for (Map.Entry<L3vpnInstance, Collection<Interface>> entey : vrf2Sap.entrySet()) {
            for (Interface ifMo : entey.getValue()) {
                this.addMo2Context(cxt, operType, Interface.class, ifMo, (VmfMO)entey.getKey());
                this.addInterfaceToTempContextForDeploy(cxt, operType, ifMo, entey.getKey());
                this.addMo2Context(cxt, operType, (Class)ServiceInterface.class, (VmfMO)ifMo.getKeyRefMos(ServiceInterface.class), (VmfMO)entey.getKey());
            }
        }
        this.queryAndAddRefMo(UniAf.class, l3vpns, dao, cxt, operType, "vrfName");
        this.addRefRouteMo(l3vpns, cxt, operType, dao);
        this.addRefMulticastMo(l3vpns, cxt, operType, dao);
        this.addRefUniQos(l3vpns, asnTranslatorContext, operType);
        this.getArpService().processStaticArp(l3vpns, (Object)cxt, operType);
        this.getArpService().processArpToL3vpn(vrf2Sap, (Object)asnTranslatorContext);
        this.addStaticArpToTempContextForDeploy(cxt, operType);
        return l3vpns;
    }

    private Object getField(VmfMO mo, String fieldNameRefVefName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String getterName = ReflectHelper.getterName((String)fieldNameRefVefName);
        Method method = mo.getClass().getMethod(getterName, new Class[0]);
        return method.invoke((Object)mo, new Object[0]);
    }

    private Logger getLogger() {
        return this.logger;
    }

    private boolean l3vpnIfIsCreated(L3vpnInstance vrf, Context context, String ifName) {
        if (context.getChangeRecord(L3vpnInstance.class).isCreated((Object)vrf)) {
            if (CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) {
                return false;
            }
            for (L3vpnIf vrfIf : vrf.getL3vpnIfs()) {
                if (!ObjectUtils.equals((Object)vrfIf.getIfName(), (Object)ifName)) continue;
                return true;
            }
            return false;
        }
        L3vpnIf vrfIf = new L3vpnIf();
        this.setChildMoKeyByParentMo((VmfMO)vrfIf, (VmfMO)vrf);
        vrfIf.setIfName(ifName);
        return context.getChangeRecord(L3vpnIf.class).isCreated((Object)vrfIf);
    }

    private void processNotExistVrf(Collection<L3vpnInstance> l3vpnKeys, Collection<L3vpnInstance> l3vpns, Context cxt, EOperationType operType) {
        HashSet<L3vpnInstance> flag = new HashSet<L3vpnInstance>();
        flag.addAll(l3vpns);
        for (L3vpnInstance vrf : l3vpnKeys) {
            if (flag.contains(vrf)) continue;
            this.logger.info(String.format("vrf[%d,%s] not exist opertype=%s", vrf.getDevID(), vrf.getVrfName(), operType.toString()));
            l3vpns.add(vrf);
            switch (operType) {
                case DEPLOY: 
                case UNDEPLOY: {
                    cxt.addMoOperResult((VmfMO)vrf, 555799286);
                    break;
                }
                case DELETE: {
                    cxt.addMoOperResult((VmfMO)vrf, 0);
                    break;
                }
            }
        }
    }

    private <T extends VmfMO> void queryAndAddRefMo(Class<T> clazz, Collection<L3vpnInstance> l3vpns, IDao dao, Context cxt, EOperationType operType, String fieldNameRefVefName) {
        try {
            Map<L3vpnInstance, Collection<T>> ret = this.queryRefMobyVPN(l3vpns, dao, clazz, fieldNameRefVefName);
            for (Map.Entry<L3vpnInstance, Collection<T>> entry : ret.entrySet()) {
                this.addMo2Context(cxt, operType, clazz, (T)entry.getValue(), (VmfMO)entry.getKey());
            }
        }
        catch (VMFException e) {
            this.getLogger().error("queryAndAddRefMo", (Throwable)e);
        }
    }

    private Collection<L3vpnInstance> queryVrfFromDBByKey(Collection<L3vpnInstance> keys, IDao dao) throws VMFException {
        return dao.queryByKey(L3vpnInstance.class, keys, true);
    }

    private void removeVrfIfOnInterfaceNotExist(Collection<L3vpnInstance> l3vpns, Set<String> ifKeys) {
        if (CollectionUtils.isEmpty(l3vpns)) {
            return;
        }
        for (L3vpnInstance vrf : l3vpns) {
            if (CollectionUtils.isEmpty((Collection)vrf.getL3vpnIfs())) continue;
            Iterator it = vrf.getL3vpnIfs().iterator();
            while (it.hasNext()) {
                if (ifKeys.contains(Utility.getIfKeys((L3vpnIf)it.next()))) continue;
                it.remove();
            }
        }
    }

    private void setField(VmfMO mo, String fieldNameRefVefName, Object value) {
        ReflectHelper.getInstance().setPropertyValue((Object)mo, fieldNameRefVefName, value);
    }

    private void sortIPV4Address(Collection<Ipv4Address> ipv4Addresss) {
        Iterator<Ipv4Address> it = ipv4Addresss.iterator();
        while (it.hasNext()) {
            Ipv4Address addr = it.next();
            if (!Ipv4Address.ADDR_TYPE_ENUM.MAIN.equals(addr.getAddrType())) continue;
            it.remove();
            ArrayList<Ipv4Address> tmp = new ArrayList<Ipv4Address>();
            tmp.add(addr);
            tmp.addAll(ipv4Addresss);
            ipv4Addresss.clear();
            ipv4Addresss.addAll(tmp);
            return;
        }
    }

    private static class DeployStatusRevisor {
        private final IAsnTranslationContext asnTranslationContext;
        private final Map<Class<? extends VmfMO>, Collection<VmfMO>> canceldDeleteMos;
        private final Context context;
        private Class<? extends VmfMO> mainMOType;

        public DeployStatusRevisor(IAsnTranslationContext asnTranslationContext, Class<? extends VmfMO> mainMOType, Map<Class<? extends VmfMO>, Collection<VmfMO>> canceldDeleteMos) {
            this.asnTranslationContext = asnTranslationContext;
            this.mainMOType = mainMOType;
            this.context = this.asnTranslationContext.getTransactionContext();
            this.canceldDeleteMos = canceldDeleteMos;
        }

        public void revise() {
            HashSet checkOperationTypes = new HashSet();
            Collections.addAll(checkOperationTypes, EOperationType.DEPLOY, EOperationType.MODIFY, EOperationType.UNDEPLOY);
            EOperationType operationType = this.asnTranslationContext.getOperType();
            if (!checkOperationTypes.contains(operationType)) {
                return;
            }
            Context context = this.asnTranslationContext.getTransactionContext();
            if (!context.getOperResult().hasFailed()) {
                return;
            }
            this.reviseDeployStatus();
        }

        private Collection<VmfMO> getAllMainMOs() {
            LinkedList<VmfMO> mainMOs = new LinkedList<VmfMO>();
            IMOChangeRecord changeRecord = this.context.getChangeRecord(this.mainMOType);
            if (null == changeRecord) {
                return mainMOs;
            }
            mainMOs.addAll(this.context.getChangeRecord(this.mainMOType).getModifies());
            if (EOperationType.DEPLOY.equals((Object)this.asnTranslationContext.getOperType())) {
                mainMOs.addAll(changeRecord.getCreates());
            }
            if (EOperationType.UNDEPLOY.equals((Object)this.asnTranslationContext.getOperType())) {
                mainMOs.addAll(changeRecord.getDeletes());
            }
            return mainMOs;
        }

        private Map<Class<? extends VmfMO>, List<? extends VmfMO>> getKeyRefMOs(VmfMO mainMO) {
            return mainMO.getKeyRefMos();
        }

        private boolean needRevise(VmfMO mo) {
            IMOChangeRecord changeRecord = this.context.getChangeRecord(mo.getClass());
            if (null == changeRecord) {
                return false;
            }
            if (EOperationType.DEPLOY.equals((Object)this.asnTranslationContext.getOperType())) {
                return changeRecord.isCreated((Object)mo);
            }
            if (EOperationType.UNDEPLOY.equals((Object)this.asnTranslationContext.getOperType())) {
                Collection<VmfMO> canceldMOs;
                boolean ret = changeRecord.isDeleted((Object)mo);
                if (!ret && null != this.canceldDeleteMos && null != (canceldMOs = this.canceldDeleteMos.get(mo.getClass())) && canceldMOs.contains(mo)) {
                    return true;
                }
                return ret;
            }
            if (EOperationType.MODIFY.equals((Object)this.asnTranslationContext.getOperType())) {
                boolean isDelete = changeRecord.isDeleted((Object)mo);
                boolean isCreate = changeRecord.isCreated((Object)mo);
                return isCreate && !isDelete;
            }
            return false;
        }

        private void reviseDeployStatus() {
            Collection<VmfMO> mainMOs = this.getAllMainMOs();
            for (VmfMO mainMO : mainMOs) {
                if (0 == this.context.getMoErrorCode(mainMO)) continue;
                Map<Class<? extends VmfMO>, List<? extends VmfMO>> keyRefs = this.getKeyRefMOs(mainMO);
                for (Class<? extends VmfMO> keyRefMOType : keyRefs.keySet()) {
                    if (!DeployableMO.class.isAssignableFrom(keyRefMOType)) continue;
                    for (VmfMO vmfMO : keyRefs.get(keyRefMOType)) {
                        if (!this.needRevise(vmfMO)) continue;
                        this.reviseDeployStatus(vmfMO);
                    }
                }
                this.reviseDeployStatus(mainMO);
            }
        }

        private void reviseDeployStatus(VmfMO mo) {
            IMOChangeRecord changeRecord = this.context.getChangeRecord(mo.getClass());
            if (this.needRevise(mo) && mo instanceof DeployableMO) {
                ((DeployableMO)mo).setDeployStatus(Integer.valueOf(changeRecord.isCreated((Object)mo) ? 0 : 1));
            }
        }
    }
}

