/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.l3vpn.common;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.MOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.l3vpn.common.MOIdentifierChecker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckedMOChangeRecord<T>
extends MOChangeRecord<T> {
    private final IMOChangeRecord<T> imp;
    private final Logger logger = LoggerFactory.getLogger(CheckedMOChangeRecord.class);

    private CheckedMOChangeRecord(IMOChangeRecord<T> imp) {
        this.imp = imp;
    }

    public static <T> IMOChangeRecord<T> newProxy(final IMOChangeRecord<T> imp) {
        final CheckedMOChangeRecord<T> wrapper = new CheckedMOChangeRecord<T>(imp);
        return (IMOChangeRecord)Proxy.newProxyInstance(imp.getClass().getClassLoader(), new Class[]{IMOChangeRecord.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object obj, Method method, Object[] aobj) throws Throwable {
                String methodName = method.getName();
                if (!methodName.matches("add(Create|Delete|Modify)")) {
                    return method.invoke((Object)imp, aobj);
                }
                if (aobj == null || aobj.length == 0) {
                    return method.invoke((Object)imp, aobj);
                }
                return method.invoke((Object)wrapper, aobj);
            }
        });
    }

    public void addCreate(Collection<T> mos) {
        for (T mo : mos) {
            try {
                MOIdentifierChecker.valid((VmfMO)mo);
            }
            catch (VMFException e) {
                this.logger.error(this.getLogInfo(mo), (Throwable)e);
                continue;
            }
            this.imp.addCreate(mo);
        }
    }

    public void addCreate(T mo) {
        try {
            MOIdentifierChecker.valid((VmfMO)mo);
        }
        catch (VMFException e) {
            this.logger.error(this.getLogInfo(mo), (Throwable)e);
            return;
        }
        this.imp.addCreate(mo);
    }

    public void addDelete(Collection<T> mos) {
        for (T mo : mos) {
            try {
                MOIdentifierChecker.valid((VmfMO)mo);
            }
            catch (VMFException e) {
                this.logger.error(this.getLogInfo(mo), (Throwable)e);
                continue;
            }
            this.imp.addDelete(mo);
        }
    }

    public void addDelete(T mo) {
        try {
            MOIdentifierChecker.valid((VmfMO)mo);
        }
        catch (VMFException e) {
            this.logger.error(this.getLogInfo(mo), (Throwable)e);
            return;
        }
        this.imp.addDelete(mo);
    }

    public void addModify(T mo, Collection<String> propertyNames) {
        try {
            MOIdentifierChecker.valid((VmfMO)mo);
        }
        catch (VMFException e) {
            this.logger.error(this.getLogInfo(mo), (Throwable)e);
            return;
        }
        if (this.imp.isCreated(mo)) {
            this.logger.error(String.format("mo[%s] %s is already added to context with CREATE flag, cancel MODIFY!", mo.getClass().getName(), mo.toString()));
            return;
        }
        this.imp.addModify(mo, propertyNames);
    }

    public void addModify(T mo, PropertyChangeItem changedItem) {
        try {
            MOIdentifierChecker.valid((VmfMO)mo);
        }
        catch (VMFException e) {
            this.logger.error(this.getLogInfo(mo), (Throwable)e);
            return;
        }
        if (this.imp.isCreated(mo)) {
            this.logger.error(String.format("mo[%s] %s is already added to context with CREATE flag, cancel MODIFY!", mo.getClass().getName(), mo.toString()));
            return;
        }
        this.imp.addModify(mo, changedItem);
    }

    private String getLogInfo(T mo) {
        return String.format("mo[%s]'s keys are incomplete : %s", mo.getClass().getName(), mo.toString());
    }
}

