/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfInfo;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfInfoTemplate;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;

public class QAsnShelfInfoTranslator
extends AbstractAsnTranslator<QAsnShelfInfo, Chassis> {
    public void decode(QAsnShelfInfo asn, Chassis mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Chassis mo, QAsnShelfInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Chassis chassis = mo;
        QAsnShelfInfo asnObj = asn;
        this.encodeNeID(asnObj, chassis, context);
        this.encodeShelfID(asnObj, chassis, context);
        this.encodeShelfName(asnObj, chassis, context);
        this.encodeShelfType(asnObj, chassis, context);
        this.encodeShelfLocation(asnObj, chassis, context);
        this.encodeVersion(asnObj, chassis, context);
        this.encodeUserLabel(asnObj, chassis, context);
        this.encodeOwner(asnObj, chassis, context);
        this.encodeMemo(asnObj, chassis, context);
    }

    public Class<QAsnShelfInfo> getAsnClass() {
        return QAsnShelfInfo.class;
    }

    public Class<Chassis> getMoClass() {
        return Chassis.class;
    }

    private void encodeMemo(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).memo) {
            asnObj.memo = this.getBytes(chassis.getMemo());
        }
    }

    private void encodeNeID(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        asnObj.neID = this.intValue(chassis.getDevID(), -1);
    }

    private void encodeOwner(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).owner) {
            asnObj.owner = this.getBytes(chassis.getOwner());
        }
    }

    private void encodeShelfID(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        asnObj.shelfID = this.intValue(chassis.getParentRelPosition(), -1);
    }

    private void encodeShelfLocation(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).shelfLocation) {
            asnObj.shelfLocation = this.getBytes(chassis.getEntPosition());
        }
    }

    private void encodeShelfName(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        asnObj.shelfName = null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).name ? this.getBytes(chassis.getName()) : this.getBytes("");
    }

    private void encodeShelfType(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        asnObj.shelfType = null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).shelfType ? this.intValue(chassis.getChassisType(), -1) : -1;
    }

    private void encodeUserLabel(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).userLabel) {
            asnObj.userLabel = this.getBytes(chassis.getUserLabel());
        }
    }

    private void encodeVersion(QAsnShelfInfo asnObj, Chassis chassis, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnShelfInfoTemplate)context.getTemplate()).version) {
            asnObj.version = this.getBytes(chassis.getSoftwareVersion());
        }
    }

    private Integer getChassisID(Integer chassisID) {
        if (null == chassisID || Integer.MAX_VALUE == chassisID) {
            return null;
        }
        return chassisID;
    }
}

