/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_projectalm.QAsnProjectAlarmObjInfo;
import com.huawei.network.qasn.m_q_projectalm.QAsnProjectAlarmObjInfoList;
import com.huawei.network.qasn.m_q_projectalm.QAsnSetProjectAlarmObjStatusReq;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FrameUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.NEUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.projectobj.model.ProjectObj;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstarctQAsnSetVmfMoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QAsnSetProjectObjTranslator
extends AbstarctQAsnSetVmfMoTranslator<QAsnSetProjectAlarmObjStatusReq> {
    private static final int BOARD_RES_TYPE = 5;
    private static final int CHASSIS_RES_TYPE = 4;
    private static final int NE_RES_TYPE = 3;
    private static final int PORT_RES_TYPE = 7;
    private static final int SUBCARD_RES_TYPE = 6;
    private QAsnSetProjectAlarmObjStatusReq asnReq = null;

    public List<ProjectObj> decode() throws VMFException {
        QAsnProjectAlarmObjInfoList asnList = this.asnReq.objStatusList;
        ArrayList<ProjectObj> projectLst = new ArrayList<ProjectObj>();
        ArrayList<ProjectObj> projectBoardLst = new ArrayList<ProjectObj>();
        ArrayList<ProjectObj> projectPortLst = new ArrayList<ProjectObj>();
        ArrayList<ProjectObj> projectSubCardLst = new ArrayList<ProjectObj>();
        for (QAsnProjectAlarmObjInfo asnObj : asnList) {
            ProjectObj projectobj = new ProjectObj();
            this.decodeBasic(projectobj, asnObj);
            projectLst.add(projectobj);
        }
        this.decodeDevInfo(projectLst);
        for (ProjectObj obj : projectLst) {
            int resType = obj.getResType();
            if (5 == resType) {
                this.decodeBoardInfo(obj);
                projectBoardLst.add(obj);
                continue;
            }
            if (7 == resType) {
                this.decodePortInfo(obj);
                projectPortLst.add(obj);
                continue;
            }
            if (6 == resType) {
                this.decodeSubCardInfo(obj);
                projectSubCardLst.add(obj);
                continue;
            }
            if (4 != resType) continue;
            this.decodeChassisInfo(obj);
        }
        this.decodeBoardName(projectBoardLst);
        this.decodePortAllName(projectPortLst);
        this.decodeSubSlotName(projectSubCardLst);
        return projectLst;
    }

    @Override
    public List<? extends VmfMO> decode(QAsnSetProjectAlarmObjStatusReq asnReq, IAsnTranslationContext context) throws VMFException {
        this.asnReq = asnReq;
        return this.decode();
    }

    public ProjectObj decodeBasic(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        this.decodeObjIndex(obj, asnObj);
        this.decodeDeviceID(obj, asnObj);
        this.decodeObjType(obj, asnObj);
        this.decodeMasStatus(obj, asnObj);
        obj.setOperType(Integer.valueOf(this.asnReq.operType.intValue()));
        return obj;
    }

    public void decodeBoardInfo(ProjectObj obj) {
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.deserialize(obj.getObjIndexFdn());
        obj.setChassisID(Integer.valueOf(parser.getFrameID()));
        Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != invUtilExtPoint && -1 == parser.getFrameID()) {
            obj.setChassisID(Integer.valueOf(1));
        }
        obj.setSlotID(Integer.valueOf(parser.getSlotID()));
    }

    public void decodeBoardName(List<ProjectObj> objLst) throws VMFException {
        if (objLst != null && objLst.isEmpty()) {
            return;
        }
        ArrayList<Board> boardIndexs = new ArrayList<Board>();
        for (ProjectObj obj : objLst) {
            Board board = new Board();
            board.setChassisID(obj.getChassisID());
            board.setSlotID(obj.getSlotID());
            board.setDevID(obj.getDevID());
            boardIndexs.add(board);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection boards = dao.queryByKey(Board.class, boardIndexs, false);
        block1: for (ProjectObj obj : objLst) {
            for (Board board : boards) {
                if (!this.isEqual(obj, (PhyEntity)board)) continue;
                obj.setSlotName(board.getName());
                continue block1;
            }
        }
    }

    public void decodeChassisID(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        obj.setChassisID(asnObj.poShelfID);
    }

    public void decodeChassisInfo(ProjectObj obj) {
        FrameUniResIDParser parser = new FrameUniResIDParser();
        parser.deserialize(obj.getObjIndexFdn());
        obj.setChassisID(Integer.valueOf(parser.getFrameID()));
        Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != invUtilExtPoint && -1 == parser.getFrameID()) {
            obj.setChassisID(Integer.valueOf(1));
        }
    }

    public void decodeDeviceID(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) {
        NEUniResIDParser parser = new NEUniResIDParser();
        parser = (NEUniResIDParser)parser.deserialize(obj.getObjIndexFdn());
        obj.setDevID(Integer.valueOf(parser.getDevID()));
    }

    public void decodeDeviceIP(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        String devIp = Activator.getDeviceService().getDevIPByID(asnObj.objIndex.neID);
        obj.setDevIP(devIp);
    }

    public void decodeDeviceName(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        String devName = Activator.getDeviceService().getDevNameByID(obj.getDevID().intValue());
        obj.setDevName(devName);
    }

    public void decodeDevInfo(List<ProjectObj> obj) throws VMFException {
        ArrayList<Integer> devIDLst = new ArrayList<Integer>();
        for (ProjectObj proObj : obj) {
            devIDLst.add(proObj.getDevID());
        }
        List devInfoLst = Activator.getDeviceService().getDevices(devIDLst);
        block1: for (ProjectObj proObj : obj) {
            for (DevSysInfo devInfo : devInfoLst) {
                if (!proObj.getDevID().equals(devInfo.getDevID())) continue;
                proObj.setDevIP(devInfo.getDevIP());
                proObj.setDevName(devInfo.getDevName());
                continue block1;
            }
        }
    }

    public void decodeMasStatus(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) {
        obj.setMaStatus(Integer.valueOf(asnObj.maStatus));
    }

    public void decodeObjIndex(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) {
        QAsnUniResID resID = asnObj.objIndex;
        obj.setObjIndexFdn(StringUtil.globalString((byte[])resID.strFDN));
    }

    public void decodeObjType(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) {
        String moc = StringUtil.globalString((byte[])asnObj.objIndex.strMOC);
        int resType = -1;
        if (moc != null) {
            if (moc.equals("NE")) {
                resType = 3;
            } else if (moc.equals("S") || moc.equals("CP")) {
                resType = 5;
            } else if (moc.equals("PP")) {
                resType = 7;
            }
        }
        obj.setResType(Integer.valueOf(resType));
    }

    public void decodePortAliasName(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        obj.setPortAliasName(StringUtil.globalString((byte[])asnObj.poAliasName));
    }

    public void decodePortAllName(List<ProjectObj> obj) throws VMFException {
        if (obj != null && obj.isEmpty()) {
            return;
        }
        this.decodeBoardName(obj);
        this.decodeSubSlotName(obj);
        this.decodePortName(obj);
    }

    public void decodePortInfo(ProjectObj obj) {
        PortUniResIDParser parser = new PortUniResIDParser();
        parser.deserialize(obj.getObjIndexFdn());
        obj.setChassisID(Integer.valueOf(parser.getFrameID()));
        Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != invUtilExtPoint && -1 == parser.getFrameID()) {
            obj.setChassisID(Integer.valueOf(1));
        }
        obj.setSlotID(Integer.valueOf(parser.getSlotID()));
        obj.setSubSlotID(parser.getSubSlotID());
        if (null != invUtilExtPoint && null == parser.getSubSlotID()) {
            obj.setChassisID(Integer.valueOf(-1));
        }
        obj.setPortID(Integer.valueOf(parser.getPortID()));
        obj.setDevID(obj.getDevID());
    }

    public void decodePortName(List<ProjectObj> objLst) throws VMFException {
        ArrayList<Port> portIndexs = new ArrayList<Port>();
        for (ProjectObj obj : objLst) {
            Port port = new Port();
            port.setChassisID(obj.getChassisID());
            port.setSlotID(obj.getSlotID());
            port.setDevID(obj.getDevID());
            port.setSubSlotID(obj.getSubSlotID());
            port.setParentRelPosition(obj.getPortID());
            portIndexs.add(port);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection ports = dao.queryByKey(Port.class, portIndexs, false);
        block1: for (ProjectObj obj : objLst) {
            for (Port port : ports) {
                if (!this.isEqual(obj, (PhyEntity)port)) continue;
                obj.setPortName(port.getName());
                continue block1;
            }
        }
    }

    public void decodePortName(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        obj.setPortName(StringUtil.globalString((byte[])asnObj.poPortName));
    }

    public void decodeSlotName(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        obj.setSlotName(StringUtil.globalString((byte[])asnObj.poSlotName));
    }

    public void decodeSubCardInfo(ProjectObj obj) {
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.deserialize(obj.getObjIndexFdn());
        obj.setChassisID(Integer.valueOf(parser.getFrameID()));
        Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != invUtilExtPoint && -1 == parser.getFrameID()) {
            obj.setChassisID(Integer.valueOf(1));
        }
        obj.setSlotID(Integer.valueOf(parser.getSlotID()));
        obj.setSubSlotID(parser.getSubSlotID());
    }

    public void decodeSubSlotName(List<ProjectObj> objLst) throws VMFException {
        ArrayList<SubCard> subCardIndexs = new ArrayList<SubCard>();
        for (ProjectObj obj : objLst) {
            SubCard card = new SubCard();
            card.setChassisID(obj.getChassisID());
            card.setSlotID(obj.getSlotID());
            card.setDevID(obj.getDevID());
            card.setSubSlotID(obj.getSubSlotID());
            subCardIndexs.add(card);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection subCards = dao.queryByKey(SubCard.class, subCardIndexs, false);
        block1: for (ProjectObj obj : objLst) {
            for (SubCard card : subCards) {
                if (!this.isEqual(obj, (PhyEntity)card)) continue;
                obj.setSubslotName(card.getName());
                continue block1;
            }
        }
    }

    public void decodeSubSlotName(ProjectObj obj, QAsnProjectAlarmObjInfo asnObj) throws VMFException {
        obj.setSubslotName(StringUtil.globalString((byte[])asnObj.poSubSlotName));
    }

    public boolean isEqual(ProjectObj obj, PhyEntity entity) {
        SubCard card;
        Port port;
        if (entity instanceof Board) {
            Board board = (Board)entity;
            if (obj.getDevID().equals(board.getDevID()) && obj.getChassisID().equals(board.getChassisID()) && obj.getSlotID().equals(board.getSlotID())) {
                return true;
            }
        } else if (entity instanceof Port ? (port = (Port)entity).getDevID().equals(obj.getDevID()) && port.getChassisID().equals(obj.getChassisID()) && port.getSlotID().equals(obj.getSlotID()) && port.getSubSlotID().equals(obj.getSubSlotID()) && port.getParentRelPosition().equals(obj.getPortID()) : (card = (SubCard)entity).getDevID().equals(obj.getDevID()) && card.getChassisID().equals(obj.getChassisID()) && card.getSlotID().equals(obj.getSlotID()) && card.getSubSlotID().equals(obj.getSubSlotID())) {
            return true;
        }
        return false;
    }
}

