/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfo;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfoList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfoTemplate;
import com.huawei.network.qasn.m_q_inventory_port.QAsnSetPortInfoReq;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnSetTranslator;
import java.util.ArrayList;
import java.util.List;

public class QAsnSetPortInfoTranslator
extends AbstractQAsnSetTranslator<QAsnSetPortInfoReq> {
    private QAsnSetPortInfoReq asnReq;

    public List<Port> decode() {
        QAsnPortInfoList asnPortLst = this.asnReq.portInfoList;
        ArrayList<Port> portList = new ArrayList<Port>();
        for (QAsnPortInfo asnPort : asnPortLst) {
            Port port = new Port();
            this.decode(asnPort, port);
            portList.add(port);
        }
        return portList;
    }

    private void decode(QAsnPortInfo asnPort, Port port) {
        this.decodeDevID(asnPort, port);
        this.decodeChassisID(port, asnPort);
        this.decodeSlotID(port, asnPort);
        this.decodeSubSlotID(port, asnPort);
        this.decodePortID(port, asnPort);
        this.decodeOwner(port, asnPort);
        this.decodeMemo(port, asnPort);
    }

    private void decodeDevID(QAsnPortInfo asnPort, Port port) {
        port.setDevID(Integer.valueOf(asnPort.portIndex.neID));
    }

    @Override
    public List<? extends PhyEntity> decode(QAsnSetPortInfoReq asnReq, IAsnTranslationContext context) {
        this.asnReq = asnReq;
        return this.decode();
    }

    public void decodeMemo(Port mappingMo, QAsnPortInfo asnObj) {
        boolean needDecode;
        QAsnPortInfoTemplate template = this.asnReq.attrTemplate;
        boolean bl = template == null ? true : (needDecode = template.userLabel != null && template.userLabel.strCondition != null);
        if (needDecode && null != asnObj.userLabel) {
            String value = StringUtil.globalString((byte[])asnObj.userLabel);
            mappingMo.setMemo(value);
        }
    }

    public void decodeOwner(Port mappingMo, QAsnPortInfo asnObj) {
        boolean needDecode;
        QAsnPortInfoTemplate template = this.asnReq.attrTemplate;
        boolean bl = template == null ? true : (needDecode = template.owner != null && template.owner.strCondition != null);
        if (needDecode && null != asnObj.owner) {
            String value = StringUtil.globalString((byte[])asnObj.owner);
            mappingMo.setOwner(value);
        }
    }

    private void decodeChassisID(Port port, QAsnPortInfo asnPort) {
        if (asnPort != null && asnPort.portIndex != null) {
            port.setChassisID(asnPort.portIndex.shelfID);
        }
    }

    private void decodePortID(Port port, QAsnPortInfo asnPort) {
        if (asnPort != null && asnPort.portIndex != null) {
            port.setParentRelPosition(Integer.valueOf(asnPort.portIndex.portID));
        }
    }

    private void decodeSlotID(Port port, QAsnPortInfo asnPort) {
        if (asnPort != null && asnPort.portIndex != null) {
            port.setSlotID(Integer.valueOf(asnPort.portIndex.slotID));
        }
    }

    private void decodeSubSlotID(Port port, QAsnPortInfo asnPort) {
        if (asnPort != null && asnPort.portIndex != null) {
            port.setSubSlotID(asnPort.portIndex.subSlotID);
        }
    }
}

