/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_shelf.QAsnSetShelfInfoReq;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfInfo;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfInfoList;
import com.huawei.network.qasn.m_q_inventory_shelf.QAsnShelfInfoTemplate;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.inventory.fault.ChassisFault;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnSetTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QAsnSetChassisInfoTranslator
extends AbstractQAsnSetTranslator<QAsnSetShelfInfoReq> {
    private static final Logger logger = LoggerFactory.getLogger(ChassisFault.class);
    private QAsnSetShelfInfoReq asnReq;
    private QAsnShelfInfoTemplate attrTemplate;

    public List<Chassis> decode() {
        QAsnShelfInfoList asnShelfLst = this.asnReq.shelfInfoList;
        ArrayList<Chassis> chassisList = new ArrayList<Chassis>();
        for (QAsnShelfInfo asnShelfInfo : asnShelfLst) {
            Chassis chassis = new Chassis();
            chassis.setDevID(Integer.valueOf(asnShelfInfo.neID));
            chassis.setParentRelPosition(Integer.valueOf(asnShelfInfo.shelfID));
            chassis = this.getEntIndex(chassis);
            this.decodeMemo(asnShelfInfo, chassis);
            this.decodeOwner(asnShelfInfo, chassis);
            this.decodeUserLabel(asnShelfInfo, chassis);
            chassisList.add(chassis);
        }
        return chassisList;
    }

    @Override
    public List<? extends PhyEntity> decode(QAsnSetShelfInfoReq asnReq, IAsnTranslationContext context) {
        this.asnReq = asnReq;
        return this.decode();
    }

    public void decodeMemo(QAsnShelfInfo asnShelfInfo, Chassis chassis) {
        boolean needDecode;
        boolean bl = this.attrTemplate == null ? true : (needDecode = this.attrTemplate.memo.strCondition != null);
        if (needDecode && null != asnShelfInfo.memo) {
            String value = StringUtil.globalString((byte[])asnShelfInfo.memo);
            chassis.setMemo(value);
        }
    }

    public void decodeOwner(QAsnShelfInfo asnShelfInfo, Chassis chassis) {
        boolean needDecode;
        boolean bl = this.attrTemplate == null ? true : (needDecode = this.attrTemplate.owner.strCondition != null);
        if (needDecode && null != asnShelfInfo.owner) {
            String value = StringUtil.globalString((byte[])asnShelfInfo.owner);
            chassis.setOwner(value);
        }
    }

    public void decodeUserLabel(QAsnShelfInfo asnShelfInfo, Chassis chassis) {
        boolean needDecode;
        boolean bl = this.attrTemplate == null ? true : (needDecode = this.attrTemplate.userLabel.strCondition != null);
        if (needDecode && null != this.asnReq) {
            String value = StringUtil.globalString((byte[])asnShelfInfo.userLabel);
            chassis.setUserLabel(value);
        }
    }

    protected Collection<Chassis> queryMoInfos(List<Chassis> moIndexes) throws VMFException {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = moIndexes.iterator().next().getClass();
        return dao.queryByKey(clazz, moIndexes, false);
    }

    private Chassis getEntIndex(Chassis shelf) {
        ArrayList<Chassis> mos = new ArrayList<Chassis>();
        try {
            Iterator<Chassis> i$;
            mos.add(shelf);
            Collection<Chassis> chassiss = this.queryMoInfos(mos);
            if (null != chassiss && !chassiss.isEmpty() && (i$ = chassiss.iterator()).hasNext()) {
                Chassis res = i$.next();
                return res;
            }
            return shelf;
        }
        catch (VMFException e) {
            logger.error("Set QAsnSetChassisInfoTranslator getEntIndex failed ", (Throwable)e);
            return shelf;
        }
    }
}

