/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfoList;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnSetNECPInfoReq;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.fault.BoardFault;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnSetTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QAsnSetCPInfoTranslator
extends AbstractQAsnSetTranslator<QAsnSetNECPInfoReq> {
    private static final Logger logger = LoggerFactory.getLogger(BoardFault.class);
    private QAsnSetNECPInfoReq asnReq;

    public List<Card> decode() {
        QAsnCPInfoList qCPInfoLst = this.asnReq.cpInfoList;
        ArrayList<Card> cardLst = new ArrayList<Card>();
        for (QAsnCPInfo cpInfo : qCPInfoLst) {
            cardLst.add(this.decode(cpInfo));
        }
        return cardLst;
    }

    public Card decode(QAsnCPInfo cpInfo) {
        Board card = null;
        int devID = cpInfo.cpIndex.neID;
        int chassisID = cpInfo.cpIndex.shelfID;
        int slotID = cpInfo.cpIndex.slotID;
        int subSlotID = -1;
        if (null != cpInfo.cpIndex.subSlotID && cpInfo.cpIndex.subSlotID >= 0) {
            subSlotID = cpInfo.cpIndex.subSlotID;
            card = new SubCard();
            ((SubCard)card).setSubSlotID(Integer.valueOf(subSlotID));
        } else {
            card = new Board();
        }
        card.setDevID(Integer.valueOf(devID));
        card.setChassisID(Integer.valueOf(chassisID));
        card.setSlotID(Integer.valueOf(slotID));
        ArrayList<Card> mos = new ArrayList<Card>();
        try {
            mos.add((Card)card);
            Collection<Card> cards = this.queryMoInfos(mos);
            if (null != cards && !cards.isEmpty()) {
                for (Card res : cards) {
                    card = res;
                }
            }
        }
        catch (VMFException e) {
            logger.error("Set QAsnSetCPInfoTranslator getEntIndex failed ", (Throwable)e);
        }
        this.decodeMemo(cpInfo, (Card)card);
        this.decodeOwner(cpInfo, (Card)card);
        this.decodeUserLabel(cpInfo, (Card)card);
        return card;
    }

    @Override
    public List<? extends PhyEntity> decode(QAsnSetNECPInfoReq asnReq, IAsnTranslationContext context) {
        this.context = context;
        this.asnReq = asnReq;
        return this.decode();
    }

    public void decodeMemo(QAsnCPInfo asnObj, Card mappingMo) {
        boolean changed = false;
        if (this.asnReq.attrTemplate != null && this.asnReq.attrTemplate.memo != null) {
            boolean bl = changed = this.asnReq.attrTemplate.memo.strCondition != null;
        }
        if (changed && null != asnObj.memo) {
            String value = StringUtil.globalString((byte[])asnObj.memo);
            mappingMo.setMemo(value);
        }
    }

    public void decodeOwner(QAsnCPInfo asnObj, Card mappingMo) {
        boolean changed = false;
        if (this.asnReq.attrTemplate != null && this.asnReq.attrTemplate.owner != null) {
            boolean bl = changed = this.asnReq.attrTemplate.owner.strCondition != null;
        }
        if (changed && null != asnObj.owner) {
            String value = StringUtil.globalString((byte[])asnObj.owner);
            mappingMo.setOwner(value);
        }
    }

    public void decodeUserLabel(QAsnCPInfo asnObj, Card mappingMo) {
        boolean changed = false;
        if (this.asnReq.attrTemplate != null && this.asnReq.attrTemplate.userLabel != null) {
            boolean bl = changed = this.asnReq.attrTemplate.userLabel.strCondition != null;
        }
        if (changed && null != asnObj.userLabel) {
            String value = StringUtil.globalString((byte[])asnObj.userLabel);
            mappingMo.setUserLabel(value);
        }
    }

    protected Collection<Card> queryMoInfos(List<Card> moIndexes) throws VMFException {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Class<?> clazz = moIndexes.iterator().next().getClass();
        return dao.queryByKey(clazz, moIndexes, false);
    }
}

