/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_projectalm.QAsnProjectAlarmObjInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.projectobj.model.ProjectObj;
import net.commustru.fstru.FStruct;

public class QAsnProjectAlarmObjInfoTranslator
extends AbstractAsnTranslator<QAsnProjectAlarmObjInfo, ProjectObj> {
    public void decode(QAsnProjectAlarmObjInfo asn, ProjectObj mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(ProjectObj mo, QAsnProjectAlarmObjInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.setDefaultAsnValue((FStruct)asn);
        QAsnProjectAlarmObjInfo asnProject = asn;
        ProjectObj proObj = mo;
        this.encodeObjIndexFdn(asnProject, proObj);
        this.encodeObjType(asnProject, proObj);
        this.encodeMaStatus(asnProject, proObj);
        this.encodeDevIP(asnProject, proObj);
        this.encodeDevName(asnProject, proObj);
        this.encodeSlotName(asnProject, proObj);
        this.encodeSubSlotName(asnProject, proObj);
        this.encodePortAliasName(asnProject, proObj);
        this.encodePortName(asnProject, proObj);
    }

    public Class<QAsnProjectAlarmObjInfo> getAsnClass() {
        return QAsnProjectAlarmObjInfo.class;
    }

    public Class<ProjectObj> getMoClass() {
        return ProjectObj.class;
    }

    private void encodeDevIP(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        asnProject.poNeIP = StringUtil.globalByte((String)proObj.getDevIP());
    }

    private void encodeDevName(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        asnProject.poNeName = StringUtil.globalByte((String)proObj.getDevName());
    }

    private void encodeMaStatus(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        asnProject.maStatus = proObj.getMaStatus();
    }

    private void encodeObjIndexFdn(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        QAsnUniResID asnResID = new QAsnUniResID();
        asnResID.neID = proObj.getDevID();
        asnResID.strFDN = proObj.getObjIndexFdn().getBytes();
        asnResID.strMOC = "".getBytes();
        asnProject.objIndex = asnResID;
    }

    private void encodeObjType(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        asnProject.objType = proObj.getResType();
    }

    private void encodePortAliasName(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        byte[] portAliasName = StringUtil.globalByte((String)proObj.getPortAliasName());
        asnProject.poAliasName = portAliasName;
    }

    private void encodePortName(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        byte[] portName = StringUtil.globalByte((String)proObj.getPortName());
        asnProject.poPortName = portName;
    }

    private void encodeSlotName(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        byte[] slotName = StringUtil.globalByte((String)proObj.getSlotName());
        asnProject.poSlotName = slotName;
    }

    private void encodeSubSlotName(QAsnProjectAlarmObjInfo asnProject, ProjectObj proObj) {
        byte[] subSlotName = StringUtil.globalByte((String)proObj.getSubslotName());
        asnProject.poSubSlotName = subSlotName;
    }
}

