/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnIDAndValueString;
import com.huawei.network.qasn.m_q_common.QAsnIVSList;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortSpecialInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.ifm.task.IQAsnGetPortDetailInfoTaskExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnPortTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Collection;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class QAsnPortSpecialInfoTranslator
extends AbstractQAsnPortTranslator<QAsnPortSpecialInfo, Port> {
    private static final int MEDIUM_TYPE = 2901;
    private static final int IS_USED = 391;
    private static final int USED = 2;
    private static final int UNUSED = 1;

    public void decode(QAsnPortSpecialInfo asn, Port mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Port mo, QAsnPortSpecialInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == asn || null == mo) {
            return;
        }
        Assert.isInstanceOf(Port.class, (Object)mo, (String)("mo type not match:" + mo.getClass()));
        Assert.isInstanceOf(QAsnPortSpecialInfo.class, (Object)asn, (String)("decode type not match:" + asn.getClass()));
        Port port = mo;
        QAsnPortSpecialInfo asnObj = asn;
        this.encodePortIndex(asnObj, port, context);
        asnObj.domainType = 1;
        Object extendPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnGetPortDetailInfoTaskExtPoint.class);
        if (null != extendPoint) {
            if (null == asnObj.exAttribList) {
                asnObj.exAttribList = new QAsnIVSList();
            }
            this.encodePoSpecialAttr(2901, QAsnPortSpecialInfoTranslator.getMediumType(port.getMediumType()), asnObj.exAttribList);
            if (null == port || port.getKeyRefMos(Interface.class) == null || CollectionUtils.isEmpty((Collection)port.getKeyRefMos(Interface.class))) {
                return;
            }
            Interface ifm = (Interface)port.getKeyRefMos(Interface.class).iterator().next();
            this.encodePoSpecialAttr(391, null != ifm.getIsActorBearSrv() && ifm.getIsActorBearSrv() != false ? 2 : 1, asnObj.exAttribList);
        }
    }

    public static Integer getMediumType(Integer iType) {
        if (null == iType) {
            return null;
        }
        if (Port.MEDIUM_TYPE_ENUM.COPPER.equals(iType)) {
            return 0;
        }
        if (Port.MEDIUM_TYPE_ENUM.FIBER.equals(iType)) {
            return 1;
        }
        return 0;
    }

    private void encodePoSpecialAttr(int id, Integer value, QAsnIVSList exAttribList) {
        if (null == value) {
            return;
        }
        QAsnIDAndValueString idAndValue = new QAsnIDAndValueString();
        idAndValue.id = id;
        idAndValue.value = null != value ? StringUtil.globalByte((String)value.toString()) : StringUtil.globalByte((String)"");
        exAttribList.add((Object)idAndValue);
    }

    public Class<QAsnPortSpecialInfo> getAsnClass() {
        return QAsnPortSpecialInfo.class;
    }

    public Class<Port> getMoClass() {
        return Port.class;
    }

    private void encodePortIndex(QAsnPortSpecialInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.portIndex = this.encodeIndex(port);
    }

    public static class QMediumType {
        public static final int COPPER = 0;
        public static final int FIBER = 1;
    }
}

