/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_cp.QAsnPortSFPInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;

public class QAsnPortSFPInfoTranslator
extends AbstractAsnTranslator<QAsnPortSFPInfo, Pair<Port, RuModuleInfo>> {
    public void decode(QAsnPortSFPInfo asn, Pair<Port, RuModuleInfo> mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Pair<Port, RuModuleInfo> mo, QAsnPortSFPInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Pair<Port, RuModuleInfo> portInfo = mo;
        QAsnPortSFPInfo asnObj = asn;
        this.encodePortName(asnObj, portInfo, context);
        this.encodePortSFPInfo(asnObj, portInfo, context);
        this.encodePortPlugFlag(asnObj, portInfo, context);
        this.encodePortClei(asnObj, portInfo, context);
        this.encodePortBarCode(asnObj, portInfo, context);
        this.encodePortItem(asnObj, portInfo, context);
        this.encodePortManufactured(asnObj, portInfo, context);
    }

    public Class<QAsnPortSFPInfo> getAsnClass() {
        return QAsnPortSFPInfo.class;
    }

    @Deprecated
    public Class<Pair<Port, RuModuleInfo>> getMoClass() {
        return null;
    }

    private void encodePortBarCode(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        if (null != portInfo.getValue()) {
            asnObj.portBarCode = this.getBytes(((RuModuleInfo)portInfo.getValue()).getHwIssueNum());
        }
    }

    private void encodePortClei(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        if (null != portInfo.getValue()) {
            asnObj.portClei = this.getBytes(((RuModuleInfo)portInfo.getValue()).getHwCLEICode());
        }
    }

    private void encodePortItem(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        if (null != portInfo.getValue()) {
            asnObj.portItem = this.getBytes(((RuModuleInfo)portInfo.getValue()).getHwBomID());
        }
    }

    private void encodePortManufactured(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        if (null != portInfo.getValue()) {
            asnObj.portmanufactured = this.getBytes(((RuModuleInfo)portInfo.getValue()).getHwManuDate());
        }
    }

    private void encodePortName(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        asnObj.portName = this.getBytes(((Port)portInfo.getKey()).getName());
    }

    private void encodePortPlugFlag(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        Port port = (Port)portInfo.getKey();
        asnObj.portPlugFlag = 4 == port.getOperStatus() ? 0 : 1;
    }

    private void encodePortSFPInfo(QAsnPortSFPInfo asnObj, Pair<Port, RuModuleInfo> portInfo, IAsnTranslationContext context) {
        if (null != portInfo.getValue()) {
            asnObj.portSFPInfo = this.getBytes(((RuModuleInfo)portInfo.getValue()).getHwBomEnDesc());
        }
    }
}

