/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.global.UnitedConfiguration;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnPortTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class QAsnPortInfoTranslator
extends AbstractQAsnPortTranslator<QAsnPortInfo, Object> {
    public static final int INVALID_IF_TYPE = 0;
    public static final int INVALID_DATA = 0;
    public static final int INVALID_DATA2 = -1;
    private static Map<Pattern, Integer> IFNAME_PORTTYPE_MAPPING = null;

    public static int getPortLevelFromIfName(String ifName) {
        if (ifName == null) {
            return 0;
        }
        int ret = 0;
        for (Map.Entry<Pattern, Integer> entry : IFNAME_PORTTYPE_MAPPING.entrySet()) {
            if (!entry.getKey().matcher(ifName).find()) continue;
            ret = entry.getValue();
            break;
        }
        return ret;
    }

    public void decode(QAsnPortInfo asn, Object mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Object mo, QAsnPortInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.setDefaultAsnValue((FStruct)asn);
        QAsnPortInfo asnObj = asn;
        if (mo instanceof Pair) {
            Pair moPair = (Pair)mo;
            Port port = (Port)moPair.getKey();
            port.addKeyRefMo((VmfMO)moPair.getValue());
            this.encodePortInfo(asnObj, port, context);
            this.encodePortSpeed(asnObj, (Pair<Port, Interface>)moPair, context);
        } else if (mo instanceof Port) {
            this.encodePortInfo(asnObj, (Port)mo, context);
        } else {
            QAsnPortInfoTranslator.getLogger().info("mo type is error. moType=" + mo.getClass());
        }
    }

    public Class<QAsnPortInfo> getAsnClass() {
        return QAsnPortInfo.class;
    }

    public Class<Object> getMoClass() {
        return Object.class;
    }

    private void encodeAdministrativeState(QAsnPortInfo asnObj, Port port, Interface inf, IAsnTranslationContext context) {
        asnObj.administrativeState = null != inf ? Integer.valueOf(AsnTranslatorUtil.intValue((Integer)inf.getIfAdminStatus())) : Integer.valueOf(UnitedConfiguration.encodeAdminStatus((Integer)port.getAdminStatus()));
    }

    private void encodeDirection(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.direction = 2;
    }

    private void encodeIsPhysical(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.isPhysical = 1;
    }

    private void encodeIsSupFiber(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.isSupFiber = 0;
    }

    private void encodeLevel(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        Object inventoryUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != inventoryUtilExtPoint) {
            List ifmList = port.getKeyRefMos(Interface.class);
            if (!CollectionUtils.isEmpty((Collection)ifmList)) {
                asnObj.level = this.getPTNPortLevel((Interface)ifmList.iterator().next());
            } else {
                Interface ifm = new Interface();
                ifm.setDevID(port.getDevID());
                ifm.setVrID(port.getVrID());
                ifm.setIfName(port.getName());
                asnObj.level = this.getPTNPortLevel(ifm);
            }
        } else {
            asnObj.level = 0;
        }
    }

    private void encodeName(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.name = this.getBytes(port.getName());
    }

    private void encodeOpertionState(QAsnPortInfo asnObj, Port port, Interface inf, IAsnTranslationContext context) {
        asnObj.opertionState = null != inf ? Integer.valueOf(AsnTranslatorUtil.intValue((Integer)inf.getIfOperStatus())) : Integer.valueOf(UnitedConfiguration.encodeOperStatus((Integer)port.getOperStatus()));
    }

    private void encodeOwner(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.owner = this.getBytes(port.getOwner());
    }

    private void encodePoFDN(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        String strFDN = "";
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            Integer subSlot = port.getSubSlotID();
            PortUniResIDParser portParser = new PortUniResIDParser(port.getDevID().intValue(), port.getChassisID().intValue(), port.getSlotID().intValue(), subSlot, port.getParentRelPosition().intValue(), port.getName());
            portParser.setPortDomain(Integer.valueOf(16));
            portParser.setPortType(null);
            portParser.setCliName(null);
            strFDN = portParser.serialize();
        } else {
            PortUniResIDParser portParser = new PortUniResIDParser(port.getDevID().intValue(), port.getChassisID().intValue(), port.getSlotID().intValue(), port.getParentRelPosition().intValue(), port.getName());
            strFDN = portParser.serialize();
        }
        asnObj.poFDN = this.getBytes(strFDN);
    }

    private void encodePortIndex(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.portIndex = this.encodeIndex(port);
    }

    private void encodePortInfo(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        this.encodePortIndex(asnObj, port, context);
        this.encodeName(asnObj, port, context);
        this.encodeType(asnObj, port, context);
        this.encodeLevel(asnObj, port, context);
        this.encodeDirection(asnObj, port, context);
        this.encodePortLabel(asnObj, port, context);
        this.encodeIsPhysical(asnObj, port, context);
        this.encodeIsSupFiber(asnObj, port, context);
        this.encodeUserLabel(asnObj, port, context);
        this.encodeOwner(asnObj, port, context);
        Interface inf = this.getInterfaceByPort(port, context);
        this.encodeAdministrativeState(asnObj, port, inf, context);
        this.encodeOpertionState(asnObj, port, inf, context);
        this.encodePoFDN(asnObj, port, context);
    }

    private Interface getInterfaceByPort(Port port, IAsnTranslationContext context) {
        List pairs;
        Object portToInerfacePairs = context.getProperty("portToInerfacePairs");
        if (null != portToInerfacePairs && !CollectionUtils.isEmpty((Collection)(pairs = (List)portToInerfacePairs))) {
            for (Pair mo : pairs) {
                if (!(mo instanceof Pair)) continue;
                Pair moPair = mo;
                Port tmpPort = (Port)moPair.getKey();
                if (!ObjectUtils.nullSafeEquals((Object)port.getDevID(), (Object)tmpPort.getDevID()) || !ObjectUtils.nullSafeEquals((Object)port.getName(), (Object)tmpPort.getName())) continue;
                return (Interface)moPair.getValue();
            }
        }
        return null;
    }

    private void encodePortLabel(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.portLabel = new byte[0];
    }

    private void encodePortSpeed(QAsnPortInfo asnObj, Pair<Port, Interface> moPair, IAsnTranslationContext context) {
        Interface inf = (Interface)moPair.getValue();
        asnObj.poSpeed = null == inf || inf.getIfOperSpeed() == null ? "".getBytes() : String.valueOf(inf.getIfOperSpeed()).getBytes();
    }

    private void encodeType(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        if (null != port && null != port.getPortType()) {
            asnObj.type = this.intValue(port.getPortType(), -1);
        }
    }

    private void encodeUserLabel(QAsnPortInfo asnObj, Port port, IAsnTranslationContext context) {
        asnObj.userLabel = this.getBytes(port.getMemo());
    }

    private int getPTNPortLevel(Interface ifm) {
        if (null == ifm) {
            return 0;
        }
        if (null == ifm.getIfName() || ifm.getIfName().isEmpty()) {
            return 0;
        }
        int level = 0;
        if (null == IFNAME_PORTTYPE_MAPPING) {
            IFNAME_PORTTYPE_MAPPING = new HashMap<Pattern, Integer>();
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^Cpos+|^Pos+"), 6401);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VC4+"), 4865);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^VC12+"), 4097);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(100GE)([0-9/]+)$"), 16392);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(40GE)([0-9/]+)$"), 16391);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(10GE)([0-9/]+)$"), 16389);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(GE|GigabitEthernet)([0-9/]+)$"), 16388);
            IFNAME_PORTTYPE_MAPPING.put(Pattern.compile("^(Ethernet)([0-9/]+)$"), 16387);
        }
        level = QAsnPortInfoTranslator.getPortLevelFromIfName(ifm.getIfName());
        return level;
    }
}

