/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;

public class QAsnPortIndexTranslator
extends AbstractAsnTranslator<QAsnPortIndex, Port> {
    public void decode(QAsnPortIndex asn, Port mo, IAsnTranslationContext context) throws VMFException {
        Port portIndex = mo;
        portIndex.setDevID(Integer.valueOf(asn.neID));
        boolean continueDecode = true;
        continueDecode = this.decodeChassisID(portIndex, asn);
        if (!continueDecode) {
            return;
        }
        continueDecode = this.decodeSlotID(portIndex, asn);
        if (!continueDecode) {
            return;
        }
        continueDecode = this.decodeSubSlotID(portIndex, asn);
        if (!continueDecode) {
            return;
        }
        this.decodePortID(portIndex, asn);
        portIndex.setName(StringUtil.globalString((byte[])asn.cliname));
    }

    public void encode(Port mo, QAsnPortIndex asn, IAsnTranslationContext context) throws VMFException {
    }

    public Class<QAsnPortIndex> getAsnClass() {
        return QAsnPortIndex.class;
    }

    public Class<Port> getMoClass() {
        return Port.class;
    }

    public int getPortNum(int portID) {
        int portNum = portID & 0xFFFF;
        return portNum;
    }

    private boolean decodeChassisID(Port port, QAsnPortIndex asnPortIndex) {
        if (null == asnPortIndex.shelfID) {
            return true;
        }
        int chassisID = this.intValue(asnPortIndex.shelfID, -1);
        if (Integer.MAX_VALUE == chassisID) {
            Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
            if (null != invUtilExtPoint) {
                chassisID = 1;
                port.setChassisID(Integer.valueOf(chassisID));
                return true;
            }
            return false;
        }
        if (chassisID >= 0) {
            port.setChassisID(Integer.valueOf(chassisID));
        }
        return true;
    }

    private boolean decodePortID(Port port, QAsnPortIndex asnPortIndex) {
        int portID = asnPortIndex.portID;
        if (Integer.MAX_VALUE == portID) {
            return false;
        }
        if (portID >= 0) {
            port.setParentRelPosition(Integer.valueOf(this.getPortNum(portID)));
        }
        return true;
    }

    private boolean decodeSlotID(Port port, QAsnPortIndex asnPortIndex) {
        int slotID = asnPortIndex.slotID;
        if (Integer.MAX_VALUE == slotID) {
            return false;
        }
        if (slotID >= 0) {
            Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
            if (null != invUtilExtPoint && Integer.MAX_VALUE == asnPortIndex.shelfID && Integer.MAX_VALUE == asnPortIndex.portID && slotID == 0) {
                return true;
            }
            port.setSlotID(Integer.valueOf(slotID));
        }
        return true;
    }

    private boolean decodeSubSlotID(Port port, QAsnPortIndex asnPortIndex) {
        Object invUtilExtPoint;
        if (null == asnPortIndex.subSlotID && null == (invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class))) {
            return true;
        }
        int subSlotID = this.intValue(asnPortIndex.subSlotID, -1);
        if (Integer.MAX_VALUE == subSlotID) {
            return false;
        }
        if (subSlotID >= 0) {
            port.setSubSlotID(Integer.valueOf(subSlotID));
        } else {
            Object invUtilExtPoint2 = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
            if (null != invUtilExtPoint2) {
                if (Integer.MAX_VALUE == asnPortIndex.portID) {
                    return true;
                }
                port.setSubSlotID(Integer.valueOf(subSlotID));
            }
        }
        return true;
    }
}

