/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnPortBoardRes;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.PortUniResIDParser;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.extendpoint.inventory.task.IQueryEthPortResTaskExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnPortTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import net.commustru.fstru.FStruct;

public class QAsnPortBoardResTranslator
extends AbstractQAsnPortTranslator<QAsnPortBoardRes, Object> {
    public void decode(QAsnPortBoardRes asn, Object mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Object mo, QAsnPortBoardRes asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.setDefaultAsnValue((FStruct)asn);
        QAsnPortBoardRes asnObj = asn;
        if (mo instanceof Pair) {
            Pair moPair = (Pair)mo;
            Port port = (Port)moPair.getKey();
            this.encodePortInfo(asnObj, port);
        } else if (mo instanceof Port) {
            this.encodePortInfo(asnObj, (Port)mo);
        } else {
            QAsnPortBoardResTranslator.getLogger().info("mo type is error. moType=" + mo.getClass());
        }
    }

    public Class<QAsnPortBoardRes> getAsnClass() {
        return QAsnPortBoardRes.class;
    }

    public Class<Object> getMoClass() {
        return Object.class;
    }

    private void encodePortIndex(QAsnPortBoardRes asnObj, Port port) {
        if (null == asnObj.portIndex) {
            asnObj.portIndex = new QAsnUniResID();
        }
        asnObj.portIndex.neID = port.getDevID();
        PortUniResIDParser portParse = new PortUniResIDParser(port.getDevID().intValue(), port.getChassisID().intValue(), port.getSlotID().intValue(), port.getSubSlotID(), port.getParentRelPosition().intValue(), port.getName());
        Object queryEthPortResTaskExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQueryEthPortResTaskExtPoint.class);
        if (null != queryEthPortResTaskExtPoint) {
            portParse.setPortDomain(Integer.valueOf(16));
            portParse.setPortType(null);
            portParse.setCliName(null);
        }
        asnObj.portIndex.strFDN = this.getBytes(portParse.serialize());
        asnObj.portIndex.strMOC = "PP".getBytes();
    }

    private void encodePortInfo(QAsnPortBoardRes asnObj, Port port) {
        this.encodePortIndex(asnObj, port);
        asnObj.slotID = port.getSlotID();
        asnObj.portID = port.getParentRelPosition();
        asnObj.portName = this.getBytes(port.getName());
        asnObj.usePolicy = 0;
    }
}

