/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_link_ne.QAsnPortAvaiBandInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TeLink;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnPortTranslator;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QAsnPortAvaiBandInfoTranslator
extends AbstractQAsnPortTranslator<QAsnPortAvaiBandInfo, Object> {
    private InterfaceFdnParser ifmFdnParser = new InterfaceFdnParser();

    public void decode(QAsnPortAvaiBandInfo asn, Object mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Object mo, QAsnPortAvaiBandInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.setDefaultAsnValue((FStruct)asn);
        QAsnPortAvaiBandInfo asnObj = asn;
        if (mo instanceof Pair) {
            Pair moPair = (Pair)mo;
            Port port = (Port)moPair.getKey();
            port.addKeyRefMo((VmfMO)moPair.getValue());
            this.encodePortInfo(asnObj, port, context);
            this.encodeAvaiBandwidth(asnObj, port, context);
        } else if (mo instanceof Port) {
            this.encodePortInfo(asnObj, (Port)mo, context);
            this.encodeAvaiBandwidth(asnObj, (Port)mo, context);
        } else {
            QAsnPortAvaiBandInfoTranslator.getLogger().info("mo type is error. moType=" + mo.getClass());
        }
    }

    private void encodePortInfo(QAsnPortAvaiBandInfo asnObj, Port port, IAsnTranslationContext context) {
        List ifmLst = port.getKeyRefMos(Interface.class);
        if (!CollectionUtils.isEmpty((Collection)ifmLst)) {
            asnObj.portIndex = this.ifmFdnParser.getUniResID((VmfMO)ifmLst.iterator().next());
        } else {
            Interface ifm = new Interface();
            ifm.setDevID(port.getDevID());
            ifm.setVrID(port.getVrID());
            ifm.setIfName(port.getName());
            asnObj.portIndex = this.ifmFdnParser.getUniResID((VmfMO)ifm);
        }
    }

    private void encodeAvaiBandwidth(QAsnPortAvaiBandInfo asnObj, Port port, IAsnTranslationContext context) {
        Long width;
        List teLst = port.getKeyRefMos(TeLink.class);
        if (!CollectionUtils.isEmpty((Collection)teLst) && null != (width = ((TeLink)teLst.iterator().next()).getTeIfBc0bandwidth())) {
            try {
                asnObj.avaiBandwidth = ((TeLink)teLst.iterator().next()).getTeIfBc0bandwidth().intValue();
            }
            catch (Exception e) {
                QAsnPortAvaiBandInfoTranslator.getLogger().error("encodeAvaiBandwidth fail !" + e);
            }
        }
    }

    public Class<QAsnPortAvaiBandInfo> getAsnClass() {
        return QAsnPortAvaiBandInfo.class;
    }

    public Class<Object> getMoClass() {
        return Object.class;
    }
}

