/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnStrList;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNESlotInfo;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotInfo;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotInfoTemplate;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.Holder;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Arrays;

public class QAsnNESlotInfoTranslator
extends AbstractAsnTranslator<QAsnNESlotInfo, Pair<Holder, Card>> {
    public static final Integer OCCUPY_STATE = 1;
    public static final Integer UNOCCUPY_STATE = 0;

    public void decode(QAsnNESlotInfo asn, Pair<Holder, Card> mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Pair<Holder, Card> mo, QAsnNESlotInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Pair<Holder, Card> moPair = mo;
        QAsnNESlotInfo neSlotAsn = asn;
        neSlotAsn.neID = ((Holder)moPair.getKey()).getDevID();
        neSlotAsn.shelfID = ((Holder)moPair.getKey()).getChassisID();
        QAsnSlotInfo slotAsn = new QAsnSlotInfo();
        this.encode(moPair, slotAsn, context);
        neSlotAsn.slotInfoList.add((Object)slotAsn);
    }

    public Class<QAsnNESlotInfo> getAsnClass() {
        return QAsnNESlotInfo.class;
    }

    @Deprecated
    public Class<Pair<Holder, Card>> getMoClass() {
        return null;
    }

    protected void encode(Pair<Holder, Card> moPair, QAsnSlotInfo asn, IAsnTranslationContext context) throws VMFException {
        this.encodeSlotID(asn, (Holder)moPair.getKey(), context);
        this.encodeSubSlotID(asn, (Holder)moPair.getKey(), context);
        this.encodeNePhysicCP(asn, (Card)moPair.getValue(), context);
        this.encodeNmInstallCP(asn, (Card)moPair.getValue(), context);
        this.encodeOccupyState(asn, (Card)moPair.getValue(), context);
        Object ptnPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != ptnPoint) {
            this.encodeAcceptableEqtList(asn, (Holder)moPair.getKey(), context);
        }
        this.encodeUserLabel(asn, (Holder)moPair.getKey(), context);
    }

    private void encodeAcceptableEqtList(QAsnSlotInfo asnObj, Holder holder, IAsnTranslationContext context) {
        if (holder instanceof Slot) {
            if (null == asnObj.acceptableEqtList) {
                asnObj.acceptableEqtList = new QAsnStrList();
            }
            if (1 <= asnObj.slotID && asnObj.slotID <= 32) {
                byte[][] typeList = new byte[][]{this.getBytes("TNT1EX12(1200229377)"), this.getBytes("VPICTNT1EX12(1500229450)"), this.getBytes("TNT1EG24(1200229378)"), this.getBytes("VPICTNT1EG24(1500229451)"), this.getBytes("TNT1EXL2(1200229379)"), this.getBytes("VPICTNT1EXL2(1500229452)"), this.getBytes("TNT1EH1(1200229380)"), this.getBytes("VPICTNT1EH1(1500229453)"), this.getBytes("TNT1XCS(1200229381)"), this.getBytes("TNT1EX8(1200229382)"), this.getBytes("VPICTNT1EX8(1500229454)"), this.getBytes("TNT1CH1(1200229383)"), this.getBytes("VPICTNT1CH1(1500229455)"), this.getBytes("TNT1CQ4(1200229384)"), this.getBytes("VPICTNT1CQ4(1500229456)")};
                ArrayList typelist = new ArrayList(Arrays.asList(typeList));
                asnObj.acceptableEqtList.addAll(typelist);
            } else if (70 == asnObj.slotID || asnObj.slotID == 78) {
                asnObj.acceptableEqtList.add((Object)this.getBytes("TNT1SCA(1200229376)"));
            } else if (90 <= asnObj.slotID && asnObj.slotID <= 93) {
                asnObj.acceptableEqtList.add((Object)this.getBytes("TNT1FAN(1200229385)"));
            } else if (105 == asnObj.slotID) {
                asnObj.acceptableEqtList.add((Object)this.getBytes("TNT1EFI(1200229387)"));
            } else if (100 <= asnObj.slotID && asnObj.slotID <= 104 || 106 <= asnObj.slotID && asnObj.slotID <= 110) {
                asnObj.acceptableEqtList.add((Object)this.getBytes("TNT1PIU(1200229386)"));
            } else {
                asnObj.acceptableEqtList = null;
                QAsnNESlotInfoTranslator.getLogger().debug("encodeAcceptableEqtList  slot is noexist :" + asnObj.slotID);
            }
        }
    }

    private void encodeNePhysicCP(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (null != card && (null == context || null == context.getTemplate() || null != ((QAsnSlotInfoTemplate)context.getTemplate()).nePhysicCP)) {
            asnObj.nePhysicCP = this.getBytes(this.getCardTypeInfo(card));
        }
    }

    private void encodeNmInstallCP(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (null != card && (null == context || null == context.getTemplate() || null != ((QAsnSlotInfoTemplate)context.getTemplate()).nmInstallCP)) {
            asnObj.nmInstallCP = this.getBytes(this.getCardTypeInfo(card));
        }
    }

    private void encodeOccupyState(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnSlotInfoTemplate)context.getTemplate()).occupyState) {
            asnObj.occupyState = null == card ? UNOCCUPY_STATE : OCCUPY_STATE;
        }
    }

    private void encodeSlotID(QAsnSlotInfo asnObj, Holder holder, IAsnTranslationContext context) {
        if (holder instanceof Slot) {
            asnObj.slotID = this.intValue(holder.getParentRelPosition(), -1);
        } else if (holder instanceof SubSlot) {
            asnObj.slotID = this.intValue(((SubSlot)holder).getSlotID(), -1);
        }
    }

    private void encodeSubSlotID(QAsnSlotInfo asnObj, Holder holder, IAsnTranslationContext context) {
        if (holder instanceof SubSlot) {
            asnObj.subSlotID = this.intValue(holder.getParentRelPosition(), -1);
        }
    }

    private void encodeUserLabel(QAsnSlotInfo asnObj, Holder holder, IAsnTranslationContext context) {
        asnObj.userLabel = this.getBytes(holder.getUserLabel());
    }

    private String getCardTypeInfo(Card card) {
        if (card instanceof Board) {
            String typeName = InventoryTypeMappingCache.getTypeName(Board.class, ((Board)card).getBoardType() == null ? -1 : ((Board)card).getBoardType());
            return typeName + "(" + ((Board)card).getBoardType() + ")";
        }
        String typeName = InventoryTypeMappingCache.getTypeName(SubCard.class, ((SubCard)card).getSubCardType());
        return typeName + "(" + ((SubCard)card).getSubCardType() + ")";
    }
}

