/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnNESlotInfo;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotInfo;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotInfoTemplate;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;

public class QAsnNESlotInfoForSlotChgRptTranslator
extends AbstractAsnTranslator<QAsnNESlotInfo, Card> {
    public static final Integer OCCUPY_STATE = 1;
    public static final Integer UNOCCUPY_STATE = 0;

    public void decode(QAsnNESlotInfo asn, Card mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Card mo, QAsnNESlotInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Card cardMo = mo;
        QAsnNESlotInfo neSlotAsn = asn;
        neSlotAsn.neID = cardMo.getDevID();
        neSlotAsn.shelfID = cardMo.getChassisID();
        QAsnSlotInfo slotAsn = new QAsnSlotInfo();
        this.encodeSlotInfo(cardMo, slotAsn, context);
        neSlotAsn.slotInfoList.add((Object)slotAsn);
    }

    public Class<QAsnNESlotInfo> getAsnClass() {
        return QAsnNESlotInfo.class;
    }

    @Deprecated
    public Class<Card> getMoClass() {
        return null;
    }

    protected void encodeSlotInfo(Card moPair, QAsnSlotInfo asn, IAsnTranslationContext context) throws VMFException {
        this.encodeSlotID(asn, moPair, context);
        this.encodeSubSlotID(asn, moPair, context);
        this.encodeNePhysicCP(asn, moPair, context);
        this.encodeNmInstallCP(asn, moPair, context);
        this.encodeOccupyState(asn, moPair, context);
        this.encodeUserLabel(asn, moPair, context);
    }

    private void encodeNePhysicCP(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (null != card && (null == context || null == context.getTemplate() || null != ((QAsnSlotInfoTemplate)context.getTemplate()).nePhysicCP)) {
            asnObj.nePhysicCP = this.getBytes(this.getCardTypeInfo(card));
        }
    }

    private void encodeNmInstallCP(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (null != card && (null == context || null == context.getTemplate() || null != ((QAsnSlotInfoTemplate)context.getTemplate()).nmInstallCP)) {
            asnObj.nmInstallCP = this.getBytes(this.getCardTypeInfo(card));
        }
    }

    private void encodeOccupyState(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (null == context || null == context.getTemplate() || null != ((QAsnSlotInfoTemplate)context.getTemplate()).occupyState) {
            asnObj.occupyState = null == card ? UNOCCUPY_STATE : OCCUPY_STATE;
        }
    }

    private void encodeSlotID(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        asnObj.slotID = this.intValue(card.getSlotID(), -1);
    }

    private void encodeSubSlotID(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        if (card instanceof SubCard) {
            asnObj.subSlotID = this.intValue(((SubCard)card).getSubSlotID(), -1);
        }
    }

    private void encodeUserLabel(QAsnSlotInfo asnObj, Card card, IAsnTranslationContext context) {
        asnObj.userLabel = this.getBytes(card.getUserLabel());
    }

    private String getCardTypeInfo(Card card) {
        if (card instanceof Board) {
            String typeName = InventoryTypeMappingCache.getTypeName(Board.class, ((Board)card).getBoardType() == null ? -1 : ((Board)card).getBoardType());
            return typeName + "(" + ((Board)card).getBoardType() + ")";
        }
        String typeName = InventoryTypeMappingCache.getTypeName(SubCard.class, ((SubCard)card).getSubCardType());
        return typeName + "(" + ((SubCard)card).getSubCardType() + ")";
    }
}

