/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_slot.QAsnNESlotID;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class QAsnNESlotIDTranslator
extends AbstractAsnTranslator<QAsnNESlotID, Map<Class<? extends PhyEntity>, List<? extends PhyEntity>>> {
    public void decode(QAsnNESlotID asn, Map<Class<? extends PhyEntity>, List<? extends PhyEntity>> moIndexes, IAsnTranslationContext context) throws VMFException {
        if (null == asn || null == moIndexes) {
            return;
        }
        this.put(moIndexes, Slot.class, this.decodeSlotIndex(asn));
        this.put(moIndexes, SubSlot.class, this.decodeSubSlotIndex(asn));
        this.put(moIndexes, Board.class, this.decodeBoardIndex(asn));
        this.put(moIndexes, SubCard.class, this.decodeSubCardIndex(asn));
    }

    public void encode(Map<Class<? extends PhyEntity>, List<? extends PhyEntity>> mo, QAsnNESlotID asn, IAsnTranslationContext context) throws VMFException {
    }

    public Class<QAsnNESlotID> getAsnClass() {
        return QAsnNESlotID.class;
    }

    @Deprecated
    public Class<Map<Class<? extends PhyEntity>, List<? extends PhyEntity>>> getMoClass() {
        return null;
    }

    protected List<Board> decodeBoardIndex(QAsnNESlotID asn) {
        ArrayList<Board> boardIndexes = new ArrayList<Board>();
        Integer chassisID = this.getChassisID(asn.shelfID);
        if (CollectionUtils.isEmpty((Collection)asn.slotIDList)) {
            Board board = new Board();
            board.setDevID(Integer.valueOf(asn.neID));
            board.setChassisID(chassisID);
            boardIndexes.add(board);
            return boardIndexes;
        }
        for (Object slotID : asn.slotIDList) {
            if (null == slotID) continue;
            Board tmpBoard = new Board();
            tmpBoard.setDevID(Integer.valueOf(asn.neID));
            tmpBoard.setChassisID(chassisID);
            tmpBoard.setSlotID((Integer)slotID);
            boardIndexes.add(tmpBoard);
        }
        return boardIndexes;
    }

    protected List<Slot> decodeSlotIndex(QAsnNESlotID asn) {
        ArrayList<Slot> slotIndexes = new ArrayList<Slot>();
        Integer chassisID = this.getChassisID(asn.shelfID);
        if (CollectionUtils.isEmpty((Collection)asn.slotIDList)) {
            Slot slot = new Slot();
            slot.setDevID(Integer.valueOf(asn.neID));
            slot.setChassisID(chassisID);
            slotIndexes.add(slot);
            return slotIndexes;
        }
        for (Object slotID : asn.slotIDList) {
            if (null == slotID) continue;
            Slot tmpSlot = new Slot();
            tmpSlot.setDevID(Integer.valueOf(asn.neID));
            tmpSlot.setChassisID(chassisID);
            tmpSlot.setParentRelPosition((Integer)slotID);
            slotIndexes.add(tmpSlot);
        }
        return slotIndexes;
    }

    protected List<SubCard> decodeSubCardIndex(QAsnNESlotID asn) {
        ArrayList<SubCard> subCardIndexes = new ArrayList<SubCard>();
        Integer chassisID = this.getChassisID(asn.shelfID);
        if (CollectionUtils.isEmpty((Collection)asn.slotIDList)) {
            SubCard subCard = new SubCard();
            subCard.setDevID(Integer.valueOf(asn.neID));
            subCard.setChassisID(chassisID);
            subCardIndexes.add(subCard);
            return subCardIndexes;
        }
        for (Object slotID : asn.slotIDList) {
            if (null == slotID) continue;
            SubCard tmpSubCard = new SubCard();
            tmpSubCard.setDevID(Integer.valueOf(asn.neID));
            tmpSubCard.setChassisID(chassisID);
            tmpSubCard.setSlotID((Integer)slotID);
            subCardIndexes.add(tmpSubCard);
        }
        return subCardIndexes;
    }

    protected List<SubSlot> decodeSubSlotIndex(QAsnNESlotID asn) {
        ArrayList<SubSlot> subSlotIndexes = new ArrayList<SubSlot>();
        Integer chassisID = this.getChassisID(asn.shelfID);
        if (CollectionUtils.isEmpty((Collection)asn.slotIDList)) {
            SubSlot subSlot = new SubSlot();
            subSlot.setDevID(Integer.valueOf(asn.neID));
            subSlot.setChassisID(chassisID);
            subSlotIndexes.add(subSlot);
            return subSlotIndexes;
        }
        for (Object slotID : asn.slotIDList) {
            if (null == slotID) continue;
            SubSlot tmpSubSlot = new SubSlot();
            tmpSubSlot.setDevID(Integer.valueOf(asn.neID));
            tmpSubSlot.setChassisID(chassisID);
            tmpSubSlot.setSlotID((Integer)slotID);
            subSlotIndexes.add(tmpSubSlot);
        }
        return subSlotIndexes;
    }

    protected void put(Map<Class<? extends PhyEntity>, List<? extends PhyEntity>> map, Class<? extends PhyEntity> key, List<? extends PhyEntity> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        List<? extends PhyEntity> list = map.get(key);
        if (null == list) {
            list = new ArrayList<PhyEntity>();
            map.put(key, list);
        }
        list.addAll(values);
    }

    private Integer getChassisID(Integer chassisID) {
        if (null == chassisID || Integer.MAX_VALUE == chassisID || chassisID < 0) {
            return null;
        }
        return chassisID;
    }
}

