/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_projectalm.QAsnImportObjInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.projectobj.model.ProjectObj;
import net.commustru.fstru.FStruct;

public class QAsnImportObjInfoTranslator
extends AbstractAsnTranslator<QAsnImportObjInfo, ProjectObj> {
    public void decode(QAsnImportObjInfo asn, ProjectObj mo, IAsnTranslationContext context) throws VMFException {
        mo.setDevIP(this.strValue(asn.neIP));
        mo.setDevName(this.strValue(asn.neName));
        mo.setPoCardDesc(this.strValue(asn.poCardDesc));
        mo.setPortName(this.strValue(asn.poPortName));
    }

    public void encode(ProjectObj mo, QAsnImportObjInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        this.setDefaultAsnValue((FStruct)asn);
        QAsnImportObjInfo asnImpObjInfo = asn;
        ProjectObj proObj = mo;
        this.encodeFdn(asnImpObjInfo, proObj);
        this.encodeDevName(asnImpObjInfo, proObj);
        this.encodeDevIP(asnImpObjInfo, proObj);
        this.encodeCardDesc(asnImpObjInfo, proObj);
        this.encodePortName(asnImpObjInfo, proObj);
    }

    public Class<QAsnImportObjInfo> getAsnClass() {
        return QAsnImportObjInfo.class;
    }

    public Class<ProjectObj> getMoClass() {
        return ProjectObj.class;
    }

    private void encodeCardDesc(QAsnImportObjInfo asninfo, ProjectObj proObj) {
        asninfo.poCardDesc = StringUtil.globalByte((String)proObj.getPoCardDesc());
    }

    private void encodeDevIP(QAsnImportObjInfo asninfo, ProjectObj proObj) {
        asninfo.neIP = StringUtil.globalByte((String)proObj.getDevIP());
    }

    private void encodeDevName(QAsnImportObjInfo asninfo, ProjectObj proObj) {
        asninfo.neName = StringUtil.globalByte((String)proObj.getDevName());
    }

    private void encodeFdn(QAsnImportObjInfo asninfo, ProjectObj proObj) {
        asninfo.fdn = StringUtil.globalByte((String)proObj.getObjIndexFdn());
    }

    private void encodePortName(QAsnImportObjInfo asninfo, ProjectObj proObj) {
        asninfo.poPortName = StringUtil.globalByte((String)proObj.getPortName());
    }
}

