/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPState;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnCPTranslator;

public class QAsnCPStateTranslator
extends AbstractQAsnCPTranslator<QAsnCPState, Card> {
    private static final int OPERSTATE_OS_DISABLED = 2;
    private static final int WORKSTATE_NOTSUPPORT = 2;

    public void decode(QAsnCPState asn, Card mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Card mo, QAsnCPState asn, IAsnTranslationContext context) throws VMFException {
        Card card = mo;
        QAsnCPState asnObj = asn;
        this.encodeAdminStatus(card, asnObj);
        this.encodeOperStatus(card, asnObj);
        asnObj.cpIndex = this.encodeIndex(card);
    }

    public void encodeAdministrativeState(Card card, QAsnCPState asn, IAsnTranslationContext ctx) {
        asn.workState = 2;
    }

    public void encodeOperState(Card card, QAsnCPState asn, IAsnTranslationContext ctx) {
        asn.workState = card.getOperStatus() == null ? 2 : this.intValue(card.getOperStatus(), -1);
    }

    public void encodeWorkState(Card card, QAsnCPState asn, IAsnTranslationContext ctx) {
        asn.workState = card.getStandbyStatus() == null ? 2 : this.intValue(card.getStandbyStatus(), -1);
    }

    public Class<QAsnCPState> getAsnClass() {
        return QAsnCPState.class;
    }

    @Deprecated
    public Class<Card> getMoClass() {
        return Card.class;
    }

    private void encodeAdminStatus(Card card, QAsnCPState asnObj) {
        asnObj.administrativeState = 2;
    }

    private void encodeOperStatus(Card card, QAsnCPState asnObj) {
        asnObj.operState = this.intValue(card.getOperStatus(), -1);
        asnObj.workState = this.intValue(card.getOperStatus(), -1);
    }
}

