/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnNameAndValueString;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfoTemplate;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.inventory.translation.asn.IQAsnCPInfoTranslatorExtPoint;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.exception.AsnTransformException;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractQAsnCPTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;

public class QAsnCPInfoTranslator
extends AbstractQAsnCPTranslator<QAsnCPInfo, Card> {
    public void decode(QAsnCPInfo asn, Card mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Card mo, QAsnCPInfo asn, IAsnTranslationContext context) throws VMFException {
        QAsnCPInfo asnObj = asn;
        Card mappingMo = mo;
        this.encodeCpIndex(mappingMo, asnObj, context);
        this.encodeType(mappingMo, asnObj);
        this.encodeName(mappingMo, asnObj, context);
        this.encodeMemo(mappingMo, asnObj, context);
        this.encodeUserLabel(mappingMo, asnObj, context);
        this.encodeOwner(mappingMo, asnObj, context);
        Object cpInfoTranslatorExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IQAsnCPInfoTranslatorExtPoint.class);
        if (null != cpInfoTranslatorExtPoint) {
            if (null == asn.exAttribList) {
                asn.exAttribList = new QAsnNVSList();
            }
            QAsnNameAndValueString type = new QAsnNameAndValueString();
            type.name = "CPFuncType".getBytes();
            String typeName = this.getCardTypeName(mo);
            type.value = null != typeName ? typeName.getBytes() : "".getBytes();
            asn.exAttribList.add((Object)type);
            QAsnNameAndValueString proType = new QAsnNameAndValueString();
            type.name = "CPProtectionType".getBytes();
            String protectType = ((IQAsnCPInfoTranslatorExtPoint)cpInfoTranslatorExtPoint).getProtectionType(mo);
            type.value = null != protectType ? protectType.getBytes() : "".getBytes();
            asn.exAttribList.add((Object)type);
        }
    }

    public void encodeCpIndex(Card card, QAsnCPInfo asnObj, IAsnTranslationContext context) throws AsnTransformException {
        asnObj.cpIndex = this.encodeIndex(card);
    }

    public void encodeMemo(Card card, QAsnCPInfo asnObj, IAsnTranslationContext context) throws AsnTransformException {
        if (null == context.getTemplate() || null != ((QAsnCPInfoTemplate)context.getTemplate()).memo) {
            asnObj.memo = this.getBytes(card.getMemo());
        }
    }

    public void encodeName(Card card, QAsnCPInfo asnObj, IAsnTranslationContext context) {
        Object invUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != invUtilExtPoint && null == context.getProperty("QQueryCPInfoTask")) {
            asnObj.name = null == context.getTemplate() || null != ((QAsnCPInfoTemplate)context.getTemplate()).name ? this.getBytes(card.getVendorType()) : new byte[0];
            return;
        }
        asnObj.name = null == context.getTemplate() || null != ((QAsnCPInfoTemplate)context.getTemplate()).name ? this.getBytes(card.getName()) : new byte[0];
    }

    public void encodeOwner(Card card, QAsnCPInfo asnObj, IAsnTranslationContext context) throws AsnTransformException {
        if (null == context.getTemplate() || null != ((QAsnCPInfoTemplate)context.getTemplate()).owner) {
            asnObj.owner = this.getBytes(card.getOwner());
        }
    }

    public void encodeUserLabel(Card card, QAsnCPInfo asnObj, IAsnTranslationContext context) throws AsnTransformException {
        if (null == context.getTemplate() || null != ((QAsnCPInfoTemplate)context.getTemplate()).userLabel) {
            asnObj.userLabel = this.getBytes(card.getUserLabel());
        }
    }

    public Class<QAsnCPInfo> getAsnClass() {
        return QAsnCPInfo.class;
    }

    @Deprecated
    public Class<Card> getMoClass() {
        return Card.class;
    }

    private void encodeType(Card mo, QAsnCPInfo asnObj) {
        asnObj.type = this.intValue(this.getCardTypeID(mo), -1);
    }
}

