/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import java.util.List;

public class QAsnCPIndexTranslator
extends AbstractAsnTranslator<QAsnCPIndex, List<Card>> {
    public void decode(QAsnCPIndex asn, List<Card> mo, IAsnTranslationContext context) throws VMFException {
        Board tmpCard = null;
        tmpCard = this.decodeBoardIndex(asn);
        if (null != tmpCard) {
            mo.add((Card)tmpCard);
        }
        if (null != (tmpCard = this.decodeSubCardIndex(asn))) {
            mo.add((Card)tmpCard);
        }
    }

    public void encode(List<Card> mo, QAsnCPIndex asn, IAsnTranslationContext context) throws VMFException {
    }

    public Class<QAsnCPIndex> getAsnClass() {
        return QAsnCPIndex.class;
    }

    @Deprecated
    public Class<List<Card>> getMoClass() {
        return null;
    }

    private Board decodeBoardIndex(QAsnCPIndex asn) {
        Board boardIndex = new Board();
        boardIndex.setDevID(Integer.valueOf(asn.neID));
        if (!this.decodeChassisID((Card)boardIndex, asn)) {
            return boardIndex;
        }
        if (!this.decodeSlotID((Card)boardIndex, asn)) {
            return boardIndex;
        }
        if (null == asn.subSlotID || asn.subSlotID < 0) {
            return boardIndex;
        }
        return null;
    }

    private boolean decodeChassisID(Card cardIndex, QAsnCPIndex asnPortIndex) {
        Integer chassisID = asnPortIndex.shelfID;
        if (null == chassisID || Integer.MAX_VALUE == chassisID || chassisID < 0) {
            return false;
        }
        cardIndex.setChassisID(chassisID);
        return true;
    }

    private boolean decodeSlotID(Card cardIndex, QAsnCPIndex asnPortIndex) {
        int slotID = asnPortIndex.slotID;
        if (Integer.MAX_VALUE == slotID || slotID < 0) {
            return false;
        }
        cardIndex.setSlotID(Integer.valueOf(slotID));
        return true;
    }

    private SubCard decodeSubCardIndex(QAsnCPIndex asn) {
        SubCard subCardIndex = new SubCard();
        subCardIndex.setDevID(Integer.valueOf(asn.neID));
        if (!this.decodeChassisID((Card)subCardIndex, asn)) {
            return subCardIndex;
        }
        if (!this.decodeSlotID((Card)subCardIndex, asn)) {
            return subCardIndex;
        }
        if (null == asn.subSlotID || asn.subSlotID < 0) {
            return null;
        }
        if (Integer.MAX_VALUE != asn.subSlotID) {
            subCardIndex.setSubSlotID(asn.subSlotID);
        }
        return subCardIndex;
    }
}

