/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;

public class QAsnCPIndex2PortTranslator
extends AbstractAsnTranslator<QAsnCPIndex, Port> {
    public void decode(QAsnCPIndex asn, Port mo, IAsnTranslationContext context) throws VMFException {
        Port portIndex = mo;
        portIndex.setDevID(Integer.valueOf(asn.neID));
        if (!this.decodeChassisID(portIndex, asn)) {
            return;
        }
        if (!this.decodeSlotID(portIndex, asn)) {
            return;
        }
        this.decodeSubSlotID(portIndex, asn);
    }

    public void encode(Port mo, QAsnCPIndex asn, IAsnTranslationContext context) throws VMFException {
    }

    public Class<QAsnCPIndex> getAsnClass() {
        return QAsnCPIndex.class;
    }

    public Class<Port> getMoClass() {
        return Port.class;
    }

    private boolean decodeChassisID(Port portIndex, QAsnCPIndex asnPortIndex) {
        Integer chassisID = asnPortIndex.shelfID;
        if (null == chassisID || Integer.MAX_VALUE == chassisID || chassisID < 0) {
            return false;
        }
        portIndex.setChassisID(chassisID);
        return true;
    }

    private boolean decodeSlotID(Port portIndex, QAsnCPIndex asnPortIndex) {
        int slotID = asnPortIndex.slotID;
        if (Integer.MAX_VALUE == slotID || slotID < 0) {
            return false;
        }
        portIndex.setSlotID(Integer.valueOf(slotID));
        return true;
    }

    private void decodeSubSlotID(Port portIndex, QAsnCPIndex asnPortIndex) {
        Integer subSlotID = asnPortIndex.subSlotID;
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint ? null == subSlotID || Integer.MAX_VALUE == subSlotID : null == subSlotID || subSlotID < 0 || Integer.MAX_VALUE == subSlotID) {
            return;
        }
        portIndex.setSubSlotID(subSlotID);
    }
}

