/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import java.math.BigInteger;

public class FInventoryAsnPortInfoTranslator
extends AbstractAsnTranslator<AsnEmlEntityInvResInfo, Port> {
    public void decode(AsnEmlEntityInvResInfo asn, Port mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Port mo, AsnEmlEntityInvResInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Object devName = context.getProperty("devTypeName");
        Port port = mo;
        AsnEmlEntityInvResInfo oEntityResInfo = asn;
        oEntityResInfo.strDevName = null == devName ? "--".getBytes() : ((String)devName).getBytes();
        this.fillHardVersion(port, oEntityResInfo);
        this.fillPortFdn(port, oEntityResInfo);
        this.fillPortName(port, oEntityResInfo);
        this.fillPortNum(port, oEntityResInfo);
        this.fillPortStatus(port, oEntityResInfo);
        this.fillPortTypeName(port, oEntityResInfo);
        this.fillSerialNo(port, oEntityResInfo);
        this.fillSoftVersion(port, oEntityResInfo);
        this.fillSubSlotNum(port, oEntityResInfo);
        this.fillPortMemo(port, oEntityResInfo);
        this.fillMediumType(port, oEntityResInfo);
        this.fillOpticalIsequipped(port, oEntityResInfo);
        this.fillTransferMode(port, oEntityResInfo);
    }

    public Class<AsnEmlEntityInvResInfo> getAsnClass() {
        return AsnEmlEntityInvResInfo.class;
    }

    public Class<Port> getMoClass() {
        return Port.class;
    }

    private void fillHardVersion(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        String hardVersion = port.getHardwareVersion();
        oEntityResInfo.strHardVersion = null == hardVersion ? "".getBytes() : hardVersion.getBytes();
    }

    private void fillMediumType(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iMediumType = port.getMediumType() == null ? BigInteger.valueOf(0L) : BigInteger.valueOf(port.getMediumType().intValue());
    }

    private void fillOpticalIsequipped(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iOpticalIsEquipped = port.getOpticalIsEquipped() == null ? BigInteger.valueOf(0L) : BigInteger.valueOf(port.getOpticalIsEquipped().intValue());
    }

    private void fillPortFdn(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iDevID = BigInteger.valueOf(port.getDevID().intValue());
        oEntityResInfo.iFrameNum = BigInteger.valueOf(port.getChassisID().intValue());
        oEntityResInfo.iSlotNum = BigInteger.valueOf(port.getSlotID().intValue());
    }

    private void fillPortMemo(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        if (port != null && port.getMemo() != null) {
            oEntityResInfo.strDescr = port.getMemo().getBytes();
        }
    }

    private void fillPortName(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        String portName = port.getName();
        if (null != portName) {
            oEntityResInfo.strDescr = portName.getBytes();
        }
    }

    private void fillPortNum(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iPortNum = BigInteger.valueOf(port.getParentRelPosition().intValue());
    }

    private void fillPortStatus(Port port, AsnEmlEntityInvResInfo oEntityResInfo) throws VMFException {
        oEntityResInfo.iAdminStatus = BigInteger.valueOf(port.getAdminStatus().intValue());
        oEntityResInfo.iOperStatus = BigInteger.valueOf(this.switchOperStatus(port));
    }

    private void fillPortTypeName(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        String portTypeName = InventoryTypeMappingCache.getTypeName(Port.class, port.getPortType());
        if (null != portTypeName) {
            oEntityResInfo.strTypeName = portTypeName.getBytes();
        }
    }

    private void fillSerialNo(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        String serialNo = port.getHardwareVersion();
        oEntityResInfo.strSerialNo = null == serialNo ? "".getBytes() : serialNo.getBytes();
    }

    private void fillSoftVersion(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        String softVersion = port.getSoftwareVersion();
        oEntityResInfo.strSoftVersion = null == softVersion ? "".getBytes() : softVersion.getBytes();
    }

    private void fillSubSlotNum(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iSubSlotNum = BigInteger.valueOf(port.getSubSlotID().intValue());
    }

    private void fillTransferMode(Port port, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iTransferMode = port.getOptTransMode() == null ? BigInteger.valueOf(Port.OPT_TRANS_MODE_ENUM.UNKNOWN.intValue()) : BigInteger.valueOf(port.getOptTransMode().intValue());
    }

    private int switchOperStatus(Port port) throws VMFException {
        if (2 == port.getOperStatus()) {
            port.setOperStatus(Integer.valueOf(19));
        } else if (3 == port.getOperStatus()) {
            port.setOperStatus(Integer.valueOf(20));
        }
        return port.getOperStatus();
    }
}

