/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.uflight.platformadapter.DevSNMPPara;
import com.huawei.uflight.platformadapter.EncapImapUtil;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.FrameUniResIDParser;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevSysInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.inventory.Activator;
import com.swimap.imap.common.asn1.common.AsnEmsIfCreateDevReq;
import com.swimap.imap.common.asn1.common.AsnEmsIfCreateDevReqSeqOf;
import com.swimap.imap.common.asn1.common.AsnEmsIfCreateNodeReq;
import com.swimap.imap.common.asn1.common.AsnEmsIfGetNodeByDevIDAck;
import com.swimap.imap.common.asn1.common.AsnEmsIfGetNodeByDevIDReq;
import com.swimap.imap.common.asn1.common.AsnMapIfUpdateNodeReq;
import com.swimap.imap.common.asn1.common.AsnNodeAttr;
import com.swimap.imap.common.asn1.common.AsnNodeTab;
import com.swimap.imap.common.asn1.common.AsnSnmpPara;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FInventoryAsnHelper {
    public static final String BACKUP_FRAME_ICON = "image/iconM/6_1319";
    public static final int BACKUP_FRAME_TYPE = 2;
    public static final String MAIN_FRAME_ICON = "image/iconM/4_1319.gif";
    public static final Pattern MAIN_FRAME_PATTERN = Pattern.compile("TSR_CLUSTER CCC frame");
    public static final int MAIN_FRAME_TYPE = 2;
    public static final String SWITCH_FRAME_ICON = "image/iconM/5_1319.gif";
    public static final int SWITCH_FRAME_TYPE = 2;
    private static IDeviceService devService;
    private static final Logger logger;

    public static AsnSnmpPara devSNMPParaToAsn(DevSNMPPara snmp) {
        AsnSnmpPara asn = new AsnSnmpPara();
        asn.iPort = BigInteger.valueOf(snmp.getIPortNum());
        asn.iVersion.value = BigInteger.valueOf(snmp.getIVersion());
        asn.iRetries = BigInteger.valueOf(snmp.getUsRetries());
        asn.iTimeout = BigInteger.valueOf(snmp.getUsTimeout());
        asn.iStatusPollInterval = BigInteger.valueOf(snmp.getIStatPollInterval());
        asn.iConfPollInterval = BigInteger.valueOf(snmp.getIConfPollInterval());
        asn.iMaxRepeat = BigInteger.valueOf(snmp.getUsMaxRepeatCnt());
        asn.iMinRepeat = BigInteger.valueOf(snmp.getUsNonRepeatCnt());
        asn.iUseGetBulk.value = BigInteger.valueOf(snmp.getUsGetBulkFlag());
        asn.iPrivProto = BigInteger.valueOf(snmp.getUsPrivProto());
        asn.szPrivPwd = snmp.getStrPrivPwd().getBytes();
        asn.iAuthProto = BigInteger.valueOf(snmp.getUsAuthProtocal());
        asn.szAuthPwd = snmp.getStrAuthPwd().getBytes();
        asn.szContextID = snmp.getStrContextID().getBytes();
        asn.szContextName = snmp.getStrContextName().getBytes();
        asn.szDevstrUserName = snmp.getStrUserName().getBytes();
        asn.szGetCommunity = snmp.getStrGetCommunity().getBytes();
        asn.szSetCommunity = snmp.getStrSetCommunity().getBytes();
        if (null != snmp.getStrLocation()) {
            asn.szLocation = snmp.getStrLocation().getBytes();
        }
        return asn;
    }

    public static AsnEmsIfCreateDevReq getAddFrameAsn(int devID, Collection<Chassis> chassiss) throws VMFException {
        if (chassiss == null || chassiss.isEmpty()) {
            return null;
        }
        devService = Activator.getDeviceService();
        DevSysInfo devInfo = devService.getDevSysInfo(devID);
        String nodeName = devInfo.getDevName();
        ArrayList<Integer> devIDs = new ArrayList<Integer>();
        devIDs.add(devID);
        List snmps = EncapImapUtil.getDevSNMPPara(devIDs);
        AsnEmsIfCreateDevReq asn = new AsnEmsIfCreateDevReq();
        asn.iUserID = BigInteger.ZERO;
        asn.iDevID = BigInteger.valueOf(devID);
        asn.iDevTypeID = BigInteger.valueOf(devInfo.getDevTypeID().intValue());
        asn.iDevVersionID = BigInteger.valueOf(devInfo.getDevVersionID().intValue());
        asn.strDevSysOID = devInfo.getDevSysOID().getBytes();
        asn.strDevIPAddr = devInfo.getDevIP().getBytes();
        asn.strDevMACAddr = devInfo.getDevMac() != null ? devInfo.getDevMac().getBytes() : "".getBytes();
        asn.strDevName = nodeName.getBytes();
        asn.strDevSubnetMask = "0.0.0.0".getBytes();
        asn.oSnmp = FInventoryAsnHelper.devSNMPParaToAsn((DevSNMPPara)snmps.get(0));
        asn.strDevDetailVersion = devInfo.getDevProductVersion().getBytes();
        asn.aNodeList = new AsnEmsIfCreateDevReqSeqOf();
        for (Chassis chassis : chassiss) {
            AsnEmsIfCreateNodeReq node = FInventoryAsnHelper.getFrameNode(chassis, devInfo);
            asn.aNodeList.add((Object)node);
        }
        return asn;
    }

    public static String getFrameFDN(Chassis chassis) {
        FrameUniResIDParser parser = new FrameUniResIDParser(chassis.getDevID().intValue(), chassis.getParentRelPosition().intValue());
        return parser.serialize();
    }

    public static AsnEmsIfCreateNodeReq getFrameNode(Chassis chassis, DevSysInfo devInfo) {
        int devID = chassis.getDevID();
        AsnEmsIfCreateNodeReq node = new AsnEmsIfCreateNodeReq();
        node.iDevID = BigInteger.valueOf(devID);
        node.strParentSubmapID = String.valueOf(devID).getBytes();
        node.strDevIPAddr = devInfo.getDevIP().getBytes();
        String nodeTypeID = null;
        String strnodetype = null;
        if (chassis.getSvcType() == 0) {
            if (null == chassis.getStandbyStatus() || chassis.getStandbyStatus() == 0) {
                nodeTypeID = String.format("%d_%d_%d", 2, devInfo.getDevTypeID(), 2);
                strnodetype = String.format("3:%d:%d:%s", devInfo.getDevTypeID(), 2, nodeTypeID);
            } else {
                nodeTypeID = String.format("%d_%d_%d", 2, devInfo.getDevTypeID(), 2);
                strnodetype = String.format("3:%d:%d:%s", devInfo.getDevTypeID(), 2, nodeTypeID);
            }
        } else {
            nodeTypeID = String.format("%d_%d_%d", 2, devInfo.getDevTypeID(), 2);
            strnodetype = String.format("3:%d:%d:%s", devInfo.getDevTypeID(), 2, nodeTypeID);
        }
        node.strNodeType = strnodetype.getBytes();
        node.iPosX = BigInteger.ZERO;
        node.iPosY = BigInteger.ZERO;
        node.strSymbolType = nodeTypeID.getBytes();
        node.oResIDList.resDN = FInventoryAsnHelper.getFrameFDN(chassis).getBytes();
        node.strLabel = chassis.getName() != null ? chassis.getName().getBytes() : "".getBytes();
        node.iHwDevFlag = BigInteger.valueOf(2011L);
        node.strComment = "".getBytes();
        return node;
    }

    public static AsnEmsIfGetNodeByDevIDReq getQueryNodesAsn(int devID) {
        AsnEmsIfGetNodeByDevIDReq asn = new AsnEmsIfGetNodeByDevIDReq();
        asn.aDevIDSet.add((Object)BigInteger.valueOf(devID));
        return asn;
    }

    public static AsnMapIfUpdateNodeReq getUpdateNodeIcon(AsnEmsIfGetNodeByDevIDAck ack) {
        AsnMapIfUpdateNodeReq asn = new AsnMapIfUpdateNodeReq();
        asn.iUserID = BigInteger.ZERO;
        for (AsnNodeTab tab : ack.oNodeTabSet) {
            String nodeType = new String(tab.strNodeType);
            int isFrame = -1;
            if (nodeType.contains("1319_4")) {
                isFrame = 0;
            } else if (nodeType.contains("1319_5")) {
                isFrame = 1;
            } else if (nodeType.contains("1319_6")) {
                isFrame = 2;
            }
            if (isFrame < 0) continue;
            AsnNodeAttr attr = new AsnNodeAttr();
            attr.strParentSubmapID = tab.strParentSubmapID;
            attr.strNodeID = tab.strNodeID;
            if (isFrame == 0) {
                attr.strSymbolType = MAIN_FRAME_ICON.getBytes();
            } else if (isFrame == 1) {
                attr.strSymbolType = SWITCH_FRAME_ICON.getBytes();
            } else if (isFrame == 2) {
                attr.strSymbolType = BACKUP_FRAME_ICON.getBytes();
            } else {
                logger.error("unknown frame type.");
            }
            asn.oNodeSet.add((Object)attr);
        }
        return asn;
    }

    static {
        logger = LoggerFactory.getLogger(FInventoryAsnHelper.class);
    }
}

