/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Chassis;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;
import com.huawei.vmf.adapter.inventory.translation.asn.PhyEntityAsnTranslationContextWithRuModule;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import java.math.BigInteger;

public class FInventoryAsnFrameInfoTranslator
extends AbstractAsnTranslator<AsnEmlEntityInvResInfo, Chassis> {
    public void decode(AsnEmlEntityInvResInfo asn, Chassis mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Chassis mo, AsnEmlEntityInvResInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Object devName = context.getProperty("devTypeName");
        Chassis chassis = mo;
        AsnEmlEntityInvResInfo oEntityResInfo = asn;
        oEntityResInfo.strDevName = null == devName ? "--".getBytes() : ((String)devName).getBytes();
        this.fillFdn(chassis, oEntityResInfo);
        this.fillFrameName(chassis, oEntityResInfo);
        this.fillFrameStatus(chassis, oEntityResInfo);
        this.fillFrameType(chassis, oEntityResInfo);
        this.fillHardVersion(chassis, oEntityResInfo);
        this.fillSoftVersion(chassis, oEntityResInfo);
        this.fillSerialNo(chassis, oEntityResInfo, context instanceof PhyEntityAsnTranslationContextWithRuModule ? (PhyEntityAsnTranslationContextWithRuModule)context : null);
    }

    public Class<AsnEmlEntityInvResInfo> getAsnClass() {
        return AsnEmlEntityInvResInfo.class;
    }

    public Class<Chassis> getMoClass() {
        return Chassis.class;
    }

    private void fillFdn(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iDevID = BigInteger.valueOf(chassis.getDevID().intValue());
        oEntityResInfo.iFrameNum = BigInteger.valueOf(chassis.getParentRelPosition().intValue());
        oEntityResInfo.iPortNum = BigInteger.ZERO;
        oEntityResInfo.iSlotNum = BigInteger.ZERO;
        oEntityResInfo.iSubSlotNum = BigInteger.ZERO;
    }

    private void fillFrameName(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo) {
        String frameName = chassis.getName();
        if (null != frameName) {
            oEntityResInfo.strDescr = frameName.getBytes();
        }
    }

    private void fillFrameStatus(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo) {
        Integer admStatus = 1;
        Integer operStatus = chassis.getOperStatus();
        oEntityResInfo.iAdminStatus = null == admStatus ? BigInteger.ZERO : BigInteger.valueOf(admStatus.intValue());
        oEntityResInfo.iOperStatus = null == operStatus ? BigInteger.ZERO : BigInteger.valueOf(operStatus.intValue());
    }

    private void fillFrameType(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo) {
        String chassisTypeName = InventoryTypeMappingCache.getTypeName(Chassis.class, chassis.getChassisType());
        if (null != chassisTypeName) {
            oEntityResInfo.strTypeName = chassisTypeName.getBytes();
        }
    }

    private void fillHardVersion(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo) {
        String hardVersion = chassis.getHardwareVersion();
        oEntityResInfo.strHardVersion = null == hardVersion ? "".getBytes() : hardVersion.getBytes();
    }

    private void fillSerialNo(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo, PhyEntityAsnTranslationContextWithRuModule context) {
        RuModuleInfo ruModuleInfo = null;
        if (context != null) {
            ruModuleInfo = context.getCardRuModel((PhyEntity)chassis);
        }
        oEntityResInfo.strSerialNo = null == ruModuleInfo ? "".getBytes() : ruModuleInfo.getSerialNo().getBytes();
    }

    private void fillSoftVersion(Chassis chassis, AsnEmlEntityInvResInfo oEntityResInfo) {
        String softVersion = chassis.getSoftwareVersion();
        if (null != softVersion) {
            oEntityResInfo.strSoftVersion = softVersion.getBytes();
        }
    }
}

