/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import java.math.BigInteger;

public class FInventoryAsnCardInfoTranslator
extends AbstractAsnTranslator<AsnEmlEntityInvResInfo, Card> {
    public void decode(AsnEmlEntityInvResInfo asn, Card mo, IAsnTranslationContext context) throws VMFException {
    }

    public void encode(Card mo, AsnEmlEntityInvResInfo asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        Object devName = context.getProperty("devTypeName");
        Card card = mo;
        AsnEmlEntityInvResInfo oEntityResInfo = asn;
        oEntityResInfo.strDevName = null == devName ? "--".getBytes() : ((String)devName).getBytes();
        this.fillBoardFdn(card, oEntityResInfo);
        this.fillBoardName(card, oEntityResInfo);
        this.fillBoardStatus(card, oEntityResInfo);
        this.fillBoardTypeName(card, oEntityResInfo);
        this.fillHardVersion(card, oEntityResInfo);
        this.fillPortNum(card, oEntityResInfo);
        this.fillSerialNo(card, oEntityResInfo);
        this.fillSoftVersion(card, oEntityResInfo);
        this.fillSubSlotNum(card, oEntityResInfo);
    }

    public Class<AsnEmlEntityInvResInfo> getAsnClass() {
        return AsnEmlEntityInvResInfo.class;
    }

    @Deprecated
    public Class<Card> getMoClass() {
        return Card.class;
    }

    private void fillBoardFdn(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iDevID = BigInteger.valueOf(card.getDevID().intValue());
        oEntityResInfo.iFrameNum = BigInteger.valueOf(card.getChassisID().intValue());
        oEntityResInfo.iSlotNum = BigInteger.valueOf(card.getSlotID().intValue());
    }

    private void fillBoardName(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        String boardName = card.getName();
        if (null != boardName) {
            oEntityResInfo.strDescr = boardName.getBytes();
        }
    }

    private void fillBoardStatus(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iAdminStatus = BigInteger.valueOf(1L);
        oEntityResInfo.iOperStatus = BigInteger.valueOf(card.getOperStatus().intValue());
    }

    private void fillBoardTypeName(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        String cardTypeName = card instanceof Board ? InventoryTypeMappingCache.getTypeName(Board.class, ((Board)card).getBoardType()) : InventoryTypeMappingCache.getTypeName(SubCard.class, ((SubCard)card).getSubCardType());
        if (null != cardTypeName) {
            oEntityResInfo.strTypeName = cardTypeName.getBytes();
        }
    }

    private void fillHardVersion(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        String hardVersion = card.getHardwareVersion();
        oEntityResInfo.strHardVersion = null == hardVersion ? "".getBytes() : hardVersion.getBytes();
    }

    private void fillPortNum(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iPortNum = BigInteger.ZERO;
    }

    private void fillSerialNo(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        String serialNo = card.getHardwareVersion();
        oEntityResInfo.strSerialNo = null == serialNo ? "".getBytes() : serialNo.getBytes();
    }

    private void fillSoftVersion(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        String softVersion = card.getSoftwareVersion();
        oEntityResInfo.strSoftVersion = null == softVersion ? "".getBytes() : softVersion.getBytes();
    }

    private void fillSubSlotNum(Card card, AsnEmlEntityInvResInfo oEntityResInfo) {
        oEntityResInfo.iSubSlotNum = card instanceof Board ? BigInteger.ZERO : BigInteger.valueOf(((SubCard)card).getSubSlotID().intValue());
    }
}

