/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Holder;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractAsnResReqPhyEntityTranslator;
import com.swimap.imap.common.asn1.common.AsnResourceReq;

public class AsnResReqHolderTranslator
extends AbstractAsnResReqPhyEntityTranslator<AsnResourceReq, Holder> {
    public void encode(Holder mo, AsnResourceReq asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        AsnResourceReq resAsnObj = asn;
        if (mo instanceof SubSlot) {
            this.encodeSubSlot((SubSlot)mo, resAsnObj);
        } else {
            this.encodeSlot((Slot)mo, resAsnObj);
        }
    }

    public Class<AsnResourceReq> getAsnClass() {
        return AsnResourceReq.class;
    }

    @Deprecated
    public Class<Holder> getMoClass() {
        return Holder.class;
    }

    private void encodeFdn(Holder holder, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(217, holder.getFdn(), resAsnObj);
    }

    private void encodeIndex(Slot slot, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(218, String.valueOf(slot.getEntIndex()), resAsnObj);
    }

    private void encodeParentRelPosition(Holder holder, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(218, String.valueOf(holder.getParentRelPosition()), resAsnObj);
    }

    private void encodeSlot(Slot slot, AsnResourceReq resAsnObj) {
        SlotUniResIDParser parser = new SlotUniResIDParser(this.intValue(slot.getDevID(), -1), this.intValue(slot.getChassisID(), -1), this.intValue(slot.getParentRelPosition(), -1));
        String fdn = parser.serialize();
        this.initResReq(resAsnObj, fdn, 9, this.intValue(slot.getEntIndex(), -1), slot.getDescription());
        slot.setFdn(fdn);
        this.encodeFdn((Holder)slot, resAsnObj);
        this.encodeIndex(slot, resAsnObj);
    }

    private void encodeSubSlot(SubSlot subSlot, AsnResourceReq resAsnObj) {
        SlotUniResIDParser parser = new SlotUniResIDParser(subSlot.getDevID().intValue(), subSlot.getChassisID().intValue(), subSlot.getSlotID().intValue(), subSlot.getBoardID(), subSlot.getParentRelPosition());
        String fdn = parser.serialize();
        this.initResReq(resAsnObj, fdn, 5, subSlot.getParentRelPosition(), subSlot.getDescription());
        subSlot.setFdn(fdn);
        this.encodeFdn((Holder)subSlot, resAsnObj);
        this.encodeParentRelPosition((Holder)subSlot, resAsnObj);
    }
}

