/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.fdn.SlotUniResIDParser;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.translation.asn.AbstractAsnResReqPhyEntityTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.PhyEntityAsnTranslationContextWithRuModule;
import com.swimap.imap.common.asn1.common.AsnResourceReq;

public class AsnResReqCardTranslator
extends AbstractAsnResReqPhyEntityTranslator<AsnResourceReq, Card> {
    public void encode(Card mo, AsnResourceReq asn, IAsnTranslationContext context) throws VMFException {
        if (null == mo || null == asn) {
            return;
        }
        AsnResourceReq resAsnObj = asn;
        if (mo instanceof Board) {
            this.encodeBoard(mo, resAsnObj, context);
        } else {
            this.encodeSubCard((SubCard)mo, resAsnObj, context);
        }
    }

    public Class<AsnResourceReq> getAsnClass() {
        return AsnResourceReq.class;
    }

    @Deprecated
    public Class<Card> getMoClass() {
        return Card.class;
    }

    private void encodeAdminStatus(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(104, String.valueOf(2), resAsnObj);
    }

    private void encodeBoard(Card card, AsnResourceReq resAsnObj, IAsnTranslationContext context) {
        try {
            SlotUniResIDParser parser = new SlotUniResIDParser();
            parser.setDevID(this.intValue(card.getDevID(), -1));
            parser.setFrameID(this.intValue(card.getChassisID(), -1));
            parser.setSlotID(this.intValue(card.getSlotID(), -1));
            String fdn = parser.serialize();
            this.initResReq(resAsnObj, fdn, 4, this.intValue(this.getCardTypeID(card), -1), card.getDescription());
            card.setFdn(fdn);
            this.encodeSoftwareVersion(card, resAsnObj);
            this.encodeFirmwareVersion(card, resAsnObj);
            this.encodeFdn(card, resAsnObj);
            this.encodeCardType(card, resAsnObj);
            this.encodeStandbyStatus(card, resAsnObj);
            this.encodeIndex(card, resAsnObj);
            this.encodeSerialNum(card, resAsnObj, context instanceof PhyEntityAsnTranslationContextWithRuModule ? (PhyEntityAsnTranslationContextWithRuModule)context : null);
        }
        catch (Exception e) {
            AsnResReqCardTranslator.getLogger().error("encode board failed.", (Throwable)e);
        }
    }

    private void encodeCardType(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(215, String.valueOf(this.getCardTypeID(card)), resAsnObj);
    }

    private void encodeFdn(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(217, card.getFdn(), resAsnObj);
    }

    private void encodeFirmwareVersion(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(211, card.getFirmwareVersion(), resAsnObj);
    }

    private void encodeIndex(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(218, String.valueOf(card.getEntIndex()), resAsnObj);
    }

    private void encodeSerialNum(Card card, AsnResourceReq resAsnObj, PhyEntityAsnTranslationContextWithRuModule context) {
        if (null == context) {
            AsnResReqCardTranslator.getLogger().debug("Card ruModule doesn't exist:[board={}], context is null", (Object)card);
            return;
        }
        RuModuleInfo ruModuleInfo = context.getCardRuModel((PhyEntity)card);
        if (ruModuleInfo != null) {
            this.setTopoResAttr(213, ruModuleInfo.getSerialNum(), resAsnObj);
        } else {
            AsnResReqCardTranslator.getLogger().debug("Card ruModule doesn't exist:[board={}]", (Object)card);
        }
    }

    private void encodeSoftwareVersion(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(210, card.getSoftwareVersion(), resAsnObj);
    }

    private void encodeStandbyStatus(Card card, AsnResourceReq resAsnObj) {
        this.setTopoResAttr(216, String.valueOf(card.getStandbyStatus()), resAsnObj);
    }

    private void encodeSubCard(SubCard subCard, AsnResourceReq resAsnObj, IAsnTranslationContext context) {
        SlotUniResIDParser parser = new SlotUniResIDParser();
        parser.setDevID(this.intValue(subCard.getDevID(), -1));
        parser.setFrameID(this.intValue(subCard.getChassisID(), -1));
        parser.setSlotID(this.intValue(subCard.getSlotID(), -1));
        parser.setCardID(Integer.valueOf(this.intValue(subCard.getParentRelPosition(), -1)));
        parser.setSubSlotID(subCard.getSubSlotID());
        String fdn = parser.serialize();
        this.initResReq(resAsnObj, fdn, 5, this.getCardTypeID((Card)subCard), subCard.getDescription());
        subCard.setFdn(fdn);
        this.encodeAdminStatus((Card)subCard, resAsnObj);
        this.encodeSoftwareVersion((Card)subCard, resAsnObj);
        this.encodeFirmwareVersion((Card)subCard, resAsnObj);
        this.encodeFdn((Card)subCard, resAsnObj);
        this.encodeIndex((Card)subCard, resAsnObj);
        if (context instanceof PhyEntityAsnTranslationContextWithRuModule) {
            this.encodeSerialNum((Card)subCard, resAsnObj, (PhyEntityAsnTranslationContextWithRuModule)context);
        }
    }

    private int getCardTypeID(Card card) {
        if (card instanceof Board) {
            Integer boardType = ((Board)card).getBoardType();
            return null == boardType ? 37000 : boardType;
        }
        Integer subCardType = ((SubCard)card).getSubCardType();
        return null == subCardType ? 38000 : subCardType;
    }
}

