/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.translation.asn;

import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.cache.InventoryTypeMappingCache;
import net.commustru.fstru.FStruct;

public abstract class AbstractQAsnCPTranslator<AsnType extends FStruct, MOType>
extends AbstractAsnTranslator<AsnType, MOType> {
    protected QAsnCPIndex encodeIndex(Card mo) {
        QAsnCPIndex index = new QAsnCPIndex();
        index.oneID = 0;
        this.encodeDevID(mo, index);
        this.encodeChassisID(mo, index);
        this.encodeSlotID(mo, index);
        this.encodeSubSlotID(mo, index);
        return index;
    }

    protected int getCardTypeID(Card card) {
        Integer cardTypeID = -1;
        cardTypeID = card instanceof Board ? Integer.valueOf(null == (cardTypeID = ((Board)card).getBoardType()) ? 37000 : cardTypeID) : Integer.valueOf(null == (cardTypeID = ((SubCard)card).getSubCardType()) ? 38000 : cardTypeID);
        return cardTypeID;
    }

    protected String getCardTypeName(Card card) {
        if (card instanceof Board) {
            Integer boardType = ((Board)card).getBoardType();
            boardType = null == boardType ? 37000 : boardType;
            return InventoryTypeMappingCache.getTypeName(Board.class, boardType);
        }
        Integer subCardType = ((SubCard)card).getSubCardType();
        subCardType = null == subCardType ? 38000 : subCardType;
        return InventoryTypeMappingCache.getTypeName(SubCard.class, subCardType);
    }

    private Board decodeBoardIndex(QAsnCPIndex asn) {
        Board boardIndex = new Board();
        boardIndex.setDevID(Integer.valueOf(asn.neID));
        if (!this.decodeChassisID((Card)boardIndex, asn)) {
            return boardIndex;
        }
        if (!this.decodeSlotID((Card)boardIndex, asn)) {
            return boardIndex;
        }
        return null == asn.subSlotID || asn.subSlotID < 0 ? boardIndex : null;
    }

    private boolean decodeChassisID(Card cardIndex, QAsnCPIndex asnPortIndex) {
        Integer chassisID = asnPortIndex.shelfID;
        if (null == chassisID || Integer.MAX_VALUE == chassisID || chassisID < 0) {
            return false;
        }
        cardIndex.setChassisID(chassisID);
        return true;
    }

    private boolean decodeSlotID(Card cardIndex, QAsnCPIndex asnPortIndex) {
        int slotID = asnPortIndex.slotID;
        if (Integer.MAX_VALUE == slotID || slotID < 0) {
            return false;
        }
        cardIndex.setSlotID(Integer.valueOf(slotID));
        return true;
    }

    private SubCard decodeSubCardIndex(QAsnCPIndex asn) {
        SubCard subCardIndex = new SubCard();
        subCardIndex.setDevID(Integer.valueOf(asn.neID));
        if (!this.decodeChassisID((Card)subCardIndex, asn)) {
            return subCardIndex;
        }
        if (!this.decodeSlotID((Card)subCardIndex, asn)) {
            return subCardIndex;
        }
        if (null == asn.subSlotID || asn.subSlotID < 0) {
            return null;
        }
        if (Integer.MAX_VALUE != asn.subSlotID) {
            subCardIndex.setSubSlotID(asn.subSlotID);
        }
        return subCardIndex;
    }

    private void encodeChassisID(Card mo, QAsnCPIndex index) {
        if (null != mo.getChassisID()) {
            index.shelfID = mo.getChassisID();
        }
    }

    private void encodeDevID(Card mo, QAsnCPIndex index) {
        if (null != mo.getDevID()) {
            index.neID = mo.getDevID();
        }
    }

    private void encodeSlotID(Card mo, QAsnCPIndex index) {
        if (null != mo.getSlotID()) {
            index.slotID = mo.getSlotID();
        }
    }

    private void encodeSubSlotID(Card mo, QAsnCPIndex index) {
        if (mo instanceof SubCard && null != ((SubCard)mo).getSubSlotID()) {
            index.subSlotID = ((SubCard)mo).getSubSlotID();
        }
    }
}

