/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNESlotContent;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSetSlotsInfoReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnSlotContent;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Slot;
import com.huawei.vmf.adapter.fservice.inventory.model.SubSlot;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class QSetSlotsInfoTask
extends AbstractConfigQTask<QAsnSetSlotsInfoReq, QAsnErrInfoReturn> {
    public QSetSlotsInfoTask() {
        super(EOperationType.MODIFY);
        super.addMoCompositeService(Slot.class, (ICompositeService)new DefaultCompositeService(Slot.class));
        super.addMoCompositeService(SubSlot.class, (ICompositeService)new DefaultCompositeService(SubSlot.class));
    }

    public QAsnErrInfo getErrorInfo(int errorCode) {
        QAsnErrInfo err = new QAsnErrInfo();
        err.errCode = errorCode;
        return err;
    }

    public void handleError(QAsnErrInfoReturn rsp, VMFException e) {
        QAsnErrInfo err = this.getErrorInfo(e.getErrorCode());
        this.responseError(rsp, err);
    }

    public void update(Set<? extends PhyEntity> phyEntitylst, Context context) throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(context);
        Class<?> clazz = phyEntitylst.iterator().next().getClass();
        dao.merge(clazz, false);
    }

    protected void decode(QAsnSetSlotsInfoReq req, Task task, IAsnTranslationContext context) {
        String oldValue;
        ArrayList<Slot> moSlotIndexes = new ArrayList<Slot>();
        ArrayList<Slot> moSlotUpdates = new ArrayList<Slot>();
        ArrayList<SubSlot> moSubSlotIndexes = new ArrayList<SubSlot>();
        ArrayList<SubSlot> moSubSlotUpdates = new ArrayList<SubSlot>();
        QAsnNESlotContent oAsnNeSlots = null;
        QAsnSlotContent oAsnSlotinfo = null;
        for (Object asn : req.neSlotContentList) {
            oAsnNeSlots = (QAsnNESlotContent)asn;
            for (Object childAsn : oAsnNeSlots.slotContentList) {
                String strUserLabel;
                oAsnSlotinfo = (QAsnSlotContent)childAsn;
                if (null == oAsnSlotinfo.subSlotID) {
                    Slot slot = new Slot();
                    slot.setDevID(Integer.valueOf(oAsnNeSlots.neID));
                    slot.setSlotID(Integer.valueOf(oAsnSlotinfo.slotID));
                    moSlotIndexes.add(slot);
                    Slot updateSlotData = new Slot();
                    updateSlotData.setDevID(Integer.valueOf(oAsnNeSlots.neID));
                    updateSlotData.setSlotID(Integer.valueOf(oAsnSlotinfo.slotID));
                    strUserLabel = oAsnSlotinfo.userLabel != null ? new String(oAsnSlotinfo.userLabel) : null;
                    updateSlotData.setUserLabel(strUserLabel);
                    moSlotUpdates.add(updateSlotData);
                    continue;
                }
                SubSlot subSlot = new SubSlot();
                subSlot.setDevID(Integer.valueOf(oAsnNeSlots.neID));
                subSlot.setSlotID(Integer.valueOf(oAsnSlotinfo.slotID));
                subSlot.setSubSlotID(oAsnSlotinfo.subSlotID);
                moSubSlotIndexes.add(subSlot);
                SubSlot updateSubSlotData = new SubSlot();
                updateSubSlotData.setDevID(Integer.valueOf(oAsnNeSlots.neID));
                updateSubSlotData.setSlotID(Integer.valueOf(oAsnSlotinfo.slotID));
                updateSubSlotData.setSubSlotID(oAsnSlotinfo.subSlotID);
                strUserLabel = oAsnSlotinfo.userLabel != null ? new String(oAsnSlotinfo.userLabel) : null;
                updateSubSlotData.setUserLabel(strUserLabel);
                moSubSlotUpdates.add(updateSubSlotData);
            }
        }
        if (!CollectionUtils.isEmpty(moSlotIndexes)) {
            Collection<Slot> mos = this.queryMoInfos(moSlotIndexes);
            if (CollectionUtils.isEmpty(mos)) {
                mos = new ArrayList<Slot>();
            }
            block2: for (Slot slot : mos) {
                for (Slot slot2 : moSlotUpdates) {
                    if (slot.getDevID().intValue() != slot2.getDevID().intValue() || slot.getSlotID().intValue() != slot2.getSlotID().intValue()) continue;
                    oldValue = slot.getUserLabel();
                    slot.setUserLabel(slot2.getUserLabel());
                    this.setOperMask(slot, "userLabel", context, oldValue);
                    continue block2;
                }
            }
        }
        if (!CollectionUtils.isEmpty(moSubSlotIndexes)) {
            Collection<SubSlot> subMos = this.querySubMoInfos(moSubSlotIndexes);
            if (CollectionUtils.isEmpty(subMos)) {
                subMos = new ArrayList<SubSlot>();
            }
            block4: for (SubSlot subSlot : subMos) {
                for (SubSlot subSlot2 : moSubSlotUpdates) {
                    if (subSlot.getDevID().intValue() != subSlot2.getDevID().intValue() || subSlot.getSlotID().intValue() != subSlot2.getSlotID().intValue() || subSlot.getSubSlotID().intValue() != subSlot2.getSubSlotID().intValue()) continue;
                    oldValue = subSlot.getUserLabel();
                    subSlot.setUserLabel(subSlot2.getUserLabel());
                    this.setSubOperMask(subSlot, "userLabel", context, oldValue);
                    continue block4;
                }
            }
        }
    }

    protected void encode(QAsnErrInfoReturn rsp, IAsnTranslationContext context) {
        rsp.result = 0;
    }

    protected void executeTask(QAsnSetSlotsInfoReq req, QAsnErrInfoReturn rsp, Task task) {
        IAsnTranslationContext asnTranslatorContext = this.getContext(req);
        this.decode(req, task, asnTranslatorContext);
        Context context = asnTranslatorContext.getTransactionContext();
        try {
            Set subSlots;
            Set slots = context.getChangeRecord(Slot.class).getAllChanges();
            if (!CollectionUtils.isEmpty((Collection)slots)) {
                this.update(slots, context);
            }
            if (!CollectionUtils.isEmpty((Collection)(subSlots = context.getChangeRecord(SubSlot.class).getAllChanges()))) {
                this.update(subSlots, context);
            }
            this.encode(rsp, asnTranslatorContext);
        }
        catch (VMFException e) {
            this.handleError(rsp, e);
        }
    }

    protected Integer getAsnBestEffort(QAsnSetSlotsInfoReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnSetSlotsInfoReq req) {
        return null;
    }

    protected Collection<Slot> queryMoInfos(List<Slot> moIndexes) {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "slotID"};
        try {
            return dao.queryByFields(Slot.class, fieldNames, moIndexes, false);
        }
        catch (VMFException e) {
            this.getLogger().error("queryMoInfos error. error is " + e.getErrorMessage());
            return null;
        }
    }

    protected Collection<SubSlot> querySubMoInfos(List<SubSlot> moIndexes) {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "slotID", "subSlotID"};
        try {
            return dao.queryByFields(SubSlot.class, fieldNames, moIndexes, false);
        }
        catch (VMFException e) {
            this.getLogger().error("queryMoInfos error. error is " + e.getErrorMessage());
            return null;
        }
    }

    private IAsnTranslationContext getContext(QAsnSetSlotsInfoReq req) {
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        asnTranslationContext.setOperType(this.getOperType());
        Context context = new Context();
        asnTranslationContext.setTransactionContext(context);
        this.setBestEffort(context, req);
        context.setTaskFlag(StringUtil.globalString((byte[])this.getAsnTaskFlag(req)));
        return asnTranslationContext;
    }

    private void responseError(QAsnErrInfoReturn rsp, QAsnErrInfo err) {
        if (rsp != null) {
            if (rsp.errList == null) {
                rsp.errList = new QAsnErrInfoList();
            }
            rsp.result = 1107499878;
            rsp.errList.add((Object)err);
        }
    }

    private void setBestEffort(Context context, QAsnSetSlotsInfoReq req) {
        Integer bestEffort = this.getAsnBestEffort(req);
        if (null != bestEffort && bestEffort.equals(1)) {
            context.setBestEffort(true);
        }
    }

    private void setOperMask(Slot mo, String strUserLabel, IAsnTranslationContext context, String oldValue) {
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Slot.class);
        recorder.addModify((Object)mo, new PropertyChangeItem(strUserLabel, (Object)mo.getUserLabel(), (Object)oldValue));
    }

    private void setSubOperMask(SubSlot mo, String strUserLabel, IAsnTranslationContext context, String oldValue) {
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(SubSlot.class);
        recorder.addModify((Object)mo, new PropertyChangeItem(strUserLabel, (Object)mo.getUserLabel(), (Object)oldValue));
    }
}

