/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnPortLoopbackState;
import com.huawei.network.qasn.m_q_ip_pwe3_model.QAsnPortLoopbackStateList;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnSetPortLoopbackStateReq;
import com.huawei.network.qasn.m_q_ip_pwe3_op.QAsnSetPortLoopbackStateRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.ifm.model.StmPort;
import com.huawei.vmf.adapter.fservice.ifm.model.Vc12;
import com.huawei.vmf.adapter.fservice.ifm.model.Vc4;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class QSetPortLoopbackStateTask
extends AbstractConfigQTask<QAsnSetPortLoopbackStateReq, QAsnSetPortLoopbackStateRsp> {
    private InterfaceFdnParser ifmFdnPar = new InterfaceFdnParser();
    private static final int ADMIN_INT = 0;
    private static final String CMD_VC12 = "VC12";
    private static final String CMD_VC4 = "VC4";

    public QSetPortLoopbackStateTask() {
        super(EOperationType.MODIFY);
        super.addMoCompositeService(Port.class, (ICompositeService)new DefaultCompositeService(Port.class));
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            super.addMoCompositeService(StmPort.class, (ICompositeService)new DefaultCompositeService(StmPort.class));
        }
    }

    protected void decode(QAsnSetPortLoopbackStateReq req, Task task, IAsnTranslationContext context) {
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            this.doPTNDispose(req, task, context);
        } else {
            ArrayList<Port> moIndexes = new ArrayList<Port>();
            QAsnPortLoopbackState oAsnPortState = null;
            for (Object asn : req.loopList) {
                Port tmpPortIndex = new Port();
                oAsnPortState = (QAsnPortLoopbackState)asn;
                tmpPortIndex.setDevID(Integer.valueOf(oAsnPortState.portIndex.neID));
                String strIfFDN = new String(oAsnPortState.portIndex.strFDN);
                String strPortName = "";
                int iPos = strIfFDN.lastIndexOf("|");
                if (iPos > 0) {
                    strPortName = strIfFDN.substring(iPos + 1);
                }
                tmpPortIndex.setName(strPortName);
                moIndexes.add(tmpPortIndex);
                Collection<Port> mos = this.queryMoInfos(moIndexes);
                for (Port mo : mos) {
                    mo.setLoopbackMode(oAsnPortState.state);
                    this.setOperMask(mo, "loopbackMode", context);
                }
            }
        }
    }

    private void doPTNDispose(QAsnSetPortLoopbackStateReq req, Task task, IAsnTranslationContext context) {
        for (Object asn : req.loopList) {
            QAsnPortLoopbackState oAsnPortState = (QAsnPortLoopbackState)asn;
            int devID = oAsnPortState.portIndex.neID;
            String strIfFDN = new String(oAsnPortState.portIndex.strFDN);
            Interface ifmIndex = this.ifmFdnPar.getIndexMo(strIfFDN);
            String ifName = ifmIndex.getIfName();
            if (StringUtil.isEmpty((String)ifName)) continue;
            if (0 <= ifName.indexOf(CMD_VC4)) {
                this.doVC4ForPTN(devID, ifName, oAsnPortState.state, context);
                continue;
            }
            if (0 <= ifName.indexOf(CMD_VC12)) {
                this.doVC12ForPTN(devID, ifName, oAsnPortState.state, context);
                continue;
            }
            this.doPortForPTN(devID, ifName, oAsnPortState.state, context);
        }
    }

    private void doVC4ForPTN(int devID, String ifName, int loopMode, IAsnTranslationContext context) {
        ArrayList<Vc4> vc4Indexes = new ArrayList<Vc4>();
        Vc4 tmpPortIndex = new Vc4();
        tmpPortIndex.setDevID(Integer.valueOf(devID));
        tmpPortIndex.setVc4IfName(ifName);
        vc4Indexes.add(tmpPortIndex);
        Collection<Vc4> mos = this.queryVc4MoInfos(vc4Indexes);
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Vc4 mo = mos.iterator().next();
        mo.setVc4LoopMode(Integer.valueOf(loopMode));
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Vc4.class);
        recorder.addModify((Object)mo, new PropertyChangeItem("vc4LoopMode"));
        StmPort stm = new StmPort();
        stm.setDevID(Integer.valueOf(devID));
        stm.setVrID(Integer.valueOf(0));
        stm.setPosition(mo.getPosition());
        ArrayList<Vc4> vc4List = new ArrayList<Vc4>();
        vc4List.add(mo);
        stm.setVc4s(vc4List);
        IMOChangeRecord StmReCorder = context.getTransactionContext().addChangeRecord(StmPort.class);
        StmReCorder.addModify((Object)stm, new PropertyChangeItem("vc4s"));
    }

    protected Collection<Vc4> queryVc4MoInfos(List<Vc4> moIndexes) {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vc4IfName"};
        try {
            return dao.queryByFields(Vc4.class, fieldNames, moIndexes, false);
        }
        catch (VMFException e) {
            this.getLogger().error("queryVc4MoInfos error. error is " + e.getErrorMessage());
            return null;
        }
    }

    private void doVC12ForPTN(int devID, String ifName, int loopMode, IAsnTranslationContext context) {
        ArrayList<Vc12> vc12Indexes = new ArrayList<Vc12>();
        Vc12 tmpPortIndex = new Vc12();
        tmpPortIndex.setDevID(Integer.valueOf(devID));
        tmpPortIndex.setVc4IfName(ifName);
        vc12Indexes.add(tmpPortIndex);
        Collection<Vc12> mos = this.queryVc12MoInfos(vc12Indexes);
        if (CollectionUtils.isEmpty(mos)) {
            return;
        }
        Vc12 mo = mos.iterator().next();
        mo.setVc12LoopMode(Integer.valueOf(loopMode));
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Vc12.class);
        recorder.addModify((Object)mo, new PropertyChangeItem("vc12LoopMode"));
        Vc4 vc4 = new Vc4();
        vc4.setDevID(mo.getDevID());
        vc4.setVrID(mo.getVrID());
        vc4.setPosition(mo.getPosition());
        vc4.setVc4Number(mo.getVc4Number());
        ArrayList<Vc12> vc12List = new ArrayList<Vc12>();
        vc12List.add(mo);
        vc4.setVc12s(vc12List);
        IMOChangeRecord vc4ReCorder = context.getTransactionContext().addChangeRecord(Vc4.class);
        vc4ReCorder.addModify((Object)vc4, new PropertyChangeItem("vc12s"));
        StmPort stm = new StmPort();
        stm.setDevID(Integer.valueOf(devID));
        stm.setVrID(Integer.valueOf(0));
        stm.setPosition(mo.getPosition());
        ArrayList<Vc4> vc4List = new ArrayList<Vc4>();
        vc4List.add(vc4);
        stm.setVc4s(vc4List);
        IMOChangeRecord stmReCorder = context.getTransactionContext().addChangeRecord(StmPort.class);
        stmReCorder.addModify((Object)stm, new PropertyChangeItem("vc4s"));
    }

    protected Collection<Vc12> queryVc12MoInfos(List<Vc12> moIndexes) {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "vc12IfName"};
        try {
            return dao.queryByFields(Vc12.class, fieldNames, moIndexes, false);
        }
        catch (VMFException e) {
            this.getLogger().error("queryVc12MoInfos error. error is " + e.getErrorMessage());
            return null;
        }
    }

    private void doPortForPTN(int devID, String ifName, int loopMode, IAsnTranslationContext context) {
        ArrayList<Port> portIndexes = new ArrayList<Port>();
        Port tmpPortIndex = new Port();
        tmpPortIndex.setDevID(Integer.valueOf(devID));
        tmpPortIndex.setName(ifName);
        portIndexes.add(tmpPortIndex);
        Collection<Port> mos = this.queryMoInfos(portIndexes);
        for (Port mo : mos) {
            mo.setLoopbackMode(Integer.valueOf(loopMode));
            this.setOperMask(mo, "loopbackMode", context);
        }
    }

    protected void encode(QAsnSetPortLoopbackStateRsp rsp, IAsnTranslationContext context) {
        int iRet = 0;
        rsp.result = new QAsnErrInfoReturn();
        rsp.result.result = iRet;
        rsp.loopList = new QAsnPortLoopbackStateList();
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Port.class);
            Set mos = recorder.getAllChanges();
            for (Port mo : mos) {
                iRet = context.getTransactionContext().getMoErrorCode((VmfMO)mo);
                QAsnPortLoopbackState oAsnRsp = new QAsnPortLoopbackState();
                oAsnRsp.lowPath = 0;
                oAsnRsp.highPath = 0;
                oAsnRsp.portIndex = new QAsnUniResID();
                oAsnRsp.portIndex.neID = mo.getDevID();
                Interface ifm = new Interface();
                ifm.setDevID(mo.getDevID());
                ifm.setVrID(mo.getVrID());
                ifm.setIfName(mo.getName());
                String fdn = this.ifmFdnPar.getFdn(ifm);
                if (null == fdn) {
                    fdn = "";
                }
                oAsnRsp.portIndex.strFDN = fdn.getBytes();
                oAsnRsp.portIndex.strMOC = mo.getName().getBytes();
                oAsnRsp.poResult = new QAsnErrInfo();
                oAsnRsp.poResult.errCode = iRet;
                oAsnRsp.poResult.objName = mo.getName().getBytes();
                oAsnRsp.state = mo.getLoopbackMode();
                rsp.loopList.add((Object)oAsnRsp);
            }
            IMOChangeRecord vc4Recorder = context.getTransactionContext().addChangeRecord(Vc4.class);
            Set vc4Mos = vc4Recorder.getAllChanges();
            for (Vc4 mo : vc4Mos) {
                iRet = context.getTransactionContext().getMoErrorCode((VmfMO)mo);
                QAsnPortLoopbackState oAsnRsp = new QAsnPortLoopbackState();
                oAsnRsp.lowPath = 0;
                oAsnRsp.highPath = 0;
                oAsnRsp.portIndex = new QAsnUniResID();
                oAsnRsp.portIndex.neID = mo.getDevID();
                Interface ifm = new Interface();
                ifm.setDevID(mo.getDevID());
                ifm.setVrID(mo.getVrID());
                ifm.setIfName(mo.getVc4IfName());
                String fdn = this.ifmFdnPar.getFdn(ifm);
                if (null == fdn) {
                    fdn = "";
                }
                oAsnRsp.portIndex.strFDN = fdn.getBytes();
                oAsnRsp.portIndex.strMOC = CMD_VC4.getBytes();
                oAsnRsp.poResult = new QAsnErrInfo();
                oAsnRsp.poResult.errCode = iRet;
                oAsnRsp.poResult.objName = mo.getVc4IfName().getBytes();
                oAsnRsp.state = mo.getVc4LoopMode();
                rsp.loopList.add((Object)oAsnRsp);
            }
            IMOChangeRecord vc12Recorder = context.getTransactionContext().addChangeRecord(Vc12.class);
            Set vc12Mos = vc12Recorder.getAllChanges();
            for (Vc12 mo : vc12Mos) {
                iRet = context.getTransactionContext().getMoErrorCode((VmfMO)mo);
                QAsnPortLoopbackState oAsnRsp = new QAsnPortLoopbackState();
                oAsnRsp.lowPath = 0;
                oAsnRsp.highPath = 0;
                oAsnRsp.portIndex = new QAsnUniResID();
                oAsnRsp.portIndex.neID = mo.getDevID();
                Interface ifm = new Interface();
                ifm.setDevID(mo.getDevID());
                ifm.setVrID(mo.getVrID());
                ifm.setIfName(mo.getVc12IfName());
                String fdn = this.ifmFdnPar.getFdn(ifm);
                if (null == fdn) {
                    fdn = "";
                }
                oAsnRsp.portIndex.strFDN = fdn.getBytes();
                oAsnRsp.portIndex.strMOC = CMD_VC12.getBytes();
                oAsnRsp.poResult = new QAsnErrInfo();
                oAsnRsp.poResult.errCode = iRet;
                oAsnRsp.poResult.objName = mo.getVc4IfName().getBytes();
                oAsnRsp.state = mo.getVc12LoopMode();
                rsp.loopList.add((Object)oAsnRsp);
            }
        } else {
            IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Port.class);
            Set mos = recorder.getAllChanges();
            for (Port mo : mos) {
                iRet = context.getTransactionContext().getMoErrorCode((VmfMO)mo);
                QAsnPortLoopbackState oAsnRsp = new QAsnPortLoopbackState();
                oAsnRsp.lowPath = 0;
                oAsnRsp.highPath = 0;
                oAsnRsp.portIndex = new QAsnUniResID();
                oAsnRsp.portIndex.neID = mo.getDevID();
                oAsnRsp.portIndex.strFDN = "".getBytes();
                oAsnRsp.portIndex.strMOC = mo.getName().getBytes();
                oAsnRsp.poResult = new QAsnErrInfo();
                oAsnRsp.poResult.errCode = iRet;
                oAsnRsp.poResult.objName = mo.getName().getBytes();
                oAsnRsp.state = mo.getLoopbackMode();
                rsp.loopList.add((Object)oAsnRsp);
            }
        }
    }

    protected Integer getAsnBestEffort(QAsnSetPortLoopbackStateReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnSetPortLoopbackStateReq req) {
        return null;
    }

    protected Collection<Port> queryMoInfos(List<Port> moIndexes) {
        if (CollectionUtils.isEmpty(moIndexes)) {
            return Collections.emptyList();
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        String[] fieldNames = new String[]{"devID", "name"};
        try {
            return dao.queryByFields(Port.class, fieldNames, moIndexes, false);
        }
        catch (VMFException e) {
            this.getLogger().error("queryMoInfos error. error is " + e.getErrorMessage());
            return null;
        }
    }

    private void setOperMask(Port mo, String strLoopbackMode, IAsnTranslationContext context) {
        IMOChangeRecord recorder = context.getTransactionContext().addChangeRecord(Port.class);
        recorder.addModify((Object)mo, new PropertyChangeItem(strLoopbackMode, null, null));
    }
}

