/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnDevTypeSlotNum;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnStatSlotNumReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnStatSlotNumRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.task.AbstractQQueryTask;
import com.huawei.vmf.adapter.fservice.devicemgr.model.DevTypeInfo;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.dao.HolderDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class QQueryStatSlotNumTask
extends AbstractQQueryTask<QAsnStatSlotNumReq, QAsnStatSlotNumRsp> {
    private IDeviceService deviceService;

    public QQueryStatSlotNumTask() {
        try {
            this.deviceService = Activator.getDeviceService();
        }
        catch (VMFException e) {
            this.getLogger().error("get device service error.", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public Collection<?> queryMoInfo(QAsnStatSlotNumReq req, QAsnStatSlotNumRsp rsp, Task task) throws VMFException {
        HolderDao holderDao = (HolderDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, HolderDao.class);
        LinkedHashMap<String, QAsnDevTypeSlotNum> deviceSlotNums = new LinkedHashMap<String, QAsnDevTypeSlotNum>();
        DevTypeInfo devType = null;
        QAsnDevTypeSlotNum tmpAsnDevTypeSlotNum = null;
        ArrayList<Integer> devIDs = new ArrayList<Integer>(req.objList.size());
        for (Object neID : req.objList) {
            devIDs.add(((BigInteger)neID).intValue());
        }
        Map<Integer, Long> totals = holderDao.queryTotalSlot(devIDs);
        Map<Integer, Long> usings = holderDao.queryUsingSlot(devIDs);
        for (Integer devID : devIDs) {
            devType = this.deviceService.getDevTypeAndVersion(devID.intValue());
            Long totalSlotNum = totals.get(devID);
            Long usingSlotNum = usings.get(devID);
            tmpAsnDevTypeSlotNum = (QAsnDevTypeSlotNum)deviceSlotNums.get(devType.getDevVersionName());
            if (null == tmpAsnDevTypeSlotNum) {
                tmpAsnDevTypeSlotNum = new QAsnDevTypeSlotNum();
                tmpAsnDevTypeSlotNum.devtypeName = StringUtil.globalByte((String)devType.getDevVersionName());
                tmpAsnDevTypeSlotNum.totalSlotNum = totalSlotNum == null ? 0 : totalSlotNum.intValue();
                tmpAsnDevTypeSlotNum.usingSlotNum = usingSlotNum == null ? 0 : usingSlotNum.intValue();
                deviceSlotNums.put(devType.getDevVersionName(), tmpAsnDevTypeSlotNum);
                continue;
            }
            tmpAsnDevTypeSlotNum.totalSlotNum = tmpAsnDevTypeSlotNum.totalSlotNum + (totalSlotNum == null ? 0 : totalSlotNum.intValue());
            tmpAsnDevTypeSlotNum.usingSlotNum = tmpAsnDevTypeSlotNum.usingSlotNum + (usingSlotNum == null ? 0 : usingSlotNum.intValue());
        }
        return deviceSlotNums.values();
    }

    protected void handleErrorResult(VMFException e, QAsnStatSlotNumRsp rsp) {
        rsp.result = -1;
    }

    protected void initRspResult(QAsnStatSlotNumRsp rsp) {
        rsp.result = 0;
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnStatSlotNumRsp rsp) {
        rsp.devtypeslotNumList.addAll(queryAsns);
    }
}

