/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPExInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnPortSFPInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnPortSFPInfoList;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnQueryCPExInfoReq;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnQueryCPExInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.inventory.task.AbstractQQueryMoTypeWithRuModuleTask;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCPIndex2PortTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortSFPInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public class QQuerySfpInfoListInCardTask
extends AbstractQQueryMoTypeWithRuModuleTask<QAsnQueryCPExInfoReq, QAsnQueryCPExInfoRsp, Port> {
    protected QQuerySfpInfoListInCardTask() {
        super((IAsnTranslator)new QAsnPortSFPInfoTranslator());
    }

    @Override
    protected Collection<?> encode(List<Pair<Port, RuModuleInfo>> moPairs, IAsnTranslationContext context) throws VMFException {
        if (CollectionUtils.isEmpty(moPairs)) {
            return Collections.emptyList();
        }
        ArrayList<Pair> destAsns = new ArrayList<Pair>();
        for (Pair<Port, RuModuleInfo> moPair : moPairs) {
            FStruct asn = this.createQueryAsnTypeInstance();
            this.getAsnTranslator().encode(moPair, asn, context);
            destAsns.add(new Pair(moPair.getKey(), (Object)asn));
        }
        return destAsns;
    }

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnPortSFPInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnQueryCPExInfoRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnQueryCPExInfoRsp rsp) {
        this.initRspResult(rsp.result);
    }

    @Override
    protected Collection<?> queryMoInfo(QAsnQueryCPExInfoReq req, QAsnQueryCPExInfoRsp rsp, Task task) throws VMFException {
        String[] fieldNames;
        Collection resIfms;
        ArrayList<Port> moIndexs = new ArrayList<Port>();
        ArrayList<Port> subCardPortIndexs = new ArrayList<Port>();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTemplate((FStruct)req.attrTemplate);
        QAsnCPIndex2PortTranslator qAsnCPIndexTranslator = new QAsnCPIndex2PortTranslator();
        for (Object asn : req.cpIndexList) {
            Port tmpPort = new Port();
            qAsnCPIndexTranslator.decode((FStruct)((QAsnCPIndex)asn), tmpPort, (IAsnTranslationContext)context);
            if (null == tmpPort.getSubSlotID()) {
                moIndexs.add(tmpPort);
                continue;
            }
            subCardPortIndexs.add(tmpPort);
        }
        ArrayList mos = new ArrayList();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        if (!CollectionUtils.isEmpty(moIndexs) && !CollectionUtils.isEmpty((Collection)(resIfms = dao.queryByFields(Port.class, fieldNames = new String[]{"devID", "chassisID", "slotID"}, moIndexs, false)))) {
            mos.addAll(resIfms);
        }
        if (!CollectionUtils.isEmpty(subCardPortIndexs) && !CollectionUtils.isEmpty((Collection)(resIfms = dao.queryByFields(Port.class, fieldNames = new String[]{"devID", "chassisID", "slotID", "subSlotID"}, subCardPortIndexs, false)))) {
            mos.addAll(resIfms);
        }
        HashSet<RuModuleInfo> ruModules = new HashSet<RuModuleInfo>();
        for (Port moType : mos) {
            RuModuleInfo module = new RuModuleInfo();
            module.setDevID(moType.getDevID());
            module.setPhyIndex(moType.getEntIndex());
            ruModules.add(module);
        }
        Collection ruModuleInfos = dao.queryByKey(RuModuleInfo.class, ruModules, false);
        return this.encode(this.genPairs(mos, ruModuleInfos), (IAsnTranslationContext)context);
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnQueryCPExInfoRsp rsp) {
        for (Object queryAsn : queryAsns) {
            QAsnCPExInfo cpExInfo = this.getCard((Pair<Port, QAsnPortSFPInfo>)((Pair)queryAsn), rsp);
            if (null == cpExInfo) continue;
            if (null == cpExInfo.sfpInfoList) {
                cpExInfo.sfpInfoList = new QAsnPortSFPInfoList();
            }
            cpExInfo.sfpInfoList.add(((Pair)queryAsn).getValue());
        }
    }

    private QAsnCPExInfo getCard(Pair<Port, QAsnPortSFPInfo> portInfo, QAsnQueryCPExInfoRsp rsp) {
        if (null == portInfo || CollectionUtils.isEmpty((Collection)rsp.cpExInfoList)) {
            return null;
        }
        for (Object cpExInfo : rsp.cpExInfoList) {
            if (null == cpExInfo || !this.isParentCard((Port)portInfo.getKey(), ((QAsnCPExInfo)cpExInfo).cpIndex)) continue;
            return (QAsnCPExInfo)cpExInfo;
        }
        this.getLogger().info("Can't find parent Board/SubCard. portInfo=" + portInfo);
        return null;
    }

    private boolean isParentCard(Port portIndex, QAsnCPIndex cardIndex) {
        return !(!ObjectUtils.equals((Object)portIndex.getDevID(), (Object)cardIndex.neID) || !ObjectUtils.equals((Object)portIndex.getChassisID(), (Object)cardIndex.shelfID) || !ObjectUtils.equals((Object)portIndex.getSlotID(), (Object)cardIndex.slotID) || !ObjectUtils.equals((Object)portIndex.getSubSlotID(), (Object)cardIndex.subSlotID) && (null != portIndex.getSubSlotID() && portIndex.getSubSlotID() >= 0 || null != cardIndex.subSlotID && cardIndex.subSlotID >= 0));
    }
}

