/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_inventory_port.QAsnGetPortSpecialInfoReq;
import com.huawei.network.qasn.m_q_inventory_port.QAsnGetPortSpecialInfoRsp;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortSpecialInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQQuerySingleMoTypeTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortIndexTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortSpecialInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QQueryPortSpecialInfoTask
extends AbstractQQuerySingleMoTypeTask<QAsnGetPortSpecialInfoReq, QAsnGetPortSpecialInfoRsp, Port> {
    QQueryPortSpecialInfoTask() {
        super((IAsnTranslator)new QAsnPortSpecialInfoTranslator());
    }

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnPortSpecialInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnGetPortSpecialInfoRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnGetPortSpecialInfoRsp rsp) {
        this.initRspResult(rsp.result);
    }

    protected Collection<?> queryMoInfo(QAsnGetPortSpecialInfoReq req, QAsnGetPortSpecialInfoRsp rsp, Task task) throws VMFException {
        ArrayList<Port> moIndexes = new ArrayList<Port>();
        AsnTranslationContext context = new AsnTranslationContext();
        QAsnPortIndexTranslator asnPortIndexTranslator = new QAsnPortIndexTranslator();
        for (Object asn : req.portIndexList) {
            Port tmpPortIndex = new Port();
            asnPortIndexTranslator.decode((FStruct)((QAsnPortIndex)asn), tmpPortIndex, (IAsnTranslationContext)context);
            moIndexes.add(tmpPortIndex);
        }
        Collection mos = this.queryMoInfos(moIndexes);
        if (!CollectionUtils.isEmpty((Collection)mos)) {
            ArrayList<Interface> ifmIndex = new ArrayList<Interface>();
            for (Port port : mos) {
                Interface ifm = new Interface();
                ifm.setDevID(port.getDevID());
                ifm.setVrID(port.getVrID());
                ifm.setIfName(port.getName());
                ifmIndex.add(ifm);
            }
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection ifmMos = dao.queryByKey(Interface.class, ifmIndex, false);
            if (!CollectionUtils.isEmpty((Collection)ifmMos)) {
                block2: for (Port port : mos) {
                    for (Interface ifmMo : ifmMos) {
                        if (port.getDevID().intValue() != ifmMo.getDevID().intValue() || !port.getName().equals(ifmMo.getIfName())) continue;
                        port.addKeyRefMo((VmfMO)ifmMo);
                        continue block2;
                    }
                }
            }
        }
        return this.encode(mos, (IAsnTranslationContext)context);
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnGetPortSpecialInfoRsp rsp) {
        rsp.portInfoList.addAll(queryAsns);
    }
}

