/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_inventory_port.QAsnGetPortInfoReq;
import com.huawei.network.qasn.m_q_inventory_port.QAsnGetPortInfoRsp;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.Pair;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.dao.PortDao;
import com.huawei.vmf.adapter.inventory.task.AbstractQQueryMoTypeWithInterfaceTask;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortIndexTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortInfoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QQueryPortInfoTask
extends AbstractQQueryMoTypeWithInterfaceTask<QAsnGetPortInfoReq, QAsnGetPortInfoRsp, Port> {
    private static final String PORT = "PORT-";

    QQueryPortInfoTask() {
        super((IAsnTranslator)new QAsnPortInfoTranslator());
    }

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnPortInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnGetPortInfoRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnGetPortInfoRsp rsp) {
        this.initRspResult(rsp.result);
    }

    @Override
    protected Collection<?> queryMoInfo(QAsnGetPortInfoReq req, QAsnGetPortInfoRsp rsp, Task task) throws VMFException {
        ArrayList<Port> moIndexes = new ArrayList<Port>();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTemplate((FStruct)req.attrTemplate);
        QAsnPortIndexTranslator asnPortIndexTranslator = new QAsnPortIndexTranslator();
        ArrayList<Port> portList = new ArrayList<Port>();
        for (Object asn : req.portIndexList) {
            if (((QAsnPortIndex)asn).cliname == null) {
                Port tmpPortIndex = new Port();
                asnPortIndexTranslator.decode((FStruct)((QAsnPortIndex)asn), tmpPortIndex, (IAsnTranslationContext)context);
                moIndexes.add(tmpPortIndex);
                continue;
            }
            Port port = new Port();
            port.setName(new String(((QAsnPortIndex)asn).cliname));
            port.setDevID(Integer.valueOf(((QAsnPortIndex)asn).neID));
            portList.add(port);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection mosByName = new ArrayList();
        if (!portList.isEmpty()) {
            mosByName = dao.queryByFields(Port.class, new String[]{"name", "devID"}, portList, false);
        }
        if (!moIndexes.isEmpty()) {
            Collection mosByKey = this.queryMoInfos(moIndexes);
            mosByName.addAll(mosByKey);
        }
        List<Object> motypeWithInterface = this.queryMotypeWithInterface();
        List pairs = this.genPairs(mosByName, motypeWithInterface);
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint && !CollectionUtils.isEmpty(pairs)) {
            for (Pair pair : pairs) {
                if (!(pair instanceof Pair)) continue;
                Pair moPair = pair;
                Port port = (Port)moPair.getKey();
                Interface ifm = (Interface)moPair.getValue();
                String name = PORT + port.getParentRelPosition();
                if (null != ifm && null != ifm.getIfDescr() && !ifm.getIfDescr().isEmpty()) {
                    name = ifm.getIfDescr();
                }
                port.setName(name);
            }
        }
        if (null != pairs) {
            context.addProperty("portToInerfacePairs", pairs);
        }
        return this.encode(pairs, (IAsnTranslationContext)context);
    }

    @Override
    protected List<Object> queryMotypeWithInterface() throws VMFException {
        PortDao dao = (PortDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, PortDao.class);
        return (List)dao.queryPortLstJoinInterface();
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnGetPortInfoRsp rsp) {
        rsp.portInfoList.addAll(queryAsns);
    }
}

