/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnGetCPInfoReq;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnGetCPInfoRsp;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfo;
import com.huawei.network.qasn.m_q_inventory_port.QAsnPortInfoList;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.inventory.util.IInventoryUtilExtPoint;
import com.huawei.vmf.adapter.framework.task.AbstractQQuerySingleMoTypeTask;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCPIndex2PortTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortInfoTranslator;
import com.huawei.vmf.common.extendpoint.ExtendPointServiceMgr;
import java.util.ArrayList;
import java.util.Collection;
import net.commustru.fstru.FStruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;

public class QQueryPortInfoListInCardTask
extends AbstractQQuerySingleMoTypeTask<QAsnGetCPInfoReq, QAsnGetCPInfoRsp, Port> {
    protected QQueryPortInfoListInCardTask() {
        super((IAsnTranslator)new QAsnPortInfoTranslator());
    }

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnPortInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnGetCPInfoRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnGetCPInfoRsp rsp) {
        this.initRspResult(rsp.result);
    }

    protected Collection<?> queryMoInfo(QAsnGetCPInfoReq req, QAsnGetCPInfoRsp rsp, Task task) throws VMFException {
        ArrayList<Port> moIndexs = new ArrayList<Port>();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTemplate((FStruct)req.attrTemplate);
        QAsnCPIndex2PortTranslator qAsnCPIndexTranslator = new QAsnCPIndex2PortTranslator();
        for (Object asn : req.cpIndexList) {
            Port tmpPort = new Port();
            qAsnCPIndexTranslator.decode((FStruct)((QAsnCPIndex)asn), tmpPort, (IAsnTranslationContext)context);
            moIndexs.add(tmpPort);
        }
        Collection mos = this.queryMoInfos(moIndexs);
        return this.encode(mos, (IAsnTranslationContext)context);
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnGetCPInfoRsp rsp) {
        for (Object queryAsn : queryAsns) {
            QAsnCPInfo cpInfo = this.getCard((QAsnPortInfo)queryAsn, rsp);
            if (null == cpInfo) continue;
            if (null == cpInfo.portList) {
                cpInfo.portList = new QAsnPortInfoList();
            }
            cpInfo.portList.add(queryAsn);
        }
    }

    private QAsnCPInfo getCard(QAsnPortInfo portInfo, QAsnGetCPInfoRsp rsp) {
        if (null == portInfo || CollectionUtils.isEmpty((Collection)rsp.cpInfoList)) {
            return null;
        }
        for (Object cpInfo : rsp.cpInfoList) {
            if (null == cpInfo || !this.isParentCard(portInfo.portIndex, ((QAsnCPInfo)cpInfo).cpIndex)) continue;
            return (QAsnCPInfo)cpInfo;
        }
        this.getLogger().info("Can't find parent Board/SubCard. portInfo=" + portInfo);
        return null;
    }

    private boolean isParentCard(QAsnPortIndex portIndex, QAsnCPIndex cardIndex) {
        Object interfaceUtilExtPoint = ExtendPointServiceMgr.getInstance().getExtendPoitService(IInventoryUtilExtPoint.class);
        if (null != interfaceUtilExtPoint) {
            return portIndex.neID == cardIndex.neID && ObjectUtils.equals((Object)portIndex.shelfID, (Object)cardIndex.shelfID) && portIndex.slotID == cardIndex.slotID;
        }
        return !(portIndex.neID != cardIndex.neID || !ObjectUtils.equals((Object)portIndex.shelfID, (Object)cardIndex.shelfID) || portIndex.slotID != cardIndex.slotID || !ObjectUtils.equals((Object)portIndex.subSlotID, (Object)cardIndex.subSlotID) && (null != portIndex.subSlotID && portIndex.subSlotID >= 0 || null != cardIndex.subSlotID && cardIndex.subSlotID >= 0));
    }
}

