/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_inventory_link_ne.QAsnPortAvaiBandInfo;
import com.huawei.network.qasn.m_q_inventory_link_ne.QAsnPortAvaiableBandwidthReq;
import com.huawei.network.qasn.m_q_inventory_link_ne.QAsnPortAvaiableBandwidthRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.mpls.model.TeLink;
import com.huawei.vmf.adapter.inventory.task.AbstractQQueryMoTypeWithInterfaceTask;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnPortAvaiBandInfoTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.springframework.util.CollectionUtils;

public class QQueryPortAvaiableBandwidthTask
extends AbstractQQueryMoTypeWithInterfaceTask<QAsnPortAvaiableBandwidthReq, QAsnPortAvaiableBandwidthRsp, Port> {
    private List<TeLink> teLst = null;
    private List<Interface> ifmLst = null;

    QQueryPortAvaiableBandwidthTask() {
        super((IAsnTranslator)new QAsnPortAvaiBandInfoTranslator());
    }

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnPortAvaiBandInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnPortAvaiableBandwidthRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnPortAvaiableBandwidthRsp rsp) {
        this.initRspResult(rsp.result);
    }

    @Override
    protected Collection<?> queryMoInfo(QAsnPortAvaiableBandwidthReq req, QAsnPortAvaiableBandwidthRsp rsp, Task task) throws VMFException {
        AsnTranslationContext context = new AsnTranslationContext();
        ArrayList<Port> portList = new ArrayList<Port>();
        InterfaceFdnParser ifmFdnParser = new InterfaceFdnParser();
        for (Object asn : req.portIndexList) {
            QAsnUniResID asnData = (QAsnUniResID)asn;
            Interface ifmMo = (Interface)ifmFdnParser.getIndexMo(asnData);
            Port port = new Port();
            port.setName(ifmMo.getIfName());
            port.setDevID(ifmMo.getDevID());
            portList.add(port);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection mosByName = new ArrayList();
        if (!portList.isEmpty()) {
            mosByName = dao.queryByFields(Port.class, new String[]{"devID", "name"}, portList, false);
        }
        this.ifmLst = new ArrayList<Interface>();
        this.teLst = new ArrayList<TeLink>();
        HashMap<TeLink, Port> teAndPortMap = new HashMap<TeLink, Port>();
        if (!CollectionUtils.isEmpty(mosByName)) {
            for (Port port : mosByName) {
                Interface ifm = new Interface();
                ifm.setDevID(port.getDevID());
                ifm.setVrID(port.getVrID());
                ifm.setIfName(port.getName());
                this.ifmLst.add(ifm);
                TeLink telink = new TeLink();
                telink.setDevID(port.getDevID());
                telink.setVrID(port.getVrID());
                telink.setInterfaceName(port.getName());
                this.teLst.add(telink);
                teAndPortMap.put(telink, port);
            }
        }
        List<Object> motypeWithInterface = this.queryMotypeWithInterface();
        Collection<TeLink> teDBLst = this.queryTEByPortName();
        if (!CollectionUtils.isEmpty(teDBLst)) {
            for (TeLink teData : teDBLst) {
                Port port = (Port)teAndPortMap.get(teData);
                port.addKeyRefMo((VmfMO)teData);
            }
        }
        List pairs = this.genPairs(mosByName, motypeWithInterface);
        return this.encode(pairs, (IAsnTranslationContext)context);
    }

    protected Collection<TeLink> queryTEByPortName() throws VMFException {
        Collection<Object> resIfms = new ArrayList<TeLink>();
        if (CollectionUtils.isEmpty(this.teLst)) {
            return resIfms;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            resIfms = dao.queryByKey(TeLink.class, this.teLst, false);
        }
        catch (VMFException e) {
            this.getLogger().debug("query interfaceInfo by queryTEByPortName is fail: " + (Object)((Object)e));
        }
        return resIfms;
    }

    @Override
    protected List<Object> queryMotypeWithInterface() throws VMFException {
        ArrayList<Object> resIfms = new ArrayList<Object>();
        if (CollectionUtils.isEmpty(this.ifmLst)) {
            return resIfms;
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        try {
            Collection ifms = dao.queryByKey(Interface.class, this.ifmLst, false);
            if (!CollectionUtils.isEmpty((Collection)ifms)) {
                for (Interface ifm : ifms) {
                    resIfms.add(ifm);
                }
            }
        }
        catch (VMFException e) {
            this.getLogger().debug("query QQueryPortAvaiableBandwidthTask by queryMotypeWithInterface is fail: " + (Object)((Object)e));
        }
        return resIfms;
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnPortAvaiableBandwidthRsp rsp) {
        rsp.portRemainBwList.addAll(queryAsns);
    }
}

