/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNeSlotNum;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNeStatSlotNumReq;
import com.huawei.network.qasn.m_q_inventory_slot.QAsnNeStatSlotNumRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.task.AbstractQQueryTask;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.dao.HolderDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class QQueryNeStatSlotNumTask
extends AbstractQQueryTask<QAsnNeStatSlotNumReq, QAsnNeStatSlotNumRsp> {
    private IDeviceService deviceService;

    public QQueryNeStatSlotNumTask() {
        try {
            this.deviceService = Activator.getDeviceService();
        }
        catch (VMFException e) {
            this.getLogger().error("get device service error.", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public Collection<?> queryMoInfo(QAsnNeStatSlotNumReq req, QAsnNeStatSlotNumRsp rsp, Task task) throws VMFException {
        HolderDao holderDao = (HolderDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, HolderDao.class);
        LinkedHashMap<Integer, QAsnNeSlotNum> deviceSlotNums = new LinkedHashMap<Integer, QAsnNeSlotNum>();
        String devName = null;
        QAsnNeSlotNum tmpAsnNeSlotNum = null;
        ArrayList<Integer> devIDs = new ArrayList<Integer>(req.objList.size());
        for (Object neID : req.objList) {
            devIDs.add(((BigInteger)neID).intValue());
        }
        Map<Integer, Long> totals = holderDao.queryTotalSlot(devIDs);
        Map<Integer, Long> usings = holderDao.queryUsingSlot(devIDs);
        for (Integer devID : devIDs) {
            devName = this.deviceService.getDevNameByID(devID.intValue());
            Long totalSlotNum = totals.get(devID);
            Long usingSlotNum = usings.get(devID);
            tmpAsnNeSlotNum = (QAsnNeSlotNum)deviceSlotNums.get(devID);
            if (null == tmpAsnNeSlotNum) {
                tmpAsnNeSlotNum = new QAsnNeSlotNum();
                tmpAsnNeSlotNum.neName = StringUtil.globalByte((String)devName);
                tmpAsnNeSlotNum.totalSlotNum = totalSlotNum == null ? 0 : totalSlotNum.intValue();
                tmpAsnNeSlotNum.usingSlotNum = usingSlotNum == null ? 0 : usingSlotNum.intValue();
                deviceSlotNums.put(devID, tmpAsnNeSlotNum);
                continue;
            }
            tmpAsnNeSlotNum.totalSlotNum = tmpAsnNeSlotNum.totalSlotNum + (totalSlotNum == null ? 0 : totalSlotNum.intValue());
            tmpAsnNeSlotNum.usingSlotNum = tmpAsnNeSlotNum.usingSlotNum + (usingSlotNum == null ? 0 : usingSlotNum.intValue());
        }
        return deviceSlotNums.values();
    }

    protected void handleErrorResult(VMFException e, QAsnNeStatSlotNumRsp rsp) {
        rsp.result = -1;
    }

    protected void initRspResult(QAsnNeStatSlotNumRsp rsp) {
        rsp.result = 0;
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnNeStatSlotNumRsp rsp) {
        rsp.neslotNumList.addAll(queryAsns);
    }
}

