/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnCPIndex;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnCPExInfo;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnQueryCPExInfoReq;
import com.huawei.network.qasn.m_q_inventory_cp.QAsnQueryCPExInfoRsp;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.inventory.model.Board;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.RuModuleInfo;
import com.huawei.vmf.adapter.inventory.task.AbstractQQueryMoTypeWithRuModuleTask;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCPExInfoTranslator;
import com.huawei.vmf.adapter.inventory.translation.asn.QAsnCPIndexTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.commustru.fstru.FStruct;

public class QQueryCPExInfoTask
extends AbstractQQueryMoTypeWithRuModuleTask<QAsnQueryCPExInfoReq, QAsnQueryCPExInfoRsp, Card> {
    QQueryCPExInfoTask() {
        super((IAsnTranslator)new QAsnCPExInfoTranslator());
    }

    protected Class<? extends FStruct> getQueryAsnType() {
        return QAsnCPExInfo.class;
    }

    protected void handleErrorResult(VMFException e, QAsnQueryCPExInfoRsp rsp) {
        this.handleErrorResult(e, rsp.result);
    }

    protected void initRspResult(QAsnQueryCPExInfoRsp rsp) {
        this.initRspResult(rsp.result);
    }

    @Override
    protected Collection<?> queryMoInfo(QAsnQueryCPExInfoReq req, QAsnQueryCPExInfoRsp rsp, Task task) throws VMFException {
        Collection subCards;
        ArrayList moIndexs = new ArrayList();
        QAsnCPIndexTranslator asnCPIndexTranslator = new QAsnCPIndexTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        context.setTemplate((FStruct)req.attrTemplate);
        for (Object asn : req.cpIndexList) {
            asnCPIndexTranslator.decode((FStruct)((QAsnCPIndex)asn), moIndexs, (IAsnTranslationContext)context);
        }
        ArrayList<Card> boardIndexs = new ArrayList<Card>();
        ArrayList<Card> subCardIndexs = new ArrayList<Card>();
        for (Card moIndex : moIndexs) {
            if (moIndex instanceof Board) {
                boardIndexs.add(moIndex);
                continue;
            }
            subCardIndexs.add(moIndex);
        }
        ArrayList mos = new ArrayList();
        Collection boards = this.queryMoInfos(boardIndexs);
        if (null != boards) {
            mos.addAll(boards);
        }
        if (null != (subCards = this.queryMoInfos(subCardIndexs))) {
            mos.addAll(subCards);
        }
        HashSet<RuModuleInfo> ruModules = new HashSet<RuModuleInfo>();
        for (Card moType : mos) {
            RuModuleInfo module = new RuModuleInfo();
            module.setDevID(moType.getDevID());
            module.setPhyIndex(moType.getEntIndex());
            ruModules.add(module);
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection ruModuleInfos = dao.queryByKey(RuModuleInfo.class, ruModules, false);
        return this.encode(this.genPairs(mos, ruModuleInfos), (IAsnTranslationContext)context);
    }

    protected void setQueryResults(Collection<?> queryAsns, QAsnQueryCPExInfoRsp rsp) {
        rsp.cpExInfoList.addAll(queryAsns);
    }
}

