/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Card;
import com.huawei.vmf.adapter.fservice.inventory.model.SubCard;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnCardInfoTranslator;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityGetInvResInfoRsp;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import com.huawei.vmf.adaptor.inventory.asn.AsnEntityGetEntityResInfoReq;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoQuerySubCardInfoTask {
    private static final Logger logger = LoggerFactory.getLogger(DoQuerySubCardInfoTask.class);
    private IDeviceService deviceService;
    private AsnEntityGetEntityResInfoReq req;
    private AsnEmlEntityGetInvResInfoRsp rsp;
    private IAsnTranslator<AsnEmlEntityInvResInfo, Card> translator;

    public DoQuerySubCardInfoTask(AsnEntityGetEntityResInfoReq req, AsnEmlEntityGetInvResInfoRsp rsp) {
        this.req = req;
        this.rsp = rsp;
        this.translator = new FInventoryAsnCardInfoTranslator();
    }

    public SubCard decode(SubCard card) {
        card.setDevID(Integer.valueOf(this.req.iDevID.intValue()));
        card.setChassisID(Integer.valueOf(this.req.iFrameNum.intValue()));
        card.setSlotID(Integer.valueOf(this.req.iSlotNum.intValue()));
        card.setParentRelPosition(Integer.valueOf(this.req.iSubSlotNum.intValue()));
        return card;
    }

    public Card getSubCardInfo(SubCard card) throws VMFException {
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        Collection subcards = dao.queryByKey(SubCard.class, Arrays.asList(card), false);
        return subcards.isEmpty() ? null : (SubCard)subcards.iterator().next();
    }

    public void query() {
        this.rsp.iErrCode = BigInteger.valueOf(0L);
        SubCard cardIndex = this.decode(new SubCard());
        try {
            Card card = this.getSubCardInfo(cardIndex);
            if (null == card) {
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("devTypeName", this.getDeviceService().getDevNameByID(this.req.iDevID.intValue()));
            AsnTranslationContext context = new AsnTranslationContext(properties);
            AsnEmlEntityInvResInfo oEntityResInfo = new AsnEmlEntityInvResInfo();
            this.translator.encode((Object)card, (FStruct)oEntityResInfo, (IAsnTranslationContext)context);
            this.rsp.oEntityResInfo = oEntityResInfo;
        }
        catch (VMFException e) {
            logger.error("Query card info error. cardIndex=" + cardIndex, (Throwable)e);
            this.rsp.iErrCode = BigInteger.valueOf(e.getErrorCode());
        }
    }

    private IDeviceService getDeviceService() throws VMFException {
        if (null == this.deviceService) {
            this.deviceService = Activator.getDeviceService();
        }
        return this.deviceService;
    }
}

