/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnPortInfoTranslator;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityGetInvResInfoRsp;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import com.huawei.vmf.adaptor.inventory.asn.AsnEntityGetEntityResInfoReq;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoQueryPortInfoTask {
    private static Logger logger = LoggerFactory.getLogger(DoQueryPortInfoTask.class);
    private IDeviceService deviceService;
    private AsnEntityGetEntityResInfoReq req = null;
    private AsnEmlEntityGetInvResInfoRsp rsp = null;
    private IAsnTranslator<AsnEmlEntityInvResInfo, Port> translator = null;

    public DoQueryPortInfoTask(AsnEntityGetEntityResInfoReq req, AsnEmlEntityGetInvResInfoRsp rsp) {
        this.req = req;
        this.rsp = rsp;
        this.translator = new FInventoryAsnPortInfoTranslator();
    }

    public void query() {
        this.rsp.iErrCode = BigInteger.valueOf(0L);
        try {
            Port portIndex = new Port();
            portIndex.setDevID(Integer.valueOf(this.req.iDevID.intValue()));
            portIndex.setChassisID(Integer.valueOf(this.req.iFrameNum.intValue()));
            portIndex.setSlotID(Integer.valueOf(this.req.iSlotNum.intValue()));
            portIndex.setSubSlotID(Integer.valueOf(this.req.iSubSlotNum.intValue()));
            portIndex.setParentRelPosition(Integer.valueOf(this.req.iPortNum.intValue()));
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection ports = dao.queryByKey(Port.class, Arrays.asList(portIndex), false);
            if (ports.isEmpty()) {
                this.rsp.iErrCode = BigInteger.valueOf(1107498871L);
                return;
            }
            portIndex = (Port)ports.iterator().next();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("devTypeName", this.getDeviceService().getDevNameByID(this.req.iDevID.intValue()));
            AsnTranslationContext context = new AsnTranslationContext(properties);
            AsnEmlEntityInvResInfo resInfo = new AsnEmlEntityInvResInfo();
            this.translator.encode((Object)portIndex, (FStruct)resInfo, (IAsnTranslationContext)context);
            this.rsp.oEntityResInfo = resInfo;
        }
        catch (VMFException e) {
            this.rsp.iErrCode = BigInteger.valueOf(e.getErrorCode());
            logger.error("inventory query port info failed :", (Throwable)e);
        }
    }

    private IDeviceService getDeviceService() throws VMFException {
        if (null == this.deviceService) {
            this.deviceService = Activator.getDeviceService();
        }
        return this.deviceService;
    }
}

