/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.inventory.task;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslator;
import com.huawei.vmf.adapter.fservice.devicemgr.service.IDeviceService;
import com.huawei.vmf.adapter.fservice.inventory.model.PhyEntity;
import com.huawei.vmf.adapter.fservice.inventory.model.Port;
import com.huawei.vmf.adapter.inventory.Activator;
import com.huawei.vmf.adapter.inventory.translation.asn.FInventoryAsnPortInfoTranslator;
import com.huawei.vmf.adaptor.inventory.asn.AsnAddPortMarkerFieldReq;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityGetInvResInfoListRsp;
import com.huawei.vmf.adaptor.inventory.asn.AsnEmlEntityInvResInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DoQueryPortInfoListTask {
    private static Logger logger = LoggerFactory.getLogger(DoQueryPortInfoListTask.class);
    private IDeviceService deviceService;
    private AsnAddPortMarkerFieldReq req;
    private AsnEmlEntityGetInvResInfoListRsp rsp;
    private IAsnTranslator<AsnEmlEntityInvResInfo, Port> translator;

    public DoQueryPortInfoListTask(AsnAddPortMarkerFieldReq req, AsnEmlEntityGetInvResInfoListRsp rsp) {
        this.req = req;
        this.rsp = rsp;
        this.translator = new FInventoryAsnPortInfoTranslator();
    }

    public Collection<Port> getPortList() throws VMFException {
        Port portIndex = new Port();
        portIndex.setDevID(Integer.valueOf(this.req.iDevID.intValue()));
        portIndex.setChassisID(Integer.valueOf(this.req.iFrameNum.intValue()));
        portIndex.setSlotID(Integer.valueOf(this.req.iSlotNum.intValue()));
        int subSlotId = this.req.iSubSlotNum.intValue();
        if (subSlotId >= 0) {
            portIndex.setSubSlotID(Integer.valueOf(subSlotId));
        }
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        return dao.queryByKey(Port.class, Arrays.asList(portIndex), false);
    }

    public void query() {
        this.rsp.iErrCode = BigInteger.valueOf(0L);
        try {
            Collection<Port> portList = this.getPortList();
            if (CollectionUtils.isEmpty(portList)) {
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("devTypeName", this.getDeviceService().getDevNameByID(this.req.iDevID.intValue()));
            AsnTranslationContext context = new AsnTranslationContext(properties);
            ArrayList<AsnEmlEntityInvResInfo> asnEntityResInfoLst = new ArrayList<AsnEmlEntityInvResInfo>();
            AsnEmlEntityInvResInfo oEntityResInfo = null;
            for (Port port : portList) {
                if (Integer.valueOf(PhyEntity.ENT_OPER_STATE_ENUM.OFFLINE).equals(port.getOperStatus())) continue;
                oEntityResInfo = new AsnEmlEntityInvResInfo();
                this.translator.encode((Object)port, (FStruct)oEntityResInfo, (IAsnTranslationContext)context);
                asnEntityResInfoLst.add(oEntityResInfo);
            }
            this.rsp.lstEntityInfo.addAll(asnEntityResInfoLst);
        }
        catch (VMFException e) {
            this.rsp.iErrCode = BigInteger.valueOf(e.getErrorCode());
            logger.error("inventory query portlist failed :", (Throwable)e);
        }
    }

    private IDeviceService getDeviceService() throws VMFException {
        if (null == this.deviceService) {
            this.deviceService = Activator.getDeviceService();
        }
        return this.deviceService;
    }
}

